/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.topologies;

import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.flows.FlowInterface;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;

public class FlowNode
implements TenantInterface {
    @NotNull
    String uid;
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    String namespace;
    String id;

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNode flowNode = (FlowNode)o;
        return Objects.equals(this.uid, flowNode.uid);
    }

    public int hashCode() {
        return Objects.hash(this.uid);
    }

    public static FlowNode of(FlowInterface flow) {
        return ((FlowNodeBuilder)((FlowNodeBuilder)((FlowNodeBuilder)((FlowNodeBuilder)FlowNode.builder().uid(flow.uidWithoutRevision())).tenantId(flow.getTenantId())).namespace(flow.getNamespace())).id(flow.getId())).build();
    }

    @Generated
    protected FlowNode(FlowNodeBuilder<?, ?> b) {
        this.uid = b.uid;
        this.tenantId = b.tenantId;
        this.namespace = b.namespace;
        this.id = b.id;
    }

    @Generated
    public static FlowNodeBuilder<?, ?> builder() {
        return new FlowNodeBuilderImpl();
    }

    @Generated
    public FlowNodeBuilder<?, ?> toBuilder() {
        return new FlowNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @ConstructorProperties(value={"uid", "tenantId", "namespace", "id"})
    @Generated
    public FlowNode(String uid, String tenantId, String namespace, String id) {
        this.uid = uid;
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.id = id;
    }

    @Generated
    public static abstract class FlowNodeBuilder<C extends FlowNode, B extends FlowNodeBuilder<C, B>> {
        @Generated
        private String uid;
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String id;

        @Generated
        protected B $fillValuesFrom(C instance) {
            FlowNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowNode instance, FlowNodeBuilder<?, ?> b) {
            b.uid(instance.uid);
            b.tenantId(instance.tenantId);
            b.namespace(instance.namespace);
            b.id(instance.id);
        }

        @Generated
        public B uid(String uid) {
            this.uid = uid;
            return this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "FlowNode.FlowNodeBuilder(uid=" + this.uid + ", tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", id=" + this.id + ")";
        }
    }

    @Generated
    private static final class FlowNodeBuilderImpl
    extends FlowNodeBuilder<FlowNode, FlowNodeBuilderImpl> {
        @Generated
        private FlowNodeBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowNodeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowNode build() {
            return new FlowNode(this);
        }
    }
}

