/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.kestra.core.validations.NoSystemLabelValidation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="A backfill configuration.")
public class Backfill {
    @Schema(title="The start date.")
    @NotNull
    ZonedDateTime start;
    @Schema(title="The end date.")
    ZonedDateTime end;
    @Schema(title="The current date of the backfill being done.")
    ZonedDateTime currentDate;
    @Schema(title="Whether the backfill is paused.")
    @JsonInclude
    Boolean paused;
    @Schema(title="The inputs to pass to the backfilled executions.")
    @PluginProperty(dynamic=true)
    private Map<String, Object> inputs;
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    @Schema(title="The labels to pass to the backfilled executions.")
    List<@NoSystemLabelValidation Label> labels;
    @Schema(title="The nextExecutionDate before the backfill was created.")
    ZonedDateTime previousNextExecutionDate;

    public Backfill(ZonedDateTime start, ZonedDateTime end, ZonedDateTime currentDate, Boolean paused, Map<String, Object> inputs, List<Label> labels, ZonedDateTime previousNextExecutionDate) {
        this.start = start;
        this.end = end;
        this.currentDate = start;
        this.paused = paused != null ? paused : false;
        this.inputs = inputs;
        this.labels = labels;
        this.previousNextExecutionDate = previousNextExecutionDate;
    }

    @Generated
    private static Boolean $default$paused() {
        return false;
    }

    @Generated
    protected Backfill(BackfillBuilder<?, ?> b) {
        this.start = b.start;
        this.end = b.end;
        this.currentDate = b.currentDate;
        this.paused = b.paused$set ? b.paused$value : Backfill.$default$paused();
        this.inputs = b.inputs;
        this.labels = b.labels;
        this.previousNextExecutionDate = b.previousNextExecutionDate;
    }

    @Generated
    public static BackfillBuilder<?, ?> builder() {
        return new BackfillBuilderImpl();
    }

    @Generated
    public BackfillBuilder<?, ?> toBuilder() {
        return new BackfillBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public ZonedDateTime getStart() {
        return this.start;
    }

    @Generated
    public ZonedDateTime getEnd() {
        return this.end;
    }

    @Generated
    public ZonedDateTime getCurrentDate() {
        return this.currentDate;
    }

    @Generated
    public Boolean getPaused() {
        return this.paused;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<@NoSystemLabelValidation Label> getLabels() {
        return this.labels;
    }

    @Generated
    public ZonedDateTime getPreviousNextExecutionDate() {
        return this.previousNextExecutionDate;
    }

    @Generated
    public Backfill() {
        this.paused = Backfill.$default$paused();
    }

    @Generated
    public static abstract class BackfillBuilder<C extends Backfill, B extends BackfillBuilder<C, B>> {
        @Generated
        private ZonedDateTime start;
        @Generated
        private ZonedDateTime end;
        @Generated
        private ZonedDateTime currentDate;
        @Generated
        private boolean paused$set;
        @Generated
        private Boolean paused$value;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private List<@NoSystemLabelValidation Label> labels;
        @Generated
        private ZonedDateTime previousNextExecutionDate;

        @Generated
        protected B $fillValuesFrom(C instance) {
            BackfillBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Backfill instance, BackfillBuilder<?, ?> b) {
            b.start(instance.start);
            b.end(instance.end);
            b.currentDate(instance.currentDate);
            b.paused(instance.paused);
            b.inputs(instance.inputs);
            b.labels(instance.labels);
            b.previousNextExecutionDate(instance.previousNextExecutionDate);
        }

        @Generated
        public B start(ZonedDateTime start) {
            this.start = start;
            return this.self();
        }

        @Generated
        public B end(ZonedDateTime end) {
            this.end = end;
            return this.self();
        }

        @Generated
        public B currentDate(ZonedDateTime currentDate) {
            this.currentDate = currentDate;
            return this.self();
        }

        @Generated
        public B paused(Boolean paused) {
            this.paused$value = paused;
            this.paused$set = true;
            return this.self();
        }

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return this.self();
        }

        @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
        @Generated
        public B labels(List<@NoSystemLabelValidation Label> labels) {
            this.labels = labels;
            return this.self();
        }

        @Generated
        public B previousNextExecutionDate(ZonedDateTime previousNextExecutionDate) {
            this.previousNextExecutionDate = previousNextExecutionDate;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Backfill.BackfillBuilder(start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ", currentDate=" + String.valueOf(this.currentDate) + ", paused$value=" + this.paused$value + ", inputs=" + String.valueOf(this.inputs) + ", labels=" + String.valueOf(this.labels) + ", previousNextExecutionDate=" + String.valueOf(this.previousNextExecutionDate) + ")";
        }
    }

    @Generated
    private static final class BackfillBuilderImpl
    extends BackfillBuilder<Backfill, BackfillBuilderImpl> {
        @Generated
        private BackfillBuilderImpl() {
        }

        @Override
        @Generated
        protected BackfillBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Backfill build() {
            return new Backfill(this);
        }
    }
}

