/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.models.triggers.StatefulTriggerInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class StatefulTriggerService {
    public static Map<String, Entry> readState(RunContext runContext, String key, Optional<Duration> ttl) {
        try {
            Optional<KVValue> kv = runContext.namespaceKv(runContext.flowInfo().namespace()).getValue(key);
            if (kv.isEmpty()) {
                return new HashMap<String, Entry>();
            }
            List entries = (List)JacksonMapper.ofJson().readValue((byte[])kv.get().value(), (TypeReference)new TypeReference<List<Entry>>(){});
            Instant cutoff = ttl.map(d -> Instant.now().minus((TemporalAmount)d)).orElse(Instant.MIN);
            return entries.stream().filter(e -> Optional.ofNullable(e.lastSeenAt()).orElse(Instant.now()).isAfter(cutoff)).collect(Collectors.toMap(Entry::uri, e -> e));
        }
        catch (Exception e2) {
            runContext.logger().warn("readState failed", (Throwable)e2);
            return new HashMap<String, Entry>();
        }
    }

    public static void writeState(RunContext runContext, String key, Map<String, Entry> state, Optional<Duration> ttl) {
        try {
            byte[] bytes = JacksonMapper.ofJson().writeValueAsBytes(state.values());
            KVMetadata meta = new KVMetadata("trigger state", ttl.orElse(null));
            runContext.namespaceKv(runContext.flowInfo().namespace()).put(key, new KVValueAndMetadata(meta, bytes));
        }
        catch (Exception e) {
            runContext.logger().warn("writeState failed", (Throwable)e);
        }
    }

    public static StateUpdate computeAndUpdateState(Map<String, Entry> state, Entry candidate, StatefulTriggerInterface.On on) {
        Entry prev = state.get(candidate.uri());
        boolean isNew = prev == null;
        boolean fire = StatefulTriggerService.shouldFire(prev, candidate.version(), on);
        Instant lastSeenAt = fire || isNew ? Instant.now() : (prev.lastSeenAt() != null ? prev.lastSeenAt() : Instant.now());
        Entry newEntry = new Entry(candidate.uri(), candidate.version(), candidate.modifiedAt(), lastSeenAt);
        state.put(candidate.uri(), newEntry);
        return new StateUpdate(fire, isNew);
    }

    public static boolean shouldFire(Entry prev, String version, StatefulTriggerInterface.On on) {
        if (prev == null) {
            return on == StatefulTriggerInterface.On.CREATE || on == StatefulTriggerInterface.On.CREATE_OR_UPDATE;
        }
        if (!Objects.equals(prev.version(), version)) {
            return on == StatefulTriggerInterface.On.UPDATE || on == StatefulTriggerInterface.On.CREATE_OR_UPDATE;
        }
        return false;
    }

    public static String defaultKey(String ns, String flowId, String triggerId) {
        return String.join((CharSequence)"_", ns, flowId, triggerId);
    }

    public record Entry(String uri, String version, Instant modifiedAt, Instant lastSeenAt) {
        public static Entry candidate(String uri, String version, Instant modifiedAt) {
            return new Entry(uri, version, modifiedAt, null);
        }
    }

    public record StateUpdate(boolean fire, boolean isNew) {
    }
}

