/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.multipleflows;

import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.triggers.TimeWindow;
import io.kestra.core.models.triggers.multipleflows.MultipleCondition;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public interface MultipleConditionStorageInterface {
    public Optional<MultipleConditionWindow> get(FlowId var1, String var2);

    public List<MultipleConditionWindow> expired(String var1);

    default public MultipleConditionWindow getOrCreate(FlowId flow, MultipleCondition multipleCondition, Map<String, Object> outputs) {
        ZonedDateTime now = ZonedDateTime.now().withNano(0);
        TimeWindow timeWindow = multipleCondition.getTimeWindow() != null ? multipleCondition.getTimeWindow() : TimeWindow.builder().build();
        TimeWindow.Type type = timeWindow.getType() != null ? timeWindow.getType() : TimeWindow.Type.DURATION_WINDOW;
        Pair startAndEnd = switch (type) {
            default -> throw new MatchException(null, null);
            case TimeWindow.Type.DURATION_WINDOW -> {
                Duration window;
                Duration v0 = window = timeWindow.getWindow() == null ? Duration.ofDays(1L) : timeWindow.getWindow();
                if (window.toDays() > 0L) {
                    now = now.withHour(0);
                }
                if (window.toHours() > 0L) {
                    now = now.withMinute(0);
                }
                if (window.toMinutes() > 0L) {
                    now = now.withSecond(0).withMinute(0).plusMinutes(window.toMinutes() * ((long)now.getMinute() / window.toMinutes()));
                }
                ZonedDateTime startWindow = timeWindow.getWindowAdvance() == null ? now : now.plus(timeWindow.getWindowAdvance()).truncatedTo(ChronoUnit.MILLIS);
                yield Pair.of((Object)startWindow, (Object)startWindow.plus(window).minus(Duration.ofMillis(1L)).truncatedTo(ChronoUnit.MILLIS));
            }
            case TimeWindow.Type.SLIDING_WINDOW -> Pair.of((Object)now.truncatedTo(ChronoUnit.MILLIS), (Object)now.truncatedTo(ChronoUnit.MILLIS).plus(timeWindow.getWindow() == null ? Duration.ofDays(1L) : timeWindow.getWindow()));
            case TimeWindow.Type.DAILY_TIME_WINDOW -> Pair.of((Object)now.truncatedTo(ChronoUnit.DAYS).plusSeconds(timeWindow.getStartTime().toSecondOfDay()), (Object)now.truncatedTo(ChronoUnit.DAYS).plusSeconds(timeWindow.getEndTime().toSecondOfDay()));
            case TimeWindow.Type.DAILY_TIME_DEADLINE -> Pair.of((Object)now.truncatedTo(ChronoUnit.DAYS), (Object)now.truncatedTo(ChronoUnit.DAYS).plusSeconds(timeWindow.getDeadline().toSecondOfDay()));
        };
        return this.get(flow, multipleCondition.getId()).filter(m -> m.isValid(ZonedDateTime.now())).orElseGet(() -> MultipleConditionWindow.builder().namespace(flow.getNamespace()).flowId(flow.getId()).tenantId(flow.getTenantId()).conditionId(multipleCondition.getId()).start((ZonedDateTime)startAndEnd.getLeft()).end((ZonedDateTime)startAndEnd.getRight()).results(new HashMap<String, Boolean>()).outputs(outputs).build());
    }

    public void save(List<MultipleConditionWindow> var1);

    public void delete(MultipleConditionWindow var1);
}

