/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.validations;

import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class ManualPath
implements Path {
    final Deque<Path.Node> nodes = new LinkedList<Path.Node>();

    public ManualPath(Path.Node node) {
        this.nodes.add(node);
    }

    public Iterator<Path.Node> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Path.Node> i = this.nodes.iterator();
        while (i.hasNext()) {
            Path.Node node = i.next();
            builder.append(node.getName());
            if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
                Integer index = node.getIndex();
                if (index != null) {
                    builder.append('[').append(index).append(']');
                } else {
                    Object key = node.getKey();
                    if (key != null) {
                        builder.append('[').append(key).append(']');
                    } else {
                        builder.append("[]");
                    }
                }
            }
            if (!i.hasNext()) continue;
            builder.append('.');
        }
        return builder.toString();
    }
}

