/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.app.AppBlockInterface;
import io.kestra.core.app.AppPluginInterface;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.charts.Chart;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.logs.LogExporter;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.AdditionalPlugin;
import io.kestra.core.plugins.ExternalPlugin;
import io.kestra.core.plugins.PluginClassLoader;
import io.kestra.core.plugins.PluginResolver;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.secret.SecretPluginInterface;
import io.kestra.core.storages.StorageInterface;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginScanner.class);
    ClassLoader parent;

    public PluginScanner(ClassLoader parent) {
        this.parent = parent;
    }

    public List<RegisteredPlugin> scan(Path pluginPaths) {
        long start = System.currentTimeMillis();
        List<RegisteredPlugin> scanResult = new PluginResolver(pluginPaths).resolves().parallelStream().map(plugin -> {
            log.debug("Loading plugins from path: {}", (Object)plugin.getLocation());
            PluginClassLoader classLoader = PluginClassLoader.of(plugin.getLocation(), plugin.getResources(), this.parent);
            log.debug("Scanning plugins from paths '{}' with classLoader '{}'", (Object)Arrays.stream(plugin.getResources()).map(URL::getPath).collect(Collectors.joining("", "\n\t", "")), (Object)classLoader);
            return this.scanClassLoader(classLoader, (ExternalPlugin)plugin, null);
        }).filter(RegisteredPlugin::isValid).toList();
        int nbPlugins = scanResult.stream().mapToInt(registeredPlugin -> registeredPlugin.allClass().size()).sum();
        log.info("Registered {} plugins from {} groups (scan done in {}ms)", new Object[]{nbPlugins, scanResult.size(), System.currentTimeMillis() - start});
        return scanResult;
    }

    public RegisteredPlugin scan() {
        try {
            long start = System.currentTimeMillis();
            Manifest manifest = new Manifest(IOUtils.toInputStream((String)"Manifest-Version: 1.0\nX-Kestra-Title: core\nX-Kestra-Group: io.kestra.plugin.core\n", (Charset)StandardCharsets.UTF_8));
            RegisteredPlugin corePlugin = this.scanClassLoader(PluginScanner.class.getClassLoader(), null, manifest);
            log.info("Registered {} core plugins (scan done in {}ms)", (Object)corePlugin.allClass().size(), (Object)(System.currentTimeMillis() - start));
            return corePlugin;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RegisteredPlugin scanClassLoader(ClassLoader classLoader, ExternalPlugin externalPlugin, Manifest manifest) {
        ArrayList<Class<? extends Task>> tasks = new ArrayList<Class<? extends Task>>();
        ArrayList<Class<? extends AbstractTrigger>> triggers = new ArrayList<Class<? extends AbstractTrigger>>();
        ArrayList<Class<? extends Condition>> conditions = new ArrayList<Class<? extends Condition>>();
        ArrayList<Class<? extends StorageInterface>> storages = new ArrayList<Class<? extends StorageInterface>>();
        ArrayList<Class<? extends SecretPluginInterface>> secrets = new ArrayList<Class<? extends SecretPluginInterface>>();
        ArrayList taskRunners = new ArrayList();
        ArrayList<Class<? extends AppPluginInterface>> apps = new ArrayList<Class<? extends AppPluginInterface>>();
        ArrayList<Class<? extends AppBlockInterface>> appBlocks = new ArrayList<Class<? extends AppBlockInterface>>();
        ArrayList charts = new ArrayList();
        ArrayList dataFilters = new ArrayList();
        ArrayList dataFiltersKPI = new ArrayList();
        ArrayList logExporter = new ArrayList();
        ArrayList<Class<? extends AdditionalPlugin>> additionalPlugins = new ArrayList<Class<? extends AdditionalPlugin>>();
        ArrayList<String> guides = new ArrayList<String>();
        HashMap aliases = new HashMap();
        if (manifest == null) {
            manifest = PluginScanner.getManifest(classLoader);
        }
        ServiceLoader<Plugin> sl = ServiceLoader.load(Plugin.class, classLoader);
        try {
            for (Plugin plugin : sl) {
                Plugin plugin2;
                if (plugin.getClass().isAnnotationPresent(Hidden.class)) continue;
                Objects.requireNonNull(plugin);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Task.class, AbstractTrigger.class, Condition.class, StorageInterface.class, SecretPluginInterface.class, TaskRunner.class, AppPluginInterface.class, AppBlockInterface.class, Chart.class, DataFilter.class, DataFilterKPI.class, LogExporter.class, AdditionalPlugin.class}, (Object)plugin2, n)) {
                    case 0: {
                        Task task = (Task)plugin2;
                        log.debug("Loading Task plugin: '{}'", (Object)plugin.getClass());
                        tasks.add(task.getClass());
                        break;
                    }
                    case 1: {
                        AbstractTrigger trigger = (AbstractTrigger)plugin2;
                        log.debug("Loading Trigger plugin: '{}'", (Object)plugin.getClass());
                        triggers.add(trigger.getClass());
                        break;
                    }
                    case 2: {
                        Condition condition = (Condition)plugin2;
                        log.debug("Loading Condition plugin: '{}'", (Object)plugin.getClass());
                        conditions.add(condition.getClass());
                        break;
                    }
                    case 3: {
                        StorageInterface storage = (StorageInterface)plugin2;
                        log.debug("Loading Storage plugin: '{}'", (Object)plugin.getClass());
                        storages.add(storage.getClass());
                        break;
                    }
                    case 4: {
                        SecretPluginInterface storage = (SecretPluginInterface)plugin2;
                        log.debug("Loading Secret plugin: '{}'", (Object)plugin.getClass());
                        secrets.add(storage.getClass());
                        break;
                    }
                    case 5: {
                        TaskRunner runner = (TaskRunner)plugin2;
                        log.debug("Loading TaskRunner plugin: '{}'", (Object)plugin.getClass());
                        taskRunners.add(runner.getClass());
                        break;
                    }
                    case 6: {
                        AppPluginInterface app = (AppPluginInterface)plugin2;
                        log.debug("Loading App plugin: '{}'", (Object)plugin.getClass());
                        apps.add(app.getClass());
                        break;
                    }
                    case 7: {
                        AppBlockInterface appBlock = (AppBlockInterface)plugin2;
                        log.debug("Loading AppBlock plugin: '{}'", (Object)plugin.getClass());
                        appBlocks.add(appBlock.getClass());
                        break;
                    }
                    case 8: {
                        Chart chart = (Chart)plugin2;
                        log.debug("Loading Chart plugin: '{}'", (Object)plugin.getClass());
                        charts.add(chart.getClass());
                        break;
                    }
                    case 9: {
                        DataFilter dataFilter = (DataFilter)plugin2;
                        log.debug("Loading DataFilter plugin: '{}'", (Object)plugin.getClass());
                        dataFilters.add(dataFilter.getClass());
                        break;
                    }
                    case 10: {
                        DataFilterKPI dataFilterKPI = (DataFilterKPI)plugin2;
                        log.debug("Loading DataFilterKPI plugin: '{}'", (Object)plugin.getClass());
                        dataFiltersKPI.add(dataFilterKPI.getClass());
                        break;
                    }
                    case 11: {
                        LogExporter shipper = (LogExporter)plugin2;
                        log.debug("Loading LogExporter plugin: '{}'", (Object)plugin.getClass());
                        logExporter.add(shipper.getClass());
                        break;
                    }
                    case 12: {
                        AdditionalPlugin additionalPlugin = (AdditionalPlugin)plugin2;
                        log.debug("Loading additional plugin: '{}'", (Object)plugin.getClass());
                        additionalPlugins.add(additionalPlugin.getClass());
                        break;
                    }
                }
                Plugin.getAliases((Class)plugin.getClass()).forEach(alias -> aliases.put(alias, plugin.getClass()));
            }
        }
        catch (NoClassDefFoundError | ServiceConfigurationError e2) {
            Object location = externalPlugin != null ? externalPlugin.getLocation() : "core";
            log.error("Unable to load all plugin classes from '{}'. Cause: [{}] {}", new Object[]{location, e2.getClass().getSimpleName(), e2.getMessage(), e2});
        }
        URL guidesDirectory = classLoader.getResource("doc/guides");
        if (guidesDirectory != null) {
            try {
                Path root = Path.of(guidesDirectory.toURI());
                PluginScanner.addGuides(root, guides);
            }
            catch (IOException | URISyntaxException root) {
            }
            catch (FileSystemNotFoundException e3) {
                PluginScanner.addGuidesThroughNewFileSystem(guidesDirectory, guides);
            }
        }
        return RegisteredPlugin.builder().externalPlugin(externalPlugin).manifest(manifest).classLoader(classLoader).tasks(tasks).triggers(triggers).conditions(conditions).storages(storages).secrets(secrets).apps(apps).appBlocks(appBlocks).taskRunners(taskRunners).charts(charts).dataFilters(dataFilters).dataFiltersKPI(dataFiltersKPI).guides(guides).logExporters(logExporter).additionalPlugins(additionalPlugins).aliases(aliases.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), Function.identity()))).build();
    }

    private static void addGuidesThroughNewFileSystem(URL guidesDirectory, List<String> guides) {
        try (FileSystem fileSystem = FileSystems.newFileSystem(guidesDirectory.toURI(), Collections.emptyMap());){
            Path root = fileSystem.getPath("doc/guides", new String[0]);
            PluginScanner.addGuides(root, guides);
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private static void addGuides(Path root, List<String> guides) throws IOException {
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparing(path -> path.getName(path.getParent().getNameCount()).toString())).forEach(guide -> {
                String guideName = guide.getName(guide.getParent().getNameCount()).toString();
                guides.add(guideName.substring(0, guideName.lastIndexOf(46)));
            });
        }
    }

    public static Manifest getManifest(ClassLoader classLoader) {
        try {
            URL url = classLoader.getResource("META-INF/MANIFEST.MF");
            if (url != null) {
                return new Manifest(url.openStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

