/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.app.AppBlockInterface;
import io.kestra.core.app.AppPluginInterface;
import io.kestra.core.models.annotations.PluginSubGroup;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.charts.Chart;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.logs.LogExporter;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.AdditionalPlugin;
import io.kestra.core.plugins.ExternalPlugin;
import io.kestra.core.secret.SecretPluginInterface;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.Rethrow;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;

public class RegisteredPlugin {
    public static final String TASKS_GROUP_NAME = "tasks";
    public static final String TRIGGERS_GROUP_NAME = "triggers";
    public static final String CONDITIONS_GROUP_NAME = "conditions";
    public static final String STORAGES_GROUP_NAME = "storages";
    public static final String SECRETS_GROUP_NAME = "secrets";
    public static final String TASK_RUNNERS_GROUP_NAME = "task-runners";
    public static final String APPS_GROUP_NAME = "apps";
    public static final String APP_BLOCKS_GROUP_NAME = "app-blocks";
    public static final String CHARTS_GROUP_NAME = "charts";
    public static final String DATA_FILTERS_GROUP_NAME = "data-filters";
    public static final String DATA_FILTERS_KPI_GROUP_NAME = "data-filters-kpi";
    public static final String LOG_EXPORTERS_GROUP_NAME = "log-exporters";
    public static final String ADDITIONAL_PLUGINS_GROUP_NAME = "additional-plugins";
    private final ExternalPlugin externalPlugin;
    private final Manifest manifest;
    private final ClassLoader classLoader;
    private final List<Class<? extends Task>> tasks;
    private final List<Class<? extends AbstractTrigger>> triggers;
    private final List<Class<? extends Condition>> conditions;
    private final List<Class<? extends StorageInterface>> storages;
    private final List<Class<? extends SecretPluginInterface>> secrets;
    private final List<Class<? extends TaskRunner<?>>> taskRunners;
    private final List<Class<? extends AppPluginInterface>> apps;
    private final List<Class<? extends AppBlockInterface>> appBlocks;
    private final List<Class<? extends Chart<?>>> charts;
    private final List<Class<? extends DataFilter<?, ?>>> dataFilters;
    private final List<Class<? extends DataFilterKPI<?, ?>>> dataFiltersKPI;
    private final List<Class<? extends LogExporter<?>>> logExporters;
    private final List<Class<? extends AdditionalPlugin>> additionalPlugins;
    private final List<String> guides;
    private final Map<String, Map.Entry<String, Class<?>>> aliases;

    public boolean isValid() {
        return !this.tasks.isEmpty() || !this.triggers.isEmpty() || !this.conditions.isEmpty() || !this.storages.isEmpty() || !this.secrets.isEmpty() || !this.taskRunners.isEmpty() || !this.apps.isEmpty() || !this.appBlocks.isEmpty() || !this.charts.isEmpty() || !this.dataFilters.isEmpty() || !this.dataFiltersKPI.isEmpty() || !this.logExporters.isEmpty() || !this.additionalPlugins.isEmpty();
    }

    public boolean hasClass(String cls) {
        return this.allClass().stream().anyMatch(r -> r.getName().equals(cls)) || this.aliases.containsKey(cls.toLowerCase());
    }

    public Optional<Class> findClass(String cls) {
        return this.allClass().stream().filter(r -> r.getName().equals(cls)).findFirst().or(() -> Optional.ofNullable(this.aliases.get(cls.toLowerCase()).getValue()));
    }

    public Class baseClass(String cls) {
        if (this.getTasks().stream().anyMatch(r -> r.getName().equals(cls))) {
            return Task.class;
        }
        if (this.getTriggers().stream().anyMatch(r -> r.getName().equals(cls))) {
            return AbstractTrigger.class;
        }
        if (this.getConditions().stream().anyMatch(r -> r.getName().equals(cls))) {
            return Condition.class;
        }
        if (this.getStorages().stream().anyMatch(r -> r.getName().equals(cls))) {
            return StorageInterface.class;
        }
        if (this.getSecrets().stream().anyMatch(r -> r.getName().equals(cls))) {
            return SecretPluginInterface.class;
        }
        if (this.getTaskRunners().stream().anyMatch(r -> r.getName().equals(cls))) {
            return TaskRunner.class;
        }
        if (this.getCharts().stream().anyMatch(r -> r.getName().equals(cls))) {
            return Chart.class;
        }
        if (this.getDataFilters().stream().anyMatch(r -> r.getName().equals(cls))) {
            return DataFilter.class;
        }
        if (this.getDataFiltersKPI().stream().anyMatch(r -> r.getName().equals(cls))) {
            return DataFilterKPI.class;
        }
        if (this.getAppBlocks().stream().anyMatch(r -> r.getName().equals(cls))) {
            return AppBlockInterface.class;
        }
        if (this.getApps().stream().anyMatch(r -> r.getName().equals(cls))) {
            return AppPluginInterface.class;
        }
        if (this.getLogExporters().stream().anyMatch(r -> r.getName().equals(cls))) {
            return LogExporter.class;
        }
        if (this.getAdditionalPlugins().stream().anyMatch(r -> r.getName().equals(cls))) {
            return AdditionalPlugin.class;
        }
        if (this.getAliases().containsKey(cls.toLowerCase())) {
            return this.baseClass(this.getAliases().get(cls.toLowerCase()).getValue().getName());
        }
        throw new IllegalArgumentException("Unable to find base class from '" + cls + "'");
    }

    public List<Class> allClass() {
        return this.allClassGrouped().entrySet().stream().flatMap(map -> ((List)map.getValue()).stream()).toList();
    }

    public Map<String, List<Class>> allClassGrouped() {
        HashMap<String, List<Class>> result = new HashMap<String, List<Class>>();
        result.put(TASKS_GROUP_NAME, Arrays.asList((Class[])this.getTasks().toArray(Class[]::new)));
        result.put(TRIGGERS_GROUP_NAME, Arrays.asList((Class[])this.getTriggers().toArray(Class[]::new)));
        result.put(CONDITIONS_GROUP_NAME, Arrays.asList((Class[])this.getConditions().toArray(Class[]::new)));
        result.put(STORAGES_GROUP_NAME, Arrays.asList((Class[])this.getStorages().toArray(Class[]::new)));
        result.put(SECRETS_GROUP_NAME, Arrays.asList((Class[])this.getSecrets().toArray(Class[]::new)));
        result.put(TASK_RUNNERS_GROUP_NAME, Arrays.asList((Class[])this.getTaskRunners().toArray(Class[]::new)));
        result.put(APPS_GROUP_NAME, Arrays.asList((Class[])this.getApps().toArray(Class[]::new)));
        result.put(APP_BLOCKS_GROUP_NAME, Arrays.asList((Class[])this.getAppBlocks().toArray(Class[]::new)));
        result.put(CHARTS_GROUP_NAME, Arrays.asList((Class[])this.getCharts().toArray(Class[]::new)));
        result.put(DATA_FILTERS_GROUP_NAME, Arrays.asList((Class[])this.getDataFilters().toArray(Class[]::new)));
        result.put(DATA_FILTERS_KPI_GROUP_NAME, Arrays.asList((Class[])this.getDataFiltersKPI().toArray(Class[]::new)));
        result.put(LOG_EXPORTERS_GROUP_NAME, Arrays.asList((Class[])this.getLogExporters().toArray(Class[]::new)));
        result.put(ADDITIONAL_PLUGINS_GROUP_NAME, Arrays.asList((Class[])this.getAdditionalPlugins().toArray(Class[]::new)));
        return result;
    }

    public Set<String> subGroupNames() {
        return this.allClass().stream().map(clazz -> {
            PluginSubGroup pluginSubGroup = clazz.getPackage().getDeclaredAnnotation(PluginSubGroup.class);
            if (this.group() == null || clazz.getPackageName().length() == this.group().length()) {
                pluginSubGroup = null;
            }
            if (pluginSubGroup == null) {
                return null;
            }
            return clazz.getPackageName();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public String name() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getManifest() == null ? "core" : null, this.getManifest() != null ? this.getManifest().getMainAttributes().getValue("X-Kestra-Name") : null, "core"});
    }

    public String path() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getManifest() != null ? this.getManifest().getMainAttributes().getValue("X-Kestra-Name") : null, this.getExternalPlugin() != null ? FilenameUtils.getBaseName((String)this.getExternalPlugin().getLocation().getPath()) : null, "Core"});
    }

    public String title() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getManifest() != null ? this.getManifest().getMainAttributes().getValue("X-Kestra-Title") : null, this.getExternalPlugin() != null ? FilenameUtils.getBaseName((String)this.getExternalPlugin().getLocation().getPath()) : null, "Core"});
    }

    public String group() {
        return this.getManifest() == null ? null : this.getManifest().getMainAttributes().getValue("X-Kestra-Group");
    }

    public String description() {
        return this.getManifest() == null ? null : this.getManifest().getMainAttributes().getValue("X-Kestra-Description");
    }

    public String license() {
        return this.getManifest() == null ? null : this.getManifest().getMainAttributes().getValue("X-Kestra-License");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String longDescription() {
        try (InputStream is = this.getClassLoader().getResourceAsStream("doc/" + this.group() + ".md");){
            if (is == null) return null;
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Map<String, String> guides() throws IOException {
        return this.guides.stream().map(Rethrow.throwFunction(s -> new AbstractMap.SimpleEntry<String, String>((String)s, IOUtils.toString((InputStream)Objects.requireNonNull(this.getClassLoader().getResourceAsStream("doc/guides/" + s + ".md")), (Charset)StandardCharsets.UTF_8)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String version() {
        return this.getManifest() == null ? null : this.getManifest().getMainAttributes().getValue("X-Kestra-Version");
    }

    public String icon(Class<?> cls) {
        InputStream resourceAsStream = Stream.of(this.getClassLoader().getResourceAsStream("icons/" + cls.getName() + ".svg"), this.getClassLoader().getResourceAsStream("icons/" + cls.getPackageName() + ".svg")).filter(Objects::nonNull).findFirst().orElse(null);
        if (resourceAsStream != null) {
            return Base64.getEncoder().encodeToString(IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public String icon() {
        return this.icon("plugin-icon");
    }

    public String icon(String iconName) {
        InputStream resourceAsStream = this.getClassLoader().getResourceAsStream("icons/" + iconName + ".svg");
        if (resourceAsStream != null) {
            return Base64.getEncoder().encodeToString(IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public long crc32() {
        return Optional.ofNullable(this.externalPlugin).map(ExternalPlugin::getCrc32).orElse(-1L);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getExternalPlugin() != null) {
            b.append("Found plugin on path: ").append(this.getExternalPlugin().getLocation()).append(" ");
        } else {
            b.append("Core plugin: ");
        }
        if (!this.getTasks().isEmpty()) {
            b.append("[Tasks: ");
            b.append(this.getTasks().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getTriggers().isEmpty()) {
            b.append("[Triggers: ");
            b.append(this.getTriggers().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getConditions().isEmpty()) {
            b.append("[Conditions: ");
            b.append(this.getConditions().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getStorages().isEmpty()) {
            b.append("[Storages: ");
            b.append(this.getStorages().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getSecrets().isEmpty()) {
            b.append("[Secrets: ");
            b.append(this.getSecrets().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getTaskRunners().isEmpty()) {
            b.append("[Task Runners: ");
            b.append(this.getTaskRunners().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getApps().isEmpty()) {
            b.append("[Apps: ");
            b.append(this.getApps().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getAppBlocks().isEmpty()) {
            b.append("[AppBlocks: ");
            b.append(this.getAppBlocks().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getCharts().isEmpty()) {
            b.append("[Charts: ");
            b.append(this.getCharts().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getDataFilters().isEmpty()) {
            b.append("[DataFilters: ");
            b.append(this.getDataFilters().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getDataFiltersKPI().isEmpty()) {
            b.append("[DataFiltersKPI: ");
            b.append(this.getDataFiltersKPI().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getLogExporters().isEmpty()) {
            b.append("[Log Exporters: ");
            b.append(this.getLogExporters().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getAdditionalPlugins().isEmpty()) {
            b.append("[Additional Plugins: ");
            b.append(this.getAdditionalPlugins().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getAliases().isEmpty()) {
            b.append("[Aliases: ");
            b.append(this.getAliases().values().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            b.append("] ");
        }
        return b.toString();
    }

    @Generated
    public static RegisteredPluginBuilder builder() {
        return new RegisteredPluginBuilder();
    }

    @ConstructorProperties(value={"externalPlugin", "manifest", "classLoader", "tasks", "triggers", "conditions", "storages", "secrets", "taskRunners", "apps", "appBlocks", "charts", "dataFilters", "dataFiltersKPI", "logExporters", "additionalPlugins", "guides", "aliases"})
    @Generated
    public RegisteredPlugin(ExternalPlugin externalPlugin, Manifest manifest, ClassLoader classLoader, List<Class<? extends Task>> tasks, List<Class<? extends AbstractTrigger>> triggers, List<Class<? extends Condition>> conditions, List<Class<? extends StorageInterface>> storages, List<Class<? extends SecretPluginInterface>> secrets, List<Class<? extends TaskRunner<?>>> taskRunners, List<Class<? extends AppPluginInterface>> apps, List<Class<? extends AppBlockInterface>> appBlocks, List<Class<? extends Chart<?>>> charts, List<Class<? extends DataFilter<?, ?>>> dataFilters, List<Class<? extends DataFilterKPI<?, ?>>> dataFiltersKPI, List<Class<? extends LogExporter<?>>> logExporters, List<Class<? extends AdditionalPlugin>> additionalPlugins, List<String> guides, Map<String, Map.Entry<String, Class<?>>> aliases) {
        this.externalPlugin = externalPlugin;
        this.manifest = manifest;
        this.classLoader = classLoader;
        this.tasks = tasks;
        this.triggers = triggers;
        this.conditions = conditions;
        this.storages = storages;
        this.secrets = secrets;
        this.taskRunners = taskRunners;
        this.apps = apps;
        this.appBlocks = appBlocks;
        this.charts = charts;
        this.dataFilters = dataFilters;
        this.dataFiltersKPI = dataFiltersKPI;
        this.logExporters = logExporters;
        this.additionalPlugins = additionalPlugins;
        this.guides = guides;
        this.aliases = aliases;
    }

    @Generated
    public ExternalPlugin getExternalPlugin() {
        return this.externalPlugin;
    }

    @Generated
    public Manifest getManifest() {
        return this.manifest;
    }

    @Generated
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public List<Class<? extends Task>> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Class<? extends AbstractTrigger>> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<Class<? extends Condition>> getConditions() {
        return this.conditions;
    }

    @Generated
    public List<Class<? extends StorageInterface>> getStorages() {
        return this.storages;
    }

    @Generated
    public List<Class<? extends SecretPluginInterface>> getSecrets() {
        return this.secrets;
    }

    @Generated
    public List<Class<? extends TaskRunner<?>>> getTaskRunners() {
        return this.taskRunners;
    }

    @Generated
    public List<Class<? extends AppPluginInterface>> getApps() {
        return this.apps;
    }

    @Generated
    public List<Class<? extends AppBlockInterface>> getAppBlocks() {
        return this.appBlocks;
    }

    @Generated
    public List<Class<? extends Chart<?>>> getCharts() {
        return this.charts;
    }

    @Generated
    public List<Class<? extends DataFilter<?, ?>>> getDataFilters() {
        return this.dataFilters;
    }

    @Generated
    public List<Class<? extends DataFilterKPI<?, ?>>> getDataFiltersKPI() {
        return this.dataFiltersKPI;
    }

    @Generated
    public List<Class<? extends LogExporter<?>>> getLogExporters() {
        return this.logExporters;
    }

    @Generated
    public List<Class<? extends AdditionalPlugin>> getAdditionalPlugins() {
        return this.additionalPlugins;
    }

    @Generated
    public List<String> getGuides() {
        return this.guides;
    }

    @Generated
    public Map<String, Map.Entry<String, Class<?>>> getAliases() {
        return this.aliases;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredPlugin)) {
            return false;
        }
        RegisteredPlugin other = (RegisteredPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExternalPlugin this$externalPlugin = this.getExternalPlugin();
        ExternalPlugin other$externalPlugin = other.getExternalPlugin();
        if (this$externalPlugin == null ? other$externalPlugin != null : !((Object)this$externalPlugin).equals(other$externalPlugin)) {
            return false;
        }
        Manifest this$manifest = this.getManifest();
        Manifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        ClassLoader this$classLoader = this.getClassLoader();
        ClassLoader other$classLoader = other.getClassLoader();
        if (this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader)) {
            return false;
        }
        List<Class<? extends Task>> this$tasks = this.getTasks();
        List<Class<? extends Task>> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Class<? extends AbstractTrigger>> this$triggers = this.getTriggers();
        List<Class<? extends AbstractTrigger>> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<Class<? extends Condition>> this$conditions = this.getConditions();
        List<Class<? extends Condition>> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<Class<? extends StorageInterface>> this$storages = this.getStorages();
        List<Class<? extends StorageInterface>> other$storages = other.getStorages();
        if (this$storages == null ? other$storages != null : !((Object)this$storages).equals(other$storages)) {
            return false;
        }
        List<Class<? extends SecretPluginInterface>> this$secrets = this.getSecrets();
        List<Class<? extends SecretPluginInterface>> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        List<Class<TaskRunner<?>>> this$taskRunners = this.getTaskRunners();
        List<Class<? extends TaskRunner<?>>> other$taskRunners = other.getTaskRunners();
        if (this$taskRunners == null ? other$taskRunners != null : !((Object)this$taskRunners).equals(other$taskRunners)) {
            return false;
        }
        List<Class<? extends AppPluginInterface>> this$apps = this.getApps();
        List<Class<? extends AppPluginInterface>> other$apps = other.getApps();
        if (this$apps == null ? other$apps != null : !((Object)this$apps).equals(other$apps)) {
            return false;
        }
        List<Class<? extends AppBlockInterface>> this$appBlocks = this.getAppBlocks();
        List<Class<? extends AppBlockInterface>> other$appBlocks = other.getAppBlocks();
        if (this$appBlocks == null ? other$appBlocks != null : !((Object)this$appBlocks).equals(other$appBlocks)) {
            return false;
        }
        List<Class<Chart<?>>> this$charts = this.getCharts();
        List<Class<? extends Chart<?>>> other$charts = other.getCharts();
        if (this$charts == null ? other$charts != null : !((Object)this$charts).equals(other$charts)) {
            return false;
        }
        List<Class<DataFilter<?, ?>>> this$dataFilters = this.getDataFilters();
        List<Class<? extends DataFilter<?, ?>>> other$dataFilters = other.getDataFilters();
        if (this$dataFilters == null ? other$dataFilters != null : !((Object)this$dataFilters).equals(other$dataFilters)) {
            return false;
        }
        List<Class<DataFilterKPI<?, ?>>> this$dataFiltersKPI = this.getDataFiltersKPI();
        List<Class<? extends DataFilterKPI<?, ?>>> other$dataFiltersKPI = other.getDataFiltersKPI();
        if (this$dataFiltersKPI == null ? other$dataFiltersKPI != null : !((Object)this$dataFiltersKPI).equals(other$dataFiltersKPI)) {
            return false;
        }
        List<Class<LogExporter<?>>> this$logExporters = this.getLogExporters();
        List<Class<? extends LogExporter<?>>> other$logExporters = other.getLogExporters();
        if (this$logExporters == null ? other$logExporters != null : !((Object)this$logExporters).equals(other$logExporters)) {
            return false;
        }
        List<Class<? extends AdditionalPlugin>> this$additionalPlugins = this.getAdditionalPlugins();
        List<Class<? extends AdditionalPlugin>> other$additionalPlugins = other.getAdditionalPlugins();
        if (this$additionalPlugins == null ? other$additionalPlugins != null : !((Object)this$additionalPlugins).equals(other$additionalPlugins)) {
            return false;
        }
        List<String> this$guides = this.getGuides();
        List<String> other$guides = other.getGuides();
        if (this$guides == null ? other$guides != null : !((Object)this$guides).equals(other$guides)) {
            return false;
        }
        Map<String, Map.Entry<String, Class<?>>> this$aliases = this.getAliases();
        Map<String, Map.Entry<String, Class<?>>> other$aliases = other.getAliases();
        return !(this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisteredPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExternalPlugin $externalPlugin = this.getExternalPlugin();
        result = result * 59 + ($externalPlugin == null ? 43 : ((Object)$externalPlugin).hashCode());
        Manifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        ClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        List<Class<? extends Task>> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Class<? extends AbstractTrigger>> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<Class<? extends Condition>> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<Class<? extends StorageInterface>> $storages = this.getStorages();
        result = result * 59 + ($storages == null ? 43 : ((Object)$storages).hashCode());
        List<Class<? extends SecretPluginInterface>> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        List<Class<TaskRunner<?>>> $taskRunners = this.getTaskRunners();
        result = result * 59 + ($taskRunners == null ? 43 : ((Object)$taskRunners).hashCode());
        List<Class<? extends AppPluginInterface>> $apps = this.getApps();
        result = result * 59 + ($apps == null ? 43 : ((Object)$apps).hashCode());
        List<Class<? extends AppBlockInterface>> $appBlocks = this.getAppBlocks();
        result = result * 59 + ($appBlocks == null ? 43 : ((Object)$appBlocks).hashCode());
        List<Class<Chart<?>>> $charts = this.getCharts();
        result = result * 59 + ($charts == null ? 43 : ((Object)$charts).hashCode());
        List<Class<DataFilter<?, ?>>> $dataFilters = this.getDataFilters();
        result = result * 59 + ($dataFilters == null ? 43 : ((Object)$dataFilters).hashCode());
        List<Class<DataFilterKPI<?, ?>>> $dataFiltersKPI = this.getDataFiltersKPI();
        result = result * 59 + ($dataFiltersKPI == null ? 43 : ((Object)$dataFiltersKPI).hashCode());
        List<Class<LogExporter<?>>> $logExporters = this.getLogExporters();
        result = result * 59 + ($logExporters == null ? 43 : ((Object)$logExporters).hashCode());
        List<Class<? extends AdditionalPlugin>> $additionalPlugins = this.getAdditionalPlugins();
        result = result * 59 + ($additionalPlugins == null ? 43 : ((Object)$additionalPlugins).hashCode());
        List<String> $guides = this.getGuides();
        result = result * 59 + ($guides == null ? 43 : ((Object)$guides).hashCode());
        Map<String, Map.Entry<String, Class<?>>> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        return result;
    }

    @Generated
    public static class RegisteredPluginBuilder {
        @Generated
        private ExternalPlugin externalPlugin;
        @Generated
        private Manifest manifest;
        @Generated
        private ClassLoader classLoader;
        @Generated
        private List<Class<? extends Task>> tasks;
        @Generated
        private List<Class<? extends AbstractTrigger>> triggers;
        @Generated
        private List<Class<? extends Condition>> conditions;
        @Generated
        private List<Class<? extends StorageInterface>> storages;
        @Generated
        private List<Class<? extends SecretPluginInterface>> secrets;
        @Generated
        private List<Class<? extends TaskRunner<?>>> taskRunners;
        @Generated
        private List<Class<? extends AppPluginInterface>> apps;
        @Generated
        private List<Class<? extends AppBlockInterface>> appBlocks;
        @Generated
        private List<Class<? extends Chart<?>>> charts;
        @Generated
        private List<Class<? extends DataFilter<?, ?>>> dataFilters;
        @Generated
        private List<Class<? extends DataFilterKPI<?, ?>>> dataFiltersKPI;
        @Generated
        private List<Class<? extends LogExporter<?>>> logExporters;
        @Generated
        private List<Class<? extends AdditionalPlugin>> additionalPlugins;
        @Generated
        private List<String> guides;
        @Generated
        private Map<String, Map.Entry<String, Class<?>>> aliases;

        @Generated
        RegisteredPluginBuilder() {
        }

        @Generated
        public RegisteredPluginBuilder externalPlugin(ExternalPlugin externalPlugin) {
            this.externalPlugin = externalPlugin;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder manifest(Manifest manifest) {
            this.manifest = manifest;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder tasks(List<Class<? extends Task>> tasks) {
            this.tasks = tasks;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder triggers(List<Class<? extends AbstractTrigger>> triggers) {
            this.triggers = triggers;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder conditions(List<Class<? extends Condition>> conditions) {
            this.conditions = conditions;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder storages(List<Class<? extends StorageInterface>> storages) {
            this.storages = storages;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder secrets(List<Class<? extends SecretPluginInterface>> secrets) {
            this.secrets = secrets;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder taskRunners(List<Class<? extends TaskRunner<?>>> taskRunners) {
            this.taskRunners = taskRunners;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder apps(List<Class<? extends AppPluginInterface>> apps) {
            this.apps = apps;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder appBlocks(List<Class<? extends AppBlockInterface>> appBlocks) {
            this.appBlocks = appBlocks;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder charts(List<Class<? extends Chart<?>>> charts) {
            this.charts = charts;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder dataFilters(List<Class<? extends DataFilter<?, ?>>> dataFilters) {
            this.dataFilters = dataFilters;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder dataFiltersKPI(List<Class<? extends DataFilterKPI<?, ?>>> dataFiltersKPI) {
            this.dataFiltersKPI = dataFiltersKPI;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder logExporters(List<Class<? extends LogExporter<?>>> logExporters) {
            this.logExporters = logExporters;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder additionalPlugins(List<Class<? extends AdditionalPlugin>> additionalPlugins) {
            this.additionalPlugins = additionalPlugins;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder guides(List<String> guides) {
            this.guides = guides;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder aliases(Map<String, Map.Entry<String, Class<?>>> aliases) {
            this.aliases = aliases;
            return this;
        }

        @Generated
        public RegisteredPlugin build() {
            return new RegisteredPlugin(this.externalPlugin, this.manifest, this.classLoader, this.tasks, this.triggers, this.conditions, this.storages, this.secrets, this.taskRunners, this.apps, this.appBlocks, this.charts, this.dataFilters, this.dataFiltersKPI, this.logExporters, this.additionalPlugins, this.guides, this.aliases);
        }

        @Generated
        public String toString() {
            return "RegisteredPlugin.RegisteredPluginBuilder(externalPlugin=" + String.valueOf(this.externalPlugin) + ", manifest=" + String.valueOf(this.manifest) + ", classLoader=" + String.valueOf(this.classLoader) + ", tasks=" + String.valueOf(this.tasks) + ", triggers=" + String.valueOf(this.triggers) + ", conditions=" + String.valueOf(this.conditions) + ", storages=" + String.valueOf(this.storages) + ", secrets=" + String.valueOf(this.secrets) + ", taskRunners=" + String.valueOf(this.taskRunners) + ", apps=" + String.valueOf(this.apps) + ", appBlocks=" + String.valueOf(this.appBlocks) + ", charts=" + String.valueOf(this.charts) + ", dataFilters=" + String.valueOf(this.dataFilters) + ", dataFiltersKPI=" + String.valueOf(this.dataFiltersKPI) + ", logExporters=" + String.valueOf(this.logExporters) + ", additionalPlugins=" + String.valueOf(this.additionalPlugins) + ", guides=" + String.valueOf(this.guides) + ", aliases=" + String.valueOf(this.aliases) + ")";
        }
    }
}

