/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.services.FlowListenersInterface;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

@Singleton
public class DefaultFlowMetaStore
implements FlowMetaStoreInterface {
    private final FlowRepositoryInterface flowRepository;
    private List<FlowWithSource> allFlows;

    public DefaultFlowMetaStore(FlowListenersInterface flowListeners, FlowRepositoryInterface flowRepository) {
        this.flowRepository = flowRepository;
        flowListeners.listen(flows -> {
            this.allFlows = flows;
        });
    }

    @Override
    public Collection<FlowWithSource> allLastVersion() {
        return this.allFlows;
    }

    @Override
    public Optional<FlowInterface> findById(String tenantId, String namespace, String id, Optional<Integer> revision) {
        Optional<FlowInterface> find = this.allFlows.stream().filter(flow -> (flow.getTenantId() == null && tenantId == null || Objects.equals(flow.getTenantId(), tenantId)) && flow.getNamespace().equals(namespace) && flow.getId().equals(id) && (revision.isEmpty() || ((Integer)revision.get()).equals(flow.getRevision()))).map(it -> it).findFirst();
        if (find.isPresent()) {
            return find;
        }
        return this.flowRepository.findByIdWithSource(tenantId, namespace, id, revision);
    }

    @Override
    public Boolean isReady() {
        return true;
    }

    @Generated
    public void setAllFlows(List<FlowWithSource> allFlows) {
        this.allFlows = allFlows;
    }
}

