/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.HasUID;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.utils.IdUtils;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;

public final class ExecutionRunning
implements HasUID {
    private final String tenantId;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    private final Execution execution;
    private final ConcurrencyState concurrencyState;

    @Override
    public String uid() {
        return IdUtils.fromPartsAndSeparator('|', this.tenantId, this.namespace, this.flowId, this.execution.getId());
    }

    @Generated
    public static ExecutionRunningBuilder builder() {
        return new ExecutionRunningBuilder();
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Execution getExecution() {
        return this.execution;
    }

    @Generated
    public ConcurrencyState getConcurrencyState() {
        return this.concurrencyState;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionRunning)) {
            return false;
        }
        ExecutionRunning other = (ExecutionRunning)o;
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        Execution this$execution = this.getExecution();
        Execution other$execution = other.getExecution();
        if (this$execution == null ? other$execution != null : !((Object)this$execution).equals(other$execution)) {
            return false;
        }
        ConcurrencyState this$concurrencyState = this.getConcurrencyState();
        ConcurrencyState other$concurrencyState = other.getConcurrencyState();
        return !(this$concurrencyState == null ? other$concurrencyState != null : !((Object)((Object)this$concurrencyState)).equals((Object)other$concurrencyState));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        Execution $execution = this.getExecution();
        result = result * 59 + ($execution == null ? 43 : ((Object)$execution).hashCode());
        ConcurrencyState $concurrencyState = this.getConcurrencyState();
        result = result * 59 + ($concurrencyState == null ? 43 : ((Object)((Object)$concurrencyState)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExecutionRunning(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", execution=" + String.valueOf(this.getExecution()) + ", concurrencyState=" + String.valueOf((Object)this.getConcurrencyState()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "namespace", "flowId", "execution", "concurrencyState"})
    @Generated
    public ExecutionRunning(String tenantId, String namespace, String flowId, Execution execution, ConcurrencyState concurrencyState) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.execution = execution;
        this.concurrencyState = concurrencyState;
    }

    @Generated
    public ExecutionRunning withExecution(Execution execution) {
        return this.execution == execution ? this : new ExecutionRunning(this.tenantId, this.namespace, this.flowId, execution, this.concurrencyState);
    }

    @Generated
    public ExecutionRunning withConcurrencyState(ConcurrencyState concurrencyState) {
        return this.concurrencyState == concurrencyState ? this : new ExecutionRunning(this.tenantId, this.namespace, this.flowId, this.execution, concurrencyState);
    }

    @Generated
    public static class ExecutionRunningBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Execution execution;
        @Generated
        private ConcurrencyState concurrencyState;

        @Generated
        ExecutionRunningBuilder() {
        }

        @Generated
        public ExecutionRunningBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public ExecutionRunningBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public ExecutionRunningBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public ExecutionRunningBuilder execution(Execution execution) {
            this.execution = execution;
            return this;
        }

        @Generated
        public ExecutionRunningBuilder concurrencyState(ConcurrencyState concurrencyState) {
            this.concurrencyState = concurrencyState;
            return this;
        }

        @Generated
        public ExecutionRunning build() {
            return new ExecutionRunning(this.tenantId, this.namespace, this.flowId, this.execution, this.concurrencyState);
        }

        @Generated
        public String toString() {
            return "ExecutionRunning.ExecutionRunningBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", execution=" + String.valueOf(this.execution) + ", concurrencyState=" + String.valueOf((Object)this.concurrencyState) + ")";
        }
    }

    public static enum ConcurrencyState {
        CREATED,
        RUNNING,
        QUEUED,
        CANCELLED,
        FAILED,
        KILLED;

    }
}

