/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.plugin.core.flow.Dag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlowableUtils {
    private static final TypeReference<List<Object>> TYPE_REFERENCE = new TypeReference<List<Object>>(){};
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks);
        return FlowableUtils.innerResolveSequentialNexts(execution, currentTasks, null);
    }

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally) {
        return FlowableUtils.resolveSequentialNexts(execution, tasks, errors, _finally, null);
    }

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, _finally, parentTaskRun);
        return FlowableUtils.innerResolveSequentialNexts(execution, currentTasks, parentTaskRun);
    }

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, State.Type terminalState) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, _finally, parentTaskRun, terminalState);
        return FlowableUtils.innerResolveSequentialNexts(execution, currentTasks, parentTaskRun);
    }

    private static List<NextTaskRun> innerResolveSequentialNexts(Execution execution, List<ResolvedTask> currentTasks, TaskRun parentTaskRun) {
        if (currentTasks == null || currentTasks.isEmpty() || execution.getState().getCurrent() == State.Type.KILLING) {
            return Collections.emptyList();
        }
        List<TaskRun> taskRuns = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
        if (taskRuns.isEmpty()) {
            return Collections.singletonList(currentTasks.getFirst().toNextTaskRun(execution));
        }
        Optional<TaskRun> lastCreated = execution.findLastCreated(taskRuns);
        if (lastCreated.isPresent()) {
            return Collections.emptyList();
        }
        Optional<TaskRun> lastSubmitted = execution.findLastSubmitted(taskRuns);
        if (lastSubmitted.isPresent()) {
            return Collections.emptyList();
        }
        Optional<TaskRun> lastRunning = execution.findLastRunning(taskRuns);
        if (lastRunning.isPresent()) {
            return Collections.emptyList();
        }
        Optional<TaskRun> lastTerminated = execution.findLastTerminated(taskRuns);
        if (lastTerminated.isPresent()) {
            int lastIndex = taskRuns.indexOf(lastTerminated.get());
            if (currentTasks.size() > lastIndex + 1) {
                return Collections.singletonList(currentTasks.get(lastIndex + 1).toNextTaskRun(execution));
            }
        }
        return Collections.emptyList();
    }

    public static List<NextTaskRun> resolveWaitForNext(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, _finally, parentTaskRun);
        if (currentTasks == null || currentTasks.isEmpty() || execution.getState().getCurrent() == State.Type.KILLING) {
            return Collections.emptyList();
        }
        List<TaskRun> taskRuns = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
        if (taskRuns.isEmpty()) {
            return Collections.singletonList(currentTasks.getFirst().toNextTaskRunIncrementIteration(execution, parentTaskRun.getIteration()));
        }
        Optional<TaskRun> lastCreated = execution.findLastCreated(taskRuns);
        if (lastCreated.isPresent()) {
            return Collections.emptyList();
        }
        Optional<TaskRun> lastRunning = execution.findLastRunning(taskRuns);
        if (lastRunning.isPresent()) {
            return Collections.emptyList();
        }
        Optional<TaskRun> lastTerminated = execution.findLastTerminated(taskRuns);
        if (lastTerminated.isPresent()) {
            int lastIndex = taskRuns.indexOf(lastTerminated.get());
            if (currentTasks.size() > lastIndex + 1) {
                return Collections.singletonList(currentTasks.get(lastIndex + 1).toNextTaskRunIncrementIteration(execution, parentTaskRun.getIteration()));
            }
            return Collections.singletonList(currentTasks.getFirst().toNextTaskRunIncrementIteration(execution, parentTaskRun.getIteration()));
        }
        return Collections.emptyList();
    }

    public static Optional<State.Type> resolveState(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, RunContext runContext, boolean allowFailure, boolean allowWarning) {
        return FlowableUtils.resolveState(execution, tasks, errors, _finally, parentTaskRun, runContext, allowFailure, allowWarning, State.Type.SUCCESS);
    }

    public static Optional<State.Type> resolveState(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, RunContext runContext, boolean allowFailure, boolean allowWarning, State.Type terminalState) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, _finally, parentTaskRun, terminalState);
        if (currentTasks == null) {
            runContext.logger().warn("No task found on flow '{}', task '{}', execution '{}'", new Object[]{execution.getNamespace() + "." + execution.getFlowId(), parentTaskRun.getTaskId(), execution.getId()});
            return Optional.of(allowFailure ? (allowWarning ? State.Type.SUCCESS : State.Type.WARNING) : State.Type.FAILED);
        }
        if (currentTasks.stream().allMatch(t -> t.getTask().getDisabled()) && !currentTasks.isEmpty()) {
            return Optional.of(terminalState);
        }
        if (!currentTasks.isEmpty() ? execution.isTerminated(currentTasks, parentTaskRun) : execution.hasFailed(tasks, parentTaskRun) || terminalState == State.Type.FAILED) {
            return Optional.of(execution.guessFinalState(tasks, parentTaskRun, allowFailure, allowWarning, terminalState));
        }
        return Optional.empty();
    }

    public static List<ResolvedTask> resolveTasks(List<Task> tasks, TaskRun parentTaskRun) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(task -> ResolvedTask.builder().task((Task)task).parentId(parentTaskRun.getId()).build()).toList();
    }

    public static List<NextTaskRun> resolveParallelNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, Integer concurrency) {
        return FlowableUtils.resolveParallelNexts(execution, tasks, errors, _finally, parentTaskRun, concurrency, (nextTaskRunStream, taskRuns) -> nextTaskRunStream);
    }

    public static List<NextTaskRun> resolveConcurrentNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, Integer concurrency) {
        long resolvedConcurrency;
        if (execution.getState().getCurrent() == State.Type.KILLING) {
            return Collections.emptyList();
        }
        List<ResolvedTask> allTasks = execution.findTaskDependingFlowState(tasks, errors, _finally, parentTaskRun);
        boolean isTasks = tasks.equals(allTasks);
        if (!isTasks) {
            return FlowableUtils.resolveSequentialNexts(execution, tasks, errors, _finally, parentTaskRun);
        }
        List<TaskRun> taskRuns = execution.findTaskRunByTasks(allTasks, parentTaskRun);
        long nonTerminatedCount = taskRuns.stream().filter(taskRun -> !taskRun.getState().isTerminated()).count();
        if (concurrency > 0 && nonTerminatedCount >= (long)concurrency.intValue()) {
            return Collections.emptyList();
        }
        Map collect = allTasks.stream().collect(Collectors.groupingBy(ResolvedTask::getValue, LinkedHashMap::new, Collectors.toList()));
        long l = resolvedConcurrency = concurrency == 0 ? Integer.MAX_VALUE : (long)concurrency.intValue();
        if (resolvedConcurrency > (long)collect.size()) {
            resolvedConcurrency = collect.size();
        }
        long concurrencySlots = resolvedConcurrency - nonTerminatedCount;
        if (taskRuns.isEmpty()) {
            return collect.values().stream().limit(concurrencySlots).map(resolvedTasks -> ((ResolvedTask)resolvedTasks.getFirst()).toNextTaskRun(execution)).toList();
        }
        return collect.values().stream().map(resolvedTasks -> FlowableUtils.resolveSequentialNexts(execution, resolvedTasks, null, null, parentTaskRun)).filter(resolvedTasks -> !resolvedTasks.isEmpty()).limit(concurrencySlots).map(resolvedTasks -> (NextTaskRun)resolvedTasks.getFirst()).toList();
    }

    public static List<NextTaskRun> resolveDagNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, Integer concurrency, List<Dag.DagTask> taskDependencies) {
        return FlowableUtils.resolveParallelNexts(execution, tasks, errors, _finally, parentTaskRun, concurrency, (nextTaskRunStream, taskRuns) -> nextTaskRunStream.filter(nextTaskRun -> {
            Task task = nextTaskRun.getTask();
            List taskDependIds = taskDependencies.stream().filter(taskDepend -> taskDepend.getTask().getId().equals(task.getId())).findFirst().map(Dag.DagTask::getDependsOn).orElse(null);
            return taskDependIds == null || new HashSet<String>(taskRuns.stream().filter(taskRun -> taskRun.getState().isTerminated()).map(TaskRun::getTaskId).toList()).containsAll(taskDependIds);
        }));
    }

    public static List<NextTaskRun> resolveParallelNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, List<ResolvedTask> _finally, TaskRun parentTaskRun, Integer concurrency, BiFunction<Stream<NextTaskRun>, List<TaskRun>, Stream<NextTaskRun>> nextTaskRunFunction) {
        if (execution.getState().getCurrent() == State.Type.KILLING) {
            return Collections.emptyList();
        }
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, _finally, parentTaskRun);
        boolean isTasks = tasks.equals(currentTasks);
        if (!isTasks) {
            return FlowableUtils.resolveSequentialNexts(execution, tasks, errors, _finally, parentTaskRun);
        }
        List<TaskRun> taskRuns = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
        long runningCount = taskRuns.stream().filter(taskRun -> taskRun.getState().isRunning()).count();
        if (concurrency > 0 && runningCount > (long)concurrency.intValue()) {
            return Collections.emptyList();
        }
        List<ResolvedTask> notFinds = currentTasks.stream().filter(resolvedTask -> taskRuns.stream().noneMatch(taskRun -> FlowableUtils.isTaskRunFor(resolvedTask, taskRun, parentTaskRun))).toList();
        Optional<TaskRun> lastCreated = execution.findLastCreated(taskRuns);
        if (!notFinds.isEmpty() && lastCreated.isEmpty()) {
            Stream<NextTaskRun> nextTaskRunStream = notFinds.stream().map(resolvedTask -> resolvedTask.toNextTaskRun(execution));
            nextTaskRunStream = nextTaskRunFunction.apply(nextTaskRunStream, taskRuns);
            if (concurrency > 0) {
                nextTaskRunStream = nextTaskRunStream.limit((long)concurrency.intValue() - runningCount);
            }
            return nextTaskRunStream.toList();
        }
        return Collections.emptyList();
    }

    public static List<ResolvedTask> resolveEachTasks(RunContext runContext, TaskRun parentTaskRun, List<Task> tasks, Object value) throws IllegalVariableEvaluationException {
        List<String> values;
        if (value instanceof String) {
            String stringValue = (String)value;
            String renderValue = runContext.render(stringValue);
            try {
                values = (List)MAPPER.readValue(renderValue, TYPE_REFERENCE);
            }
            catch (JsonProcessingException e) {
                throw new IllegalVariableEvaluationException(e);
            }
        } else if (value instanceof List) {
            List listValue = (List)value;
            values = new ArrayList(listValue.size());
            for (Object obj : (List)value) {
                if (obj instanceof String) {
                    String stringObj = (String)obj;
                    values.add(runContext.render(stringObj));
                    continue;
                }
                if (obj instanceof Integer) {
                    values.add(runContext.render(obj.toString()));
                    continue;
                }
                if (obj instanceof Map) {
                    Map mapObj = (Map)obj;
                    values.add((String)((Object)runContext.render(mapObj)));
                    continue;
                }
                throw new IllegalVariableEvaluationException("Unknown value element type: " + String.valueOf(obj.getClass()));
            }
        } else {
            throw new IllegalVariableEvaluationException("Unknown value type: " + String.valueOf(value.getClass()));
        }
        List distinctValue = values.stream().distinct().toList();
        long nullCount = distinctValue.stream().filter(Objects::isNull).count();
        if (nullCount > 0L) {
            throw new IllegalVariableEvaluationException("Found '" + nullCount + "' null values on Each, with values=" + Arrays.toString(values.toArray()));
        }
        ArrayList<ResolvedTask> result = new ArrayList<ResolvedTask>();
        int iteration = 0;
        for (Object current : distinctValue) {
            try {
                String stringValue;
                String resolvedValue = current instanceof String ? (stringValue = (String)current) : MAPPER.writeValueAsString(current);
                for (Task task : tasks) {
                    result.add(ResolvedTask.builder().task(task).value(resolvedValue).iteration(iteration).parentId(parentTaskRun.getId()).build());
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalVariableEvaluationException(e);
            }
            ++iteration;
        }
        return result;
    }

    public static boolean isTaskRunFor(ResolvedTask resolvedTask, TaskRun taskRun, TaskRun parentTaskRun) {
        return !(!resolvedTask.getTask().getId().equals(taskRun.getTaskId()) || parentTaskRun != null && !parentTaskRun.getId().equals(taskRun.getParentTaskRunId()) || resolvedTask.getValue() != null && !resolvedTask.getValue().equals(taskRun.getValue()));
    }
}

