/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.property.PropertyContext;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.PluginConfigurations;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextCache;
import io.kestra.core.runners.RunContextInitializer;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.RunContextLoggerFactory;
import io.kestra.core.runners.RunVariables;
import io.kestra.core.runners.SecureVariableRendererFactory;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.WorkingDirFactory;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.storages.InternalStorage;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@Singleton
public class RunContextFactory {
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    protected PluginConfigurations pluginConfigurations;
    @Inject
    protected VariableRenderer variableRenderer;
    @Inject
    protected SecureVariableRendererFactory secureVariableRendererFactory;
    @Inject
    protected StorageInterface storageInterface;
    @Inject
    protected FlowService flowService;
    @Inject
    protected MetricRegistry metricRegistry;
    @Inject
    protected RunContextCache runContextCache;
    @Inject
    protected WorkingDirFactory workingDirFactory;
    @Value(value="${kestra.encryption.secret-key}")
    protected Optional<String> secretKey;
    @Value(value="${kestra.environment.name}")
    @Nullable
    protected String kestraEnvironment;
    @Value(value="${kestra.url}")
    @Nullable
    protected String kestraUrl;
    @Inject
    private RunContextLoggerFactory runContextLoggerFactory;
    @Inject
    private KVStoreService kvStoreService;

    public RunContextInitializer initializer() {
        return (RunContextInitializer)this.applicationContext.getBean(RunContextInitializer.class);
    }

    public RunContext of(FlowInterface flow, Execution execution) {
        return this.of(flow, execution, Function.identity());
    }

    public RunContext of(FlowInterface flow, Execution execution, boolean decryptVariable) {
        return this.of(flow, execution, Function.identity(), decryptVariable);
    }

    public RunContext of(FlowInterface flow, Execution execution, Function<RunVariables.Builder, RunVariables.Builder> runVariableModifier) {
        return this.of(flow, execution, runVariableModifier, true);
    }

    public RunContext of(FlowInterface flow, Execution execution, Function<RunVariables.Builder, RunVariables.Builder> runVariableModifier, boolean decryptVariables) {
        RunContextLogger runContextLogger = this.runContextLoggerFactory.create(execution);
        VariableRenderer variableRenderer = decryptVariables ? this.variableRenderer : this.secureVariableRendererFactory.createOrGet();
        return this.newBuilder().withLogger(runContextLogger).withPluginConfiguration(Map.of()).withStorage(new InternalStorage(runContextLogger.logger(), StorageContext.forExecution(execution), this.storageInterface, this.flowService)).withVariableRenderer(variableRenderer).withVariables(runVariableModifier.apply(this.newRunVariablesBuilder().withFlow(flow).withExecution(execution).withDecryptVariables(decryptVariables).withSecretInputs(this.secretInputsFromFlow(flow))).build(runContextLogger, PropertyContext.create(variableRenderer))).withSecretInputs(this.secretInputsFromFlow(flow)).build();
    }

    public RunContext of(FlowInterface flow, Task task, Execution execution, TaskRun taskRun) {
        return this.of(flow, task, execution, taskRun, true);
    }

    public RunContext of(FlowInterface flow, Task task, Execution execution, TaskRun taskRun, boolean decryptVariables) {
        return this.of(flow, task, execution, taskRun, decryptVariables, this.variableRenderer);
    }

    public RunContext of(FlowInterface flow, Task task, Execution execution, TaskRun taskRun, boolean decryptVariables, VariableRenderer variableRenderer) {
        RunContextLogger runContextLogger = this.runContextLoggerFactory.create(taskRun, task, execution.getKind());
        return this.newBuilder().withLogger(runContextLogger).withPluginConfiguration(this.pluginConfigurations.getConfigurationByPluginTypeOrAliases(task.getType(), task.getClass())).withStorage(new InternalStorage(runContextLogger.logger(), StorageContext.forTask(taskRun), this.storageInterface, this.flowService)).withVariables(this.newRunVariablesBuilder().withFlow(flow).withTask(task).withExecution(execution).withTaskRun(taskRun).withDecryptVariables(decryptVariables).withSecretInputs(this.secretInputsFromFlow(flow)).build(runContextLogger, PropertyContext.create(variableRenderer))).withKvStoreService(this.kvStoreService).withSecretInputs(this.secretInputsFromFlow(flow)).withTask(task).withVariableRenderer(variableRenderer).build();
    }

    public RunContext of(Flow flow, AbstractTrigger trigger) {
        RunContextLogger runContextLogger = this.runContextLoggerFactory.create(flow, trigger, null);
        return this.newBuilder().withLogger(runContextLogger).withPluginConfiguration(this.pluginConfigurations.getConfigurationByPluginTypeOrAliases(trigger.getType(), trigger.getClass())).withVariables(this.newRunVariablesBuilder().withFlow(flow).withTrigger(trigger).withSecretInputs(this.secretInputsFromFlow(flow)).build(runContextLogger, PropertyContext.create(this.variableRenderer))).withSecretInputs(this.secretInputsFromFlow(flow)).withTrigger(trigger).build();
    }

    @VisibleForTesting
    public RunContext of(Flow flow, Map<String, Object> variables) {
        RunContextLogger runContextLogger = new RunContextLogger();
        return this.newBuilder().withLogger(runContextLogger).withStorage(new InternalStorage(runContextLogger.logger(), StorageContext.forFlow(flow), this.storageInterface, this.flowService)).withVariables(variables).withSecretInputs(this.secretInputsFromFlow(flow)).build();
    }

    @VisibleForTesting
    public RunContext of(Map<String, Object> variables) {
        return this.of((Task)null, variables);
    }

    @VisibleForTesting
    public RunContext of(Task task, final Map<String, Object> variables) {
        RunContextLogger runContextLogger = new RunContextLogger();
        return this.newBuilder().withLogger(runContextLogger).withStorage(new InternalStorage(runContextLogger.logger(), new StorageContext(this){

            @Override
            public URI getContextStorageURI() {
                return URI.create("");
            }

            @Override
            public String getTenantId() {
                Object tenantId = variables.getOrDefault("flow", Map.of()).get("tenantId");
                return Optional.ofNullable(tenantId).map(Object::toString).orElse("main");
            }

            @Override
            public String getNamespace() {
                Object namespace = variables.getOrDefault("flow", Map.of()).get("namespace");
                return Optional.ofNullable(namespace).map(Object::toString).orElse(null);
            }
        }, this.storageInterface, this.flowService)).withVariables(variables).withTask(task).build();
    }

    @VisibleForTesting
    public RunContext of() {
        return this.of(Map.of());
    }

    private List<String> secretInputsFromFlow(FlowInterface flow) {
        if (flow == null || flow.getInputs() == null) {
            return Collections.emptyList();
        }
        return flow.getInputs().stream().filter(input -> input.getType() == Type.SECRET).map(input -> input.getId()).toList();
    }

    private DefaultRunContext.Builder newBuilder() {
        return new DefaultRunContext.Builder().withApplicationContext(this.applicationContext).withMeterRegistry(this.metricRegistry).withVariableRenderer(this.variableRenderer).withStorageInterface(this.storageInterface).withSecretKey(this.secretKey).withWorkingDir(this.workingDirFactory.createWorkingDirectory()).withKvStoreService(this.kvStoreService);
    }

    protected RunVariables.Builder newRunVariablesBuilder() {
        return ((RunVariables.DefaultBuilder)((RunVariables.DefaultBuilder)new RunVariables.DefaultBuilder(this.secretKey).withEnvs((Map)this.runContextCache.getEnvVars())).withGlobals((Map)this.runContextCache.getGlobalVars())).withKestraConfiguration(new RunVariables.KestraConfiguration(this.kestraEnvironment, this.kestraUrl));
    }
}

