/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import com.cronutils.utils.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import jakarta.annotation.Nullable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.KeyValuePair;
import org.slf4j.spi.MDCAdapter;

public class RunContextLogger
implements Supplier<Logger> {
    private static final int MAX_MESSAGE_LENGTH = 15360;
    public static final String ORIGINAL_TIMESTAMP_KEY = "originalTimestamp";
    private final String loggerName;
    private volatile ch.qos.logback.classic.Logger logger;
    private QueueInterface<LogEntry> logQueue;
    private LogEntry logEntry;
    private Level loglevel;
    private final List<String> useSecrets = new ArrayList<String>();
    private final boolean logToFile;
    private File logFile;
    private OutputStream logFileOS;

    @VisibleForTesting
    public RunContextLogger() {
        this.loggerName = "unit-test";
        this.logToFile = false;
    }

    public RunContextLogger(QueueInterface<LogEntry> logQueue, LogEntry logEntry, org.slf4j.event.Level loglevel, boolean logToFile) {
        this.loggerName = logEntry.getTaskId() != null ? "flow." + logEntry.getFlowId() + "." + logEntry.getTaskId() : (logEntry.getTriggerId() != null ? "flow." + logEntry.getFlowId() + "." + logEntry.getTriggerId() : "flow." + logEntry.getFlowId());
        this.logQueue = logQueue;
        this.logEntry = logEntry;
        this.loglevel = loglevel == null ? Level.TRACE : Level.toLevel((String)loglevel.toString());
        this.logToFile = logToFile;
    }

    private static List<LogEntry> logEntry(ILoggingEvent event, String message, org.slf4j.event.Level level, LogEntry logEntry) {
        if (message == null) {
            return new ArrayList<LogEntry>();
        }
        Iterable<String> split = message.length() > 15360 ? Splitter.fixedLength((int)15360).split((CharSequence)message) : Collections.singletonList(message);
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (String s : split) {
            result.add(LogEntry.builder().namespace(logEntry.getNamespace()).tenantId(logEntry.getTenantId()).flowId(logEntry.getFlowId()).taskId(logEntry.getTaskId()).executionId(logEntry.getExecutionId()).executionKind(logEntry.getExecutionKind()).taskRunId(logEntry.getTaskRunId()).attemptNumber(logEntry.getAttemptNumber()).triggerId(logEntry.getTriggerId()).level(level != null ? level : org.slf4j.event.Level.valueOf((String)event.getLevel().toString())).message(s).timestamp(event.getInstant()).thread(event.getThreadName()).build());
        }
        return result;
    }

    public static List<LogEntry> logEntries(ILoggingEvent event, LogEntry logEntry) {
        Throwable throwable = RunContextLogger.throwable(event);
        if (throwable == null) {
            return RunContextLogger.logEntry(event, event.getFormattedMessage(), null, logEntry);
        }
        ArrayList<LogEntry> result = new ArrayList<LogEntry>(RunContextLogger.logEntry(event, event.getFormattedMessage(), null, logEntry));
        if (Throwables.getCausalChain((Throwable)throwable).size() > 1 && !(throwable instanceof IllegalVariableEvaluationException)) {
            result.addAll(RunContextLogger.logEntry(event, Throwables.getCausalChain((Throwable)throwable).stream().skip(1L).map(Throwable::getMessage).collect(Collectors.joining("\n")), null, logEntry));
        }
        result.addAll(RunContextLogger.logEntry(event, Throwables.getStackTraceAsString((Throwable)throwable), org.slf4j.event.Level.TRACE, logEntry));
        return result;
    }

    private static Throwable throwable(ILoggingEvent event) {
        Throwable result = null;
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (null != throwableProxy && throwableProxy instanceof ThrowableProxy) {
            ThrowableProxy proxyThrowable = (ThrowableProxy)throwableProxy;
            result = proxyThrowable.getThrowable();
        }
        return result;
    }

    public void usedSecret(String secret) {
        if (secret != null && !secret.isEmpty()) {
            this.useSecrets.add(secret);
            this.useSecrets.add(Base64.getEncoder().encodeToString(secret.getBytes(StandardCharsets.UTF_8)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger logger() {
        if (this.logger == null) {
            RunContextLogger runContextLogger = this;
            synchronized (runContextLogger) {
                if (this.logger == null) {
                    this.logger = this.initializeLogger();
                }
            }
        }
        return this.logger;
    }

    private ch.qos.logback.classic.Logger initializeLogger() {
        LoggerContext loggerContext = new LoggerContext();
        LogbackMDCAdapter mdcAdapter = new LogbackMDCAdapter();
        loggerContext.setMDCAdapter((MDCAdapter)mdcAdapter);
        loggerContext.start();
        ch.qos.logback.classic.Logger newLogger = loggerContext.getLogger(this.loggerName);
        if (this.logEntry != null) {
            loggerContext.getMDCAdapter().setContextMap(this.logEntry.toMap());
        }
        if (this.logQueue != null && !this.logToFile) {
            ContextAppender contextAppender = new ContextAppender(this, newLogger, this.logQueue, this.logEntry);
            contextAppender.setContext((Context)loggerContext);
            contextAppender.start();
            newLogger.addAppender((Appender)contextAppender);
        }
        if (this.logToFile) {
            try {
                this.logFile = File.createTempFile("log", ".txt");
                this.logFileOS = new BufferedOutputStream(new FileOutputStream(this.logFile));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            FileAppender fileAppender = new FileAppender(this, newLogger, this.logFileOS);
            fileAppender.setContext((Context)loggerContext);
            fileAppender.start();
            newLogger.addAppender((Appender)fileAppender);
        }
        ForwardAppender forwardAppender = new ForwardAppender(this, newLogger);
        forwardAppender.setContext((Context)loggerContext);
        forwardAppender.start();
        newLogger.addAppender((Appender)forwardAppender);
        newLogger.setLevel(this.loglevel);
        newLogger.setAdditive(true);
        return newLogger;
    }

    public void resetMDC() {
        this.logger.getLoggerContext().getMDCAdapter().clear();
    }

    @Override
    public Logger get() {
        return this.logger();
    }

    public void closeLogFile() throws IOException {
        if (this.logFileOS != null) {
            this.logFileOS.close();
        }
    }

    @Generated
    public File getLogFile() {
        return this.logFile;
    }

    public static class ContextAppender
    extends BaseAppender {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ContextAppender.class);
        private final QueueInterface<LogEntry> logQueue;
        private final LogEntry logEntry;

        public ContextAppender(RunContextLogger runContextLogger, ch.qos.logback.classic.Logger logger, QueueInterface<LogEntry> logQueue, LogEntry logEntry) {
            super(runContextLogger, logger);
            this.logQueue = logQueue;
            this.logEntry = logEntry;
        }

        protected void append(ILoggingEvent e) {
            e = this.transform(e);
            try {
                this.logQueue.emitAsync(RunContextLogger.logEntries(e, this.logEntry));
            }
            catch (QueueException ex) {
                log.warn("Unable to emit logQueue", (Throwable)ex);
            }
        }
    }

    public static class FileAppender
    extends BaseAppender {
        private static final ch.qos.logback.classic.Logger LOGGER = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"flow");
        private static final PatternLayout PATTERN_LAYOUT = new PatternLayout();
        private final OutputStream fileOS;

        public FileAppender(RunContextLogger runContextLogger, ch.qos.logback.classic.Logger logger, OutputStream fileOS) {
            super(runContextLogger, logger);
            this.fileOS = fileOS;
        }

        protected void append(ILoggingEvent e) {
            e = this.transform(e);
            try {
                String line = PATTERN_LAYOUT.doLayout(e);
                this.fileOS.write(line.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        static {
            PATTERN_LAYOUT.setPattern("%d{ISO8601} %-5.5level %-12.36thread %-12.36logger{36} %msg%n");
            PATTERN_LAYOUT.setContext((Context)LOGGER.getLoggerContext());
            PATTERN_LAYOUT.start();
        }
    }

    public static class ForwardAppender
    extends BaseAppender {
        private final ch.qos.logback.classic.Logger fowardLogger;

        protected ForwardAppender(RunContextLogger runContextLogger, ch.qos.logback.classic.Logger logger) {
            super(runContextLogger, logger);
            this.fowardLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)runContextLogger.loggerName);
        }

        public void start() {
            super.start();
        }

        public void stop() {
            super.stop();
        }

        protected void append(ILoggingEvent e) {
            if (this.fowardLogger.isEnabledFor((e = this.transform(e)).getLevel())) {
                this.fowardLogger.callAppenders(e);
            }
        }
    }

    public static abstract class BaseAppender
    extends AppenderBase<ILoggingEvent> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(BaseAppender.class);
        protected RunContextLogger runContextLogger;
        protected ch.qos.logback.classic.Logger logger;

        protected BaseAppender(RunContextLogger runContextLogger, ch.qos.logback.classic.Logger logger) {
            this.runContextLogger = runContextLogger;
            this.logger = logger;
        }

        private String replaceSecret(String data) {
            for (String s : this.runContextLogger.useSecrets) {
                if (!data.contains(s)) continue;
                data = data.replace(s, "******");
            }
            return data;
        }

        private Object recursive(@Nullable Object object) {
            if (object instanceof Map) {
                Map value = (Map)object;
                return value.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Object, Object>(this.recursive(e.getKey()), this.recursive(e.getValue()))).collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll);
            }
            if (object instanceof Collection) {
                Collection value = (Collection)object;
                return value.stream().map(this::recursive).toList();
            }
            if (object instanceof String) {
                String string = (String)object;
                return this.replaceSecret(string);
            }
            if (object == null) {
                return null;
            }
            return this.replaceSecret(object.toString());
        }

        private Object[] replaceSecret(Object[] data) {
            if (data == null) {
                return data;
            }
            Object[] result = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                result[i] = this.recursive(data[i]);
            }
            return result;
        }

        protected ILoggingEvent transform(ILoggingEvent event) {
            try {
                Throwable throwable;
                Object object;
                Optional<KeyValuePair> originalTimestampKv;
                String message = this.replaceSecret(event.getMessage());
                Object[] argumentArray = this.replaceSecret(event.getArgumentArray());
                Instant customTimestamp = null;
                if (event.getKeyValuePairs() != null && (originalTimestampKv = event.getKeyValuePairs().stream().filter(kv -> kv.key.equals(RunContextLogger.ORIGINAL_TIMESTAMP_KEY)).findFirst()).isPresent() && (object = originalTimestampKv.get().value) instanceof Instant) {
                    Instant instant;
                    customTimestamp = instant = (Instant)object;
                }
                Level level = event.getLevel();
                object = event.getThrowableProxy();
                if (object instanceof ThrowableProxy) {
                    ThrowableProxy throwableProxy = (ThrowableProxy)object;
                    throwable = throwableProxy.getThrowable();
                } else {
                    throwable = null;
                }
                LoggingEvent lle = new LoggingEvent("ch.qos.logback.classic.Logger", this.logger, level, message, throwable, argumentArray);
                if (customTimestamp != null) {
                    lle.setTimeStamp(customTimestamp.toEpochMilli());
                }
                return lle;
            }
            catch (Throwable e) {
                log.warn("Unable to replace secret", e);
                return event;
            }
        }
    }
}

