/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.AbstractFlow;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.flows.input.SecretInput;
import io.kestra.core.models.property.PropertyContext;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.Secret;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.trigger.Schedule;
import java.beans.ConstructorProperties;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class RunVariables {
    public static final String SECRET_CONSUMER_VARIABLE_NAME = "addSecretConsumer";
    public static final String FIXTURE_FILES_KEY = "io.kestra.datatype:test_fixtures_files";

    static Map<String, Object> of(Task task) {
        return Map.of("id", task.getId(), "type", task.getType());
    }

    static Map<String, Object> of(TaskRun taskRun) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"id", (Object)taskRun.getId()).put((Object)"startDate", (Object)taskRun.getState().getStartDate()).put((Object)"attemptsCount", (Object)(taskRun.getAttempts() == null ? 0 : taskRun.getAttempts().size()));
        if (taskRun.getParentTaskRunId() != null) {
            builder.put((Object)"parentId", (Object)taskRun.getParentTaskRunId());
        }
        if (taskRun.getValue() != null) {
            builder.put((Object)"value", (Object)taskRun.getValue());
        }
        if (taskRun.getIteration() != null) {
            builder.put((Object)"iteration", (Object)taskRun.getIteration());
        }
        return builder.build();
    }

    static Map<String, Object> of(FlowInterface flow) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)flow.getId()).put((Object)"namespace", (Object)flow.getNamespace());
        Optional.ofNullable(flow.getRevision()).ifPresent(revision -> builder.put((Object)"revision", revision));
        Optional.ofNullable(flow.getTenantId()).ifPresent(tenantId -> builder.put((Object)"tenantId", tenantId));
        return builder.build();
    }

    static Map<String, Object> of(AbstractTrigger trigger) {
        return Map.of("id", trigger.getId(), "type", trigger.getType());
    }

    private RunVariables() {
    }

    private record PropertyContextWithVariables(PropertyContext delegate, Map<String, Object> variables) implements PropertyContext
    {
        @Override
        public String render(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
            return this.delegate.render(inline, variables.isEmpty() ? this.variables : variables);
        }

        @Override
        public Map<String, Object> render(Map<String, Object> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
            return this.delegate.render(inline, variables.isEmpty() ? this.variables : variables);
        }
    }

    public static class DefaultBuilder
    implements Builder {
        protected FlowInterface flow;
        protected Task task;
        protected Execution execution;
        protected TaskRun taskRun;
        protected AbstractTrigger trigger;
        protected boolean decryptVariables = true;
        protected Map<String, Object> variables;
        protected Map<String, Object> inputs;
        protected Map<String, ?> envs;
        protected Map<?, ?> globals;
        private final Optional<String> secretKey;
        private List<String> secretInputs;
        private KestraConfiguration kestraConfiguration;

        public DefaultBuilder() {
            this(Optional.empty());
        }

        public DefaultBuilder(Optional<String> secretKey) {
            this.secretKey = secretKey;
        }

        @Override
        public Map<String, Object> build(RunContextLogger logger, PropertyContext propertyContext) {
            ImmutableMap.Builder builder;
            block29: {
                block30: {
                    builder = ImmutableMap.builder();
                    builder.put((Object)"envs", this.envs != null ? this.envs : Map.of());
                    builder.put((Object)"globals", this.globals != null ? this.globals : Map.of());
                    if (this.flow != null) {
                        builder.put((Object)"flow", RunVariables.of(this.flow));
                    }
                    if (this.task != null) {
                        builder.put((Object)"task", RunVariables.of(this.task));
                    }
                    if (this.taskRun != null) {
                        builder.put((Object)"taskrun", RunVariables.of(this.taskRun));
                    }
                    if (this.trigger != null) {
                        builder.put((Object)"trigger", RunVariables.of(this.trigger));
                    }
                    if (this.taskRun != null && this.execution != null) {
                        List<Map<String, Object>> parents = this.execution.parents(this.taskRun);
                        builder.put((Object)"parents", parents);
                        if (!parents.isEmpty()) {
                            builder.put((Object)"parent", parents.getFirst());
                        }
                    }
                    if (this.execution != null) {
                        HashMap<String, Object> inputs;
                        Secret secret;
                        ImmutableMap.Builder executionMap = ImmutableMap.builder();
                        executionMap.put((Object)"id", (Object)this.execution.getId());
                        if (this.execution.getState() != null) {
                            executionMap.put((Object)"state", (Object)this.execution.getState().getCurrent());
                        }
                        Optional.ofNullable(this.execution.getState()).map(State::getStartDate).ifPresent(startDate -> executionMap.put((Object)"startDate", startDate));
                        Optional.ofNullable(this.execution.getOriginalId()).ifPresent(originalId -> executionMap.put((Object)"originalId", originalId));
                        if (this.execution.getOutputs() != null) {
                            executionMap.put((Object)"outputs", this.execution.getOutputs());
                        }
                        builder.put((Object)"execution", (Object)executionMap.build());
                        if (this.execution.getTaskRunList() != null) {
                            Map<String, Object> outputs = this.execution.outputs();
                            if (this.decryptVariables) {
                                secret = new Secret(this.secretKey, logger);
                                outputs = secret.decrypt(outputs);
                            }
                            builder.put((Object)"outputs", outputs);
                            HashMap tasksMap = new HashMap();
                            this.execution.getTaskRunList().forEach(taskRun -> {
                                if (taskRun.getState() != null) {
                                    if (taskRun.getValue() == null) {
                                        tasksMap.put(taskRun.getTaskId(), Map.of("state", taskRun.getState().getCurrent()));
                                    } else if (tasksMap.containsKey(taskRun.getTaskId())) {
                                        Map taskRunMap = (Map)tasksMap.get(taskRun.getTaskId());
                                        taskRunMap.put(taskRun.getValue(), Map.of("state", taskRun.getState().getCurrent()));
                                        tasksMap.put(taskRun.getTaskId(), taskRunMap);
                                    } else {
                                        HashMap<String, Map<String, State.Type>> taskRunMap = new HashMap<String, Map<String, State.Type>>();
                                        taskRunMap.put(taskRun.getValue(), Map.of("state", taskRun.getState().getCurrent()));
                                        tasksMap.put(taskRun.getTaskId(), taskRunMap);
                                    }
                                }
                            });
                            builder.put((Object)"tasks", tasksMap);
                        }
                        HashMap<String, Object> hashMap = inputs = this.inputs == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.inputs);
                        if (this.execution.getInputs() != null) {
                            inputs.putAll(this.execution.getInputs());
                            if (this.decryptVariables && this.flow != null && this.flow.getInputs() != null) {
                                secret = new Secret(this.secretKey, logger);
                                for (Input<?> input2 : this.flow.getInputs()) {
                                    if (!(input2 instanceof SecretInput)) continue;
                                    this.decodeInput(secret, input2.getId(), inputs);
                                }
                            }
                        }
                        if (this.flow != null && this.flow.getInputs() != null) {
                            PropertyContextWithVariables context = new PropertyContextWithVariables(propertyContext, Map.of("flow", RunVariables.of(this.flow)));
                            this.flow.getInputs().stream().filter(input -> input.getDefaults() != null && !inputs.containsKey(input.getId())).forEach(input -> {
                                try {
                                    inputs.put(input.getId(), FlowInputOutput.resolveDefaultValue(input, context));
                                }
                                catch (IllegalVariableEvaluationException illegalVariableEvaluationException) {
                                    // empty catch block
                                }
                            });
                        }
                        if (!inputs.isEmpty()) {
                            builder.put((Object)"inputs", inputs);
                            if (logger != null && !ListUtils.isEmpty(this.secretInputs)) {
                                for (String secretInput : this.secretInputs) {
                                    String secret2 = (String)inputs.get(secretInput);
                                    if (secret2 == null) continue;
                                    logger.usedSecret(secret2);
                                }
                            }
                        }
                        if (this.execution.getTrigger() != null && this.execution.getTrigger().getVariables() != null) {
                            builder.put((Object)"trigger", this.execution.getTrigger().getVariables());
                            if (Schedule.class.getName().equals(this.execution.getTrigger().getType())) {
                                builder.put((Object)"schedule", this.execution.getTrigger().getVariables());
                            }
                        }
                        if (this.execution.getLabels() != null) {
                            builder.put((Object)"labels", Label.toNestedMap(this.execution.getLabels()));
                        }
                        if (this.flow == null) {
                            AbstractFlow flowFromExecution = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(this.execution.getFlowId())).tenantId(this.execution.getTenantId())).revision(this.execution.getFlowRevision())).namespace(this.execution.getNamespace())).build();
                            builder.put((Object)"flow", RunVariables.of(flowFromExecution));
                        }
                    }
                    Optional.ofNullable(this.execution).map(Execution::getVariables).or(() -> Optional.ofNullable(this.flow).map(FlowInterface::getVariables)).map(HashMap::new).ifPresent(variables -> {
                        Object fixtureFiles = variables.remove(RunVariables.FIXTURE_FILES_KEY);
                        builder.put((Object)"vars", (Object)ImmutableMap.copyOf((Map)variables));
                        if (fixtureFiles != null) {
                            builder.put((Object)"files", fixtureFiles);
                        }
                    });
                    if (this.kestraConfiguration != null) {
                        HashMap<String, String> kestra = HashMap.newHashMap(2);
                        if (this.kestraConfiguration.environment() != null) {
                            kestra.put("environment", this.kestraConfiguration.environment());
                        }
                        if (this.kestraConfiguration.url() != null) {
                            kestra.put("url", this.kestraConfiguration.url());
                        }
                        builder.put((Object)"kestra", kestra);
                    }
                    if (this.variables != null) {
                        builder.putAll(this.variables);
                    }
                    if (logger == null) break block29;
                    if (this.variables == null) break block30;
                    if (this.variables.containsKey(RunVariables.SECRET_CONSUMER_VARIABLE_NAME)) break block29;
                }
                builder.put((Object)RunVariables.SECRET_CONSUMER_VARIABLE_NAME, logger::usedSecret);
            }
            return builder.build();
        }

        private void decodeInput(Secret secret, String id, Map<String, Object> inputs) {
            if (id.indexOf(46) > -1) {
                String nestedId = id.substring(0, id.indexOf(46));
                String restOfId = id.substring(id.indexOf(46) + 1);
                this.decodeInput(secret, restOfId, (Map)inputs.get(nestedId));
            } else if (inputs.containsKey(id)) {
                try {
                    String decoded = secret.decrypt((String)inputs.get(id));
                    inputs.put(id, decoded);
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @ConstructorProperties(value={"flow", "task", "execution", "taskRun", "trigger", "decryptVariables", "variables", "inputs", "envs", "globals", "secretKey", "secretInputs", "kestraConfiguration"})
        @Generated
        public DefaultBuilder(FlowInterface flow, Task task, Execution execution, TaskRun taskRun, AbstractTrigger trigger, boolean decryptVariables, Map<String, Object> variables, Map<String, Object> inputs, Map<String, ?> envs, Map<?, ?> globals, Optional<String> secretKey, List<String> secretInputs, KestraConfiguration kestraConfiguration) {
            this.flow = flow;
            this.task = task;
            this.execution = execution;
            this.taskRun = taskRun;
            this.trigger = trigger;
            this.decryptVariables = decryptVariables;
            this.variables = variables;
            this.inputs = inputs;
            this.envs = envs;
            this.globals = globals;
            this.secretKey = secretKey;
            this.secretInputs = secretInputs;
            this.kestraConfiguration = kestraConfiguration;
        }

        @Override
        @Generated
        public DefaultBuilder withFlow(FlowInterface flow) {
            return this.flow == flow ? this : new DefaultBuilder(flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withTask(Task task) {
            return this.task == task ? this : new DefaultBuilder(this.flow, task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withExecution(Execution execution) {
            return this.execution == execution ? this : new DefaultBuilder(this.flow, this.task, execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withTaskRun(TaskRun taskRun) {
            return this.taskRun == taskRun ? this : new DefaultBuilder(this.flow, this.task, this.execution, taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withTrigger(AbstractTrigger trigger) {
            return this.trigger == trigger ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withDecryptVariables(boolean decryptVariables) {
            return this.decryptVariables == decryptVariables ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withVariables(Map<String, Object> variables) {
            return this.variables == variables ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withInputs(Map<String, Object> inputs) {
            return this.inputs == inputs ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, inputs, this.envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withEnvs(Map<String, ?> envs) {
            return this.envs == envs ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, envs, this.globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withGlobals(Map<?, ?> globals) {
            return this.globals == globals ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, globals, this.secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Generated
        public DefaultBuilder withSecretKey(Optional<String> secretKey) {
            return this.secretKey == secretKey ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, secretKey, this.secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withSecretInputs(List<String> secretInputs) {
            return this.secretInputs == secretInputs ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, secretInputs, this.kestraConfiguration);
        }

        @Override
        @Generated
        public DefaultBuilder withKestraConfiguration(KestraConfiguration kestraConfiguration) {
            return this.kestraConfiguration == kestraConfiguration ? this : new DefaultBuilder(this.flow, this.task, this.execution, this.taskRun, this.trigger, this.decryptVariables, this.variables, this.inputs, this.envs, this.globals, this.secretKey, this.secretInputs, kestraConfiguration);
        }
    }

    public record KestraConfiguration(String environment, String url) {
    }

    public static interface Builder {
        public Builder withFlow(FlowInterface var1);

        public Builder withInputs(Map<String, Object> var1);

        public Builder withTask(Task var1);

        public Builder withExecution(Execution var1);

        public Builder withTaskRun(TaskRun var1);

        public Builder withDecryptVariables(boolean var1);

        public Builder withVariables(Map<String, Object> var1);

        public Builder withTrigger(AbstractTrigger var1);

        public Builder withEnvs(Map<String, ?> var1);

        public Builder withGlobals(Map<?, ?> var1);

        public Builder withSecretInputs(List<String> var1);

        public Builder withKestraConfiguration(KestraConfiguration var1);

        public Map<String, Object> build(RunContextLogger var1, PropertyContext var2);
    }
}

