/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.runners.LocalWorkingDir;
import io.kestra.core.runners.WorkingDir;
import io.micronaut.context.annotation.Value;
import jakarta.inject.Singleton;
import java.nio.file.Path;
import java.util.Optional;

@Singleton
public class WorkingDirFactory {
    @Value(value="${kestra.tasks.tmp-dir.path}")
    protected Optional<String> tmpdirPath;

    public WorkingDir createWorkingDirectory() {
        return new LocalWorkingDir(this.getTmpDir());
    }

    private Path getTmpDir() {
        return Path.of(this.tmpdirPath.orElse(System.getProperty("java.io.tmpdir")), new String[0]);
    }
}

