/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplaceFilter
implements Filter {
    public static final String FILTER_NAME = "replace";
    private static final String ARGUMENT_PAIRS = "replace_pairs";
    private static final String ARGUMENT_REGEXP = "regexp";
    private static final List<String> ARGS = List.of("replace_pairs", "regexp");

    public List<String> getArgumentNames() {
        return ARGS;
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (args.get(ARGUMENT_PAIRS) == null) {
            throw new PebbleException(null, MessageFormat.format("The argument ''{0}'' is required.", ARGUMENT_PAIRS), Integer.valueOf(lineNumber), self.getName());
        }
        boolean regexp = args.containsKey(ARGUMENT_REGEXP) ? (Boolean)args.get(ARGUMENT_REGEXP) : false;
        Map replacePair = (Map)args.get(ARGUMENT_PAIRS);
        if (input instanceof Map) {
            return this.processMap((Map)input, replacePair, regexp);
        }
        if (input instanceof List) {
            return this.processList((List)input, replacePair, regexp);
        }
        return this.processString(input.toString(), replacePair, regexp);
    }

    private Object processMap(Map<String, Object> inputMap, Map<?, ?> replacePair, boolean regexp) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String stringValue = (String)value;
                resultMap.put(entry.getKey(), this.processString(stringValue, replacePair, regexp));
                continue;
            }
            if (value instanceof Map) {
                resultMap.put(entry.getKey(), this.processMap((Map)value, replacePair, regexp));
                continue;
            }
            if (value instanceof List) {
                resultMap.put(entry.getKey(), this.processList((List)value, replacePair, regexp));
                continue;
            }
            resultMap.put(entry.getKey(), this.processString(value.toString(), replacePair, regexp));
        }
        return resultMap;
    }

    private Object processList(List<Object> inputList, Map<?, ?> replacePair, boolean regexp) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Object item : inputList) {
            if (item instanceof String) {
                String stringValue = (String)item;
                resultList.add(this.processString(stringValue, replacePair, regexp));
                continue;
            }
            if (item instanceof Map) {
                resultList.add(this.processMap((Map)item, replacePair, regexp));
                continue;
            }
            if (item instanceof List) {
                resultList.add(this.processList((List)item, replacePair, regexp));
                continue;
            }
            resultList.add(this.processString(item.toString(), replacePair, regexp));
        }
        return resultList;
    }

    private String processString(String input, Map<?, ?> replacePair, boolean regexp) {
        String data = input;
        for (Map.Entry<?, ?> entry : replacePair.entrySet()) {
            if (regexp) {
                data = data.replaceAll(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            data = data.replace(entry.getKey().toString(), entry.getValue().toString());
        }
        return data;
    }
}

