/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.JacksonYAMLParseException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.util.List;
import java.util.Map;

public class YamlFunction
implements Function {
    static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).findAndRegisterModules();
    private static final TypeReference<Object> TYPE_REFERENCE = new TypeReference<Object>(){};

    public List<String> getArgumentNames() {
        return List.of("yaml");
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        if (!args.containsKey("yaml")) {
            throw new PebbleException(null, "The 'yaml' function expects an argument 'yaml'.", Integer.valueOf(lineNumber), self.getName());
        }
        if (!(args.get("yaml") instanceof String)) {
            throw new PebbleException(null, "The 'yaml' function expects an argument 'yaml' with type string.", Integer.valueOf(lineNumber), self.getName());
        }
        String yaml = (String)args.get("yaml");
        try {
            return MAPPER.readValue(yaml, TYPE_REFERENCE);
        }
        catch (JacksonYAMLParseException e) {
            throw new PebbleException(null, "Invalid yaml: " + e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
        catch (JsonMappingException e) {
            throw new PebbleException(null, "Invalid yaml: " + e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
        catch (JsonProcessingException e) {
            throw new PebbleException(null, "Invalid yaml: " + e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
    }
}

