/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public final class FileSerde {
    public static final int BUFFER_SIZE = 32768;
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = JacksonMapper.ofIon();
    private static final ObjectMapper JSON_OBJECT_MAPPER = JacksonMapper.ofJson();
    private static final TypeReference<Object> DEFAULT_TYPE_REFERENCE = new TypeReference<Object>(){};

    private FileSerde() {
    }

    public static void write(OutputStream output, Object row) throws IOException {
        if (row != null) {
            output.write(DEFAULT_OBJECT_MAPPER.writeValueAsBytes(row));
            output.write("\n".getBytes());
        }
    }

    @Deprecated(since="0.19", forRemoval=true)
    public static Consumer<FluxSink<Object>> reader(BufferedReader input) {
        return s -> {
            try {
                String row;
                while ((row = input.readLine()) != null) {
                    s.next(FileSerde.convert(row));
                }
                s.complete();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @Deprecated(since="0.19", forRemoval=true)
    public static <T> Consumer<FluxSink<T>> reader(BufferedReader input, Class<T> cls) {
        return s -> {
            try {
                String row;
                while ((row = input.readLine()) != null) {
                    s.next(FileSerde.convert(row, cls));
                }
                s.complete();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static void reader(BufferedReader input, Consumer<Object> consumer) throws IOException {
        String row;
        while ((row = input.readLine()) != null) {
            consumer.accept(FileSerde.convert(row));
        }
    }

    public static boolean reader(BufferedReader input, int maxLines, Consumer<Object> consumer) throws IOException {
        String row;
        int nbLines = 0;
        while ((row = input.readLine()) != null) {
            if (nbLines >= maxLines) {
                return true;
            }
            consumer.accept(FileSerde.convert(row));
            ++nbLines;
        }
        return false;
    }

    private static Object convert(String row) throws JsonProcessingException {
        return DEFAULT_OBJECT_MAPPER.readValue(row, DEFAULT_TYPE_REFERENCE);
    }

    private static <T> T convert(String row, Class<T> cls) throws JsonProcessingException {
        return (T)DEFAULT_OBJECT_MAPPER.readValue(row, cls);
    }

    public static Flux<Object> readAll(Reader reader) throws IOException {
        return FileSerde.readAll(DEFAULT_OBJECT_MAPPER, reader, DEFAULT_TYPE_REFERENCE);
    }

    public static <T> Flux<T> readAll(Reader reader, TypeReference<T> type) throws IOException {
        return FileSerde.readAll(DEFAULT_OBJECT_MAPPER, reader, type);
    }

    public static <T> Flux<T> readAll(Reader reader, Class<T> type) throws IOException {
        return FileSerde.readAll(DEFAULT_OBJECT_MAPPER, reader, type);
    }

    public static Flux<Object> readAll(ObjectMapper objectMapper, Reader in) throws IOException {
        return FileSerde.readAll(objectMapper, in, DEFAULT_TYPE_REFERENCE);
    }

    public static <T> Flux<T> readAll(ObjectMapper objectMapper, Reader reader, TypeReference<T> type) throws IOException {
        MappingIterator<T> mappingIterator = FileSerde.createMappingIterator(objectMapper, reader, type);
        return FileSerde.readAll(mappingIterator);
    }

    public static <T> Flux<T> readAll(ObjectMapper objectMapper, Reader reader, Class<T> type) throws IOException {
        MappingIterator<T> mappingIterator = FileSerde.createMappingIterator(objectMapper, reader, type);
        return FileSerde.readAll(mappingIterator);
    }

    public static <T> Flux<T> readAll(MappingIterator<T> mappingIterator) throws IOException {
        return Flux.create(sink -> {
            mappingIterator.forEachRemaining(arg_0 -> ((FluxSink)sink).next(arg_0));
            sink.complete();
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER).doFinally(Rethrow.throwConsumer(ignored -> mappingIterator.close()));
    }

    public static <T> Mono<Long> writeAll(Writer writer, Flux<T> values) throws IOException {
        return FileSerde.writeAll(DEFAULT_OBJECT_MAPPER, writer, values);
    }

    public static <T> Mono<Long> writeAll(ObjectMapper objectMapper, Writer writer, Flux<T> values) throws IOException {
        SequenceWriter seqWriter = FileSerde.createSequenceWriter(objectMapper, writer, new TypeReference<T>(){});
        return FileSerde.writeAll(values, seqWriter);
    }

    public static <T> Mono<Long> writeAll(Flux<T> values, SequenceWriter seqWriter) throws IOException {
        return values.filter(Objects::nonNull).doOnNext(Rethrow.throwConsumer(arg_0 -> ((SequenceWriter)seqWriter).write(arg_0))).doFinally(Rethrow.throwConsumer(ignored -> seqWriter.flush())).count();
    }

    private static <T> MappingIterator<T> createMappingIterator(ObjectMapper objectMapper, Reader reader, TypeReference<T> type) throws IOException {
        try (JsonParser parser = objectMapper.createParser(reader);){
            MappingIterator mappingIterator = objectMapper.readerFor(type).readValues(parser);
            return mappingIterator;
        }
    }

    private static <T> MappingIterator<T> createMappingIterator(ObjectMapper objectMapper, Reader reader, Class<T> type) throws IOException {
        try (JsonParser parser = objectMapper.createParser(reader);){
            MappingIterator mappingIterator = objectMapper.readerFor(type).readValues(parser);
            return mappingIterator;
        }
    }

    public static <T> SequenceWriter createSequenceWriter(ObjectMapper objectMapper, Writer writer, TypeReference<T> type) throws IOException {
        return objectMapper.writerFor(type).writeValues(writer);
    }

    public static <T> SequenceWriter createJsonSequenceWriter(Writer writer, TypeReference<T> type) throws IOException {
        return JSON_OBJECT_MAPPER.writerFor(type).withRootValueSeparator("\n").writeValues(writer);
    }
}

