/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.repositories.LogRepositoryInterface;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.event.Level;

@Singleton
public class ExecutionLogService {
    @Inject
    private LogRepositoryInterface logRepository;

    public InputStream getExecutionLogsAsStream(String tenantId, String executionId, Level minLevel, String taskRunId, List<String> taskIds, Integer attempt, boolean withAccessControl) {
        List<LogEntry> logs = this.getExecutionLogs(tenantId, executionId, minLevel, taskRunId, taskIds, attempt, withAccessControl);
        return new ByteArrayInputStream(logs.stream().map(LogEntry::toPrettyString).collect(Collectors.joining("\n")).getBytes());
    }

    public List<LogEntry> getExecutionLogs(String tenantId, String executionId, Level minLevel, String taskRunId, List<String> taskIds, Integer attempt, boolean withAccessControl) {
        if (taskIds != null) {
            if (taskIds.size() == 1) {
                return withAccessControl ? this.logRepository.findByExecutionIdAndTaskId(tenantId, executionId, taskIds.getFirst(), minLevel) : this.logRepository.findByExecutionIdAndTaskIdWithoutAcl(tenantId, executionId, taskIds.getFirst(), minLevel);
            }
            return this.getExecutionLogs(tenantId, executionId, minLevel, taskIds, withAccessControl).toList();
        }
        if (taskRunId != null) {
            if (attempt != null) {
                return withAccessControl ? this.logRepository.findByExecutionIdAndTaskRunIdAndAttempt(tenantId, executionId, taskRunId, minLevel, attempt) : this.logRepository.findByExecutionIdAndTaskRunIdAndAttemptWithoutAcl(tenantId, executionId, taskRunId, minLevel, attempt);
            }
            return withAccessControl ? this.logRepository.findByExecutionIdAndTaskRunId(tenantId, executionId, taskRunId, minLevel) : this.logRepository.findByExecutionIdAndTaskRunIdWithoutAcl(tenantId, executionId, taskRunId, minLevel);
        }
        return withAccessControl ? this.logRepository.findByExecutionId(tenantId, executionId, minLevel) : this.logRepository.findByExecutionIdWithoutAcl(tenantId, executionId, minLevel);
    }

    public Stream<LogEntry> getExecutionLogs(String tenantId, String executionId, Level minLevel, List<String> taskIds, boolean withAccessControl) {
        List<LogEntry> results = withAccessControl ? this.logRepository.findByExecutionId(tenantId, executionId, minLevel) : this.logRepository.findByExecutionIdWithoutAcl(tenantId, executionId, minLevel);
        return results.stream().filter(data -> taskIds.isEmpty() || taskIds.contains(data.getTaskId()));
    }
}

