/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.topologies.FlowTopology;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.models.validations.ValidateConstraintViolation;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.FlowTopologyRepositoryInterface;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.flow.Pause;
import io.kestra.plugin.core.flow.Subflow;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FlowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowService.class);
    @Inject
    Optional<FlowRepositoryInterface> flowRepository;
    @Inject
    PluginDefaultService pluginDefaultService;
    @Inject
    PluginRegistry pluginRegistry;
    @Inject
    ModelValidator modelValidator;
    @Inject
    Optional<FlowTopologyRepositoryInterface> flowTopologyRepository;

    public FlowWithSource create(GenericFlow flow, boolean strictValidation) throws FlowProcessingException {
        Objects.requireNonNull(flow, "Cannot create null flow");
        if (flow.getSource() == null || flow.getSource().isBlank()) {
            throw new IllegalArgumentException("Cannot create flow with null or blank source");
        }
        FlowWithSource parsed = this.pluginDefaultService.parseFlowWithVersionDefaults(flow.getTenantId(), flow.getSource(), strictValidation);
        this.modelValidator.validate(this.pluginDefaultService.injectAllDefaults((FlowInterface)parsed, false));
        return this.repository().create(flow);
    }

    private FlowRepositoryInterface repository() {
        return this.flowRepository.orElseThrow(() -> new IllegalStateException("Cannot perform operation on flow. Cause: No FlowRepository"));
    }

    public List<ValidateConstraintViolation> validate(String tenantId, String flows) {
        AtomicInteger index = new AtomicInteger(0);
        return Stream.of(flows.split("\\n+---\\n*?")).map(source -> {
            ValidateConstraintViolation.ValidateConstraintViolationBuilder<?, ?> validateConstraintViolationBuilder = ValidateConstraintViolation.builder();
            validateConstraintViolationBuilder.index(index.getAndIncrement());
            try {
                FlowWithSource flow = this.pluginDefaultService.parseFlowWithVersionDefaults(tenantId, (String)source, true);
                Integer sentRevision = flow.getRevision();
                if (sentRevision != null) {
                    Integer lastRevision = Optional.ofNullable(this.repository().lastRevision(tenantId, flow.getNamespace(), flow.getId())).orElse(0);
                    validateConstraintViolationBuilder.outdated(!sentRevision.equals(lastRevision + 1));
                }
                validateConstraintViolationBuilder.deprecationPaths(this.deprecationPaths(flow));
                validateConstraintViolationBuilder.warnings(this.warnings(flow, tenantId));
                validateConstraintViolationBuilder.infos(this.relocations((String)source).stream().map(relocation -> relocation.from() + " is replaced by " + relocation.to()).toList());
                validateConstraintViolationBuilder.flow(flow.getId());
                validateConstraintViolationBuilder.namespace(flow.getNamespace());
                this.modelValidator.validate(this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, false));
            }
            catch (ConstraintViolationException e) {
                validateConstraintViolationBuilder.constraints(e.getMessage());
            }
            catch (FlowProcessingException e) {
                if (e.getCause() instanceof ConstraintViolationException) {
                    validateConstraintViolationBuilder.constraints(e.getMessage());
                } else {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    validateConstraintViolationBuilder.constraints("Unable to validate the flow: " + cause.getMessage());
                }
            }
            catch (RuntimeException re) {
                log.error("Unable to validate the flow", (Throwable)re);
                validateConstraintViolationBuilder.constraints("Unable to validate the flow: " + re.getMessage());
            }
            return validateConstraintViolationBuilder.build();
        }).collect(Collectors.toList());
    }

    public FlowWithSource importFlow(String tenantId, String source) throws FlowProcessingException {
        return this.importFlow(tenantId, source, false);
    }

    public FlowWithSource importFlow(String tenantId, String source, boolean dryRun) throws FlowProcessingException {
        GenericFlow flow = GenericFlow.fromYaml(tenantId, source);
        Optional<FlowWithSource> maybeExisting = this.repository().findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId(), Optional.empty(), true);
        FlowWithSource flowToImport = this.pluginDefaultService.injectVersionDefaults(flow, false);
        if (dryRun) {
            return maybeExisting.map(previous -> previous.isSameWithSource(flowToImport) && !previous.isDeleted() ? previous : FlowWithSource.of(((FlowWithSource.FlowWithSourceBuilder)flowToImport.toBuilder().revision(previous.getRevision() + 1)).build(), source)).orElseGet(() -> ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.of(flowToImport, source).toBuilder().tenantId(tenantId)).revision(1)).build());
        }
        return maybeExisting.map(previous -> this.repository().update(flow, (FlowInterface)previous)).orElseGet(() -> this.repository().create(flow));
    }

    public List<FlowWithSource> findByNamespaceWithSource(String tenantId, String namespace) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return this.flowRepository.get().findByNamespaceWithSource(tenantId, namespace);
    }

    public List<Flow> findAll(String tenantId) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return this.flowRepository.get().findAll(tenantId);
    }

    public List<Flow> findByNamespace(String tenantId, String namespace) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return this.flowRepository.get().findByNamespace(tenantId, namespace);
    }

    public Optional<Flow> findById(String tenantId, String namespace, String flowId) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return this.flowRepository.get().findById(tenantId, namespace, flowId);
    }

    public Stream<FlowInterface> keepLastVersion(Stream<FlowInterface> stream) {
        return this.keepLastVersionCollector(stream);
    }

    public List<String> deprecationPaths(Flow flow) {
        return this.deprecationTraversal("", flow).toList();
    }

    public List<String> warnings(Flow flow, String tenantId) {
        if (flow == null) {
            return Collections.emptyList();
        }
        ArrayList<String> warnings = new ArrayList<String>(this.checkValidSubflows(flow, tenantId));
        List<io.kestra.plugin.core.trigger.Flow> flowTriggers = ListUtils.emptyOnNull(flow.getTriggers()).stream().filter(io.kestra.plugin.core.trigger.Flow.class::isInstance).map(io.kestra.plugin.core.trigger.Flow.class::cast).toList();
        flowTriggers.forEach(flowTrigger -> {
            if (ListUtils.emptyOnNull(flowTrigger.getConditions()).isEmpty() && flowTrigger.getPreconditions() == null) {
                warnings.add("This flow will be triggered for EVERY execution of EVERY flow on your instance. We recommend adding the preconditions property to the Flow trigger '" + flowTrigger.getId() + "'.");
            }
        });
        flow.allTasksWithChilds().forEach(task -> {
            if (!(task instanceof RunnableTask)) {
                if (task.getTimeout() != null && !(task instanceof Pause)) {
                    warnings.add("The task '" + task.getId() + "' cannot use the 'timeout' property as it's only relevant for runnable tasks.");
                }
                if (task.getTaskCache() != null) {
                    warnings.add("The task '" + task.getId() + "' cannot use the 'taskCache' property as it's only relevant for runnable tasks.");
                }
                if (task.getWorkerGroup() != null) {
                    warnings.add("The task '" + task.getId() + "' cannot use the 'workerGroup' property as it's only relevant for runnable tasks.");
                }
            }
        });
        return warnings;
    }

    public List<Relocation> relocations(String flowSource) {
        try {
            Map<String, Class<?>> aliases = this.pluginRegistry.plugins().stream().flatMap(plugin -> plugin.getAliases().values().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, duplicate) -> existing));
            Map stringObjectMap = (Map)JacksonMapper.ofYaml().readValue(flowSource, JacksonMapper.MAP_TYPE_REFERENCE);
            return this.relocations(aliases, stringObjectMap);
        }
        catch (JsonProcessingException e) {
            return Collections.emptyList();
        }
    }

    public List<String> checkValidSubflows(Flow flow, String tenantId) {
        List<Subflow> subFlows = ListUtils.emptyOnNull(flow.getTasks()).stream().filter(Subflow.class::isInstance).map(Subflow.class::cast).toList();
        ArrayList<String> violations = new ArrayList<String>();
        subFlows.forEach(subflow -> {
            String regex = ".*\\{\\{.+}}.*";
            String subflowId = subflow.getFlowId();
            String namespace = subflow.getNamespace();
            if (subflowId != null && subflowId.matches(regex) || namespace != null && namespace.matches(regex)) {
                return;
            }
            if (subflowId == null || namespace == null) {
                return;
            }
            Optional<Flow> optional = this.findById(tenantId, subflow.getNamespace(), subflow.getFlowId());
            if (optional.isEmpty()) {
                violations.add("The subflow '" + subflow.getFlowId() + "' not found in namespace '" + subflow.getNamespace() + "'.");
            } else if (optional.get().isDisabled()) {
                violations.add("The subflow '" + subflow.getFlowId() + "' is disabled in namespace '" + subflow.getNamespace() + "'.");
            }
        });
        return violations;
    }

    private List<Relocation> relocations(Map<String, Class<?>> aliases, Map<String, Object> stringObjectMap) {
        ArrayList<Relocation> relocations = new ArrayList<Relocation>();
        for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
            Object value;
            Object object = entry.getValue();
            if (object instanceof String && aliases.containsKey(value = (String)object)) {
                relocations.add(new Relocation((String)value, aliases.get(value).getName()));
            }
            if ((object = entry.getValue()) instanceof Map) {
                value = (Map)object;
                relocations.addAll(this.relocations(aliases, (Map<String, Object>)value));
            }
            if (!((object = entry.getValue()) instanceof List)) continue;
            value = (List)object;
            List listAliases = value.stream().flatMap(item -> {
                if (item instanceof Map) {
                    Map map = (Map)item;
                    return this.relocations(aliases, map).stream();
                }
                return Stream.empty();
            }).toList();
            relocations.addAll(listAliases);
        }
        return relocations;
    }

    private Stream<String> deprecationTraversal(String prefix, Object object) {
        if (object == null || ClassUtils.isPrimitiveOrWrapper(object.getClass()) || String.class.equals(object.getClass())) {
            return Stream.empty();
        }
        return Stream.concat(object.getClass().isAnnotationPresent(Deprecated.class) ? Stream.of(prefix) : Stream.empty(), this.allGetters(object.getClass()).flatMap(method -> {
            try {
                Object[] fieldValue = method.invoke(object, new Object[0]);
                if (fieldValue instanceof Iterable) {
                    Iterable iterableValue = (Iterable)fieldValue;
                    fieldValue = StreamSupport.stream(iterableValue.spliterator(), false).toArray(Object[]::new);
                }
                String fieldName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                Stream<Object> additionalDeprecationPaths = Stream.empty();
                if (fieldValue instanceof Object[]) {
                    Object[] arrayValue = fieldValue;
                    additionalDeprecationPaths = IntStream.range(0, arrayValue.length).boxed().flatMap(i -> this.deprecationTraversal(fieldName + "[%d]".formatted(i), arrayValue[i]));
                }
                return Stream.concat(method.isAnnotationPresent(Deprecated.class) && fieldValue != null ? Stream.of(prefix.isEmpty() ? fieldName : prefix + "." + fieldName) : Stream.empty(), additionalDeprecationPaths);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return Stream.empty();
            }
        }));
    }

    private Stream<Method> allGetters(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(m -> !m.getDeclaringClass().equals(Object.class)).filter(method -> method.getName().startsWith("get") && method.getName().length() > 3 && method.getParameterCount() == 0).filter(method -> !method.getReturnType().equals(Void.TYPE)).filter(method -> !Modifier.isStatic(method.getModifiers()));
    }

    public Collection<FlowInterface> keepLastVersion(List<FlowInterface> flows) {
        return this.keepLastVersionCollector(flows.stream()).toList();
    }

    public Stream<FlowInterface> keepLastVersionCollector(Stream<FlowInterface> stream) {
        HashMap latestFlows = new HashMap();
        stream.forEach(flow -> {
            String uid = flow.uidWithoutRevision();
            FlowInterface existing = (FlowInterface)latestFlows.get(uid);
            if (existing == null || flow.getRevision() > existing.getRevision()) {
                latestFlows.put(uid, flow);
            } else if (flow.getRevision().equals(existing.getRevision()) && flow.isDeleted()) {
                latestFlows.put(uid, flow);
            }
        });
        return latestFlows.values().stream().filter(flow -> !flow.isDeleted());
    }

    public boolean removeUnwanted(Flow f, Execution execution) {
        return !f.uidWithoutRevision().equals(FlowId.uidWithoutRevision(execution));
    }

    public static List<AbstractTrigger> findRemovedTrigger(Flow flow, Flow previous) {
        return ListUtils.emptyOnNull(previous.getTriggers()).stream().filter(p -> ListUtils.emptyOnNull(flow.getTriggers()).stream().noneMatch(c -> c.getId().equals(p.getId()))).toList();
    }

    public static List<AbstractTrigger> findUpdatedTrigger(Flow flow, Flow previous) {
        return ListUtils.emptyOnNull(flow.getTriggers()).stream().filter(oldTrigger -> ListUtils.emptyOnNull(previous.getTriggers()).stream().anyMatch(trigger -> trigger.getId().equals(oldTrigger.getId()) && !EqualsBuilder.reflectionEquals((Object)trigger, (Object)oldTrigger, (String[])new String[0]))).toList();
    }

    public static String cleanupSource(String source) {
        return source.replaceFirst("(?m)^revision: \\d+\n?", "");
    }

    public static String injectDisabled(String source, Boolean disabled) {
        String regex = disabled != false ? "^disabled\\s*:\\s*false\\s*" : "^disabled\\s*:\\s*true\\s*";
        Pattern p = Pattern.compile(regex, 8);
        if (p.matcher(source).find()) {
            return p.matcher(source).replaceAll(String.format("disabled: %s\n", disabled));
        }
        return source + String.format("\ndisabled: %s", disabled);
    }

    public List<Flow> findByNamespacePrefix(String tenantId, String namespacePrefix) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return this.flowRepository.get().findByNamespacePrefix(tenantId, namespacePrefix);
    }

    public FlowWithSource delete(FlowWithSource flow) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return this.flowRepository.get().delete(flow);
    }

    public boolean isAllowedNamespace(String tenant, String namespace, String fromTenant, String fromNamespace) {
        return true;
    }

    public void checkAllowedNamespace(String tenant, String namespace, String fromTenant, String fromNamespace) {
        if (!this.isAllowedNamespace(tenant, namespace, fromTenant, fromNamespace)) {
            throw new IllegalArgumentException("Namespace " + namespace + " is not allowed.");
        }
    }

    public boolean areAllowedAllNamespaces(String tenant, String fromTenant, String fromNamespace) {
        return true;
    }

    public void checkAllowedAllNamespaces(String tenant, String fromTenant, String fromNamespace) {
        if (!this.areAllowedAllNamespaces(tenant, fromTenant, fromNamespace)) {
            throw new IllegalArgumentException("All namespaces are not allowed, you should either filter on a namespace or configure all namespaces to allow your namespace.");
        }
    }

    public boolean requireExistingNamespace(String tenant, String namespace) {
        return false;
    }

    public Flow getFlowIfExecutableOrThrow(String tenant, String namespace, String id, Optional<Integer> revision) {
        if (this.flowRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        Optional<Flow> optional = this.flowRepository.get().findByIdWithoutAcl(tenant, namespace, id, revision);
        if (optional.isEmpty()) {
            throw new NoSuchElementException("Requested Flow is not found.");
        }
        Flow flow = optional.get();
        if (flow.isDisabled()) {
            throw new IllegalStateException("Requested Flow is disabled.");
        }
        if (flow instanceof FlowWithException) {
            FlowWithException fwe = (FlowWithException)flow;
            throw new IllegalStateException("Requested Flow is not valid. Error: " + fwe.getException());
        }
        return flow;
    }

    public Stream<FlowTopology> findDependencies(String tenant, String namespace, String id, boolean destinationOnly, boolean expandAll) {
        if (this.flowTopologyRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        return expandAll ? this.recursiveFlowTopology(new ArrayList<String>(), tenant, namespace, id, destinationOnly) : this.flowTopologyRepository.get().findByFlow(tenant, namespace, id, destinationOnly).stream();
    }

    private Stream<FlowTopology> recursiveFlowTopology(List<String> visitedTopologies, String tenantId, String namespace, String id, boolean destinationOnly) {
        if (this.flowTopologyRepository.isEmpty()) {
            throw this.noRepositoryException();
        }
        List<FlowTopology> flowTopologies = this.flowTopologyRepository.get().findByFlow(tenantId, namespace, id, destinationOnly);
        return flowTopologies.stream().filter(x -> !visitedTopologies.contains(x.uid())).flatMap(topology -> {
            visitedTopologies.add(topology.uid());
            Stream subTopologies = Stream.of(topology.getDestination(), topology.getSource()).flatMap(relationNode -> this.recursiveFlowTopology(visitedTopologies, relationNode.getTenantId(), relationNode.getNamespace(), relationNode.getId(), destinationOnly));
            return Stream.concat(Stream.of(topology), subTopologies);
        });
    }

    private IllegalStateException noRepositoryException() {
        return new IllegalStateException("No repository found. Make sure the `kestra.repository.type` property is set.");
    }

    public record Relocation(String from, String to) {
    }
}

