/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.FlowGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.models.hierarchies.SubflowGraphCluster;
import io.kestra.core.models.hierarchies.SubflowGraphTask;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.Rethrow;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GraphService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphService.class);
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private TriggerRepositoryInterface triggerRepository;
    @Inject
    private PluginDefaultService pluginDefaultService;
    @Inject
    private RunContextFactory runContextFactory;

    public FlowGraph flowGraph(FlowWithSource flow, List<String> expandedSubflows) throws IllegalVariableEvaluationException, FlowProcessingException {
        return this.flowGraph(flow, expandedSubflows, null);
    }

    public FlowGraph flowGraph(FlowWithSource flow, List<String> expandedSubflows, Execution execution) throws IllegalVariableEvaluationException, FlowProcessingException {
        return FlowGraph.of(this.of(flow, Optional.ofNullable(expandedSubflows).orElse(Collections.emptyList()), new HashMap<String, FlowWithSource>(), execution));
    }

    public FlowGraph executionGraph(FlowWithSource flow, List<String> expandedSubflows, Execution execution) throws IllegalVariableEvaluationException, FlowProcessingException {
        return FlowGraph.of(this.of(flow, Optional.ofNullable(expandedSubflows).orElse(Collections.emptyList()), new HashMap<String, FlowWithSource>(), execution));
    }

    public GraphCluster of(FlowWithSource flow, List<String> expandedSubflows, Map<String, FlowWithSource> flowByUid, Execution execution) throws IllegalVariableEvaluationException, FlowProcessingException {
        return this.of(null, flow, expandedSubflows, flowByUid, execution);
    }

    public GraphCluster of(GraphCluster baseGraph, FlowWithSource flow, List<String> expandedSubflows, Map<String, FlowWithSource> flowByUid) throws IllegalVariableEvaluationException, FlowProcessingException {
        return this.of(baseGraph, flow, expandedSubflows, flowByUid, null);
    }

    public GraphCluster of(GraphCluster baseGraph, FlowWithSource flow, List<String> expandedSubflows, Map<String, FlowWithSource> flowByUid, Execution execution) throws IllegalVariableEvaluationException, FlowProcessingException {
        String tenantId = flow.getTenantId();
        flow = this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, false);
        ArrayListTotal<Trigger> triggers = null;
        if (flow.getTriggers() != null) {
            triggers = this.triggerRepository.find(Pageable.UNPAGED, null, tenantId, flow.getNamespace(), flow.getId(), null);
        }
        GraphCluster graphCluster = GraphUtils.of(baseGraph, flow, execution, triggers);
        Stream<TaskToClusterReplacer> subflowToReplaceByParent = graphCluster.allNodesByParent().entrySet().stream().flatMap(entry -> {
            List<SubflowGraphTask> subflowGraphTasks = ((List)entry.getValue()).stream().filter(node -> node instanceof SubflowGraphTask && expandedSubflows.contains(node.getUid())).map(SubflowGraphTask.class::cast).toList();
            if (subflowGraphTasks.isEmpty()) {
                return Stream.empty();
            }
            return subflowGraphTasks.stream().map(subflowGraphTask -> Map.entry((GraphCluster)entry.getKey(), subflowGraphTask));
        });
        FlowWithSource finalFlow = flow;
        subflowToReplaceByParent.map(Rethrow.throwFunction(parentWithSubflowGraphTask -> {
            SubflowGraphTask subflowGraphTask = (SubflowGraphTask)parentWithSubflowGraphTask.getValue();
            Task task = (Task)subflowGraphTask.getTask();
            RunContext runContext = subflowGraphTask.executableTask().subflowId().flowUid().contains("{{") && execution != null ? this.runContextFactory.of((FlowInterface)finalFlow, task, execution, subflowGraphTask.getTaskRun()) : null;
            ExecutableTask.SubflowId subflowId = (subflowGraphTask = subflowGraphTask.withRenderedSubflowId(runContext)).executableTask().subflowId();
            if (subflowId.flowUid().contains("{{")) {
                throw new IllegalArgumentException("Can't expand subflow task '" + task.getId() + "' because namespace and/or flowId contains dynamic values. This can only be viewed on an execution.");
            }
            FlowWithSource subflow = flowByUid.computeIfAbsent(subflowId.flowUid(), uid -> {
                Optional<FlowWithSource> flowById = execution != null ? this.flowRepository.findByIdWithSourceWithoutAcl(tenantId, subflowId.namespace(), subflowId.flowId(), subflowId.revision()) : this.flowRepository.findByIdWithSource(tenantId, subflowId.namespace(), subflowId.flowId(), subflowId.revision());
                return flowById.orElseThrow(() -> new NoSuchElementException("Unable to find subflow " + (subflowId.revision().isEmpty() ? subflowId.flowUidWithoutRevision() : subflowId.flowUid()) + " for task " + task.getId()));
            });
            subflow = this.pluginDefaultService.injectAllDefaults((FlowInterface)subflow, false);
            SubflowGraphTask finalSubflowGraphTask = subflowGraphTask;
            return new TaskToClusterReplacer((GraphCluster)parentWithSubflowGraphTask.getKey(), subflowGraphTask, this.of(new SubflowGraphCluster(subflowGraphTask.getUid(), subflowGraphTask), subflow, expandedSubflows.stream().filter(expandedSubflow -> expandedSubflow.startsWith(finalSubflowGraphTask.getUid() + ".")).toList(), flowByUid));
        })).forEach(TaskToClusterReplacer::replace);
        return graphCluster;
    }

    private record TaskToClusterReplacer(GraphCluster parentCluster, AbstractGraph taskToReplace, GraphCluster clusterForReplacement) {
        public void replace() {
            this.parentCluster.addNode(this.clusterForReplacement, false);
            this.parentCluster.getGraph().edges().forEach(edge -> {
                if (((AbstractGraph)edge.getSource()).equals(this.taskToReplace)) {
                    this.parentCluster.addEdge(this.clusterForReplacement.getEnd(), (AbstractGraph)edge.getTarget(), (Relation)edge.getValue());
                } else if (((AbstractGraph)edge.getTarget()).equals(this.taskToReplace)) {
                    this.parentCluster.addEdge((AbstractGraph)edge.getSource(), this.clusterForReplacement.getRoot(), (Relation)edge.getValue());
                }
            });
            this.parentCluster.getGraph().removeNode(this.taskToReplace);
            if (this.taskToReplace.getBranchType() != null) {
                this.clusterForReplacement.updateWithChildren(this.taskToReplace.getBranchType());
            }
        }
    }
}

