/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.services.LogService;
import io.kestra.core.services.PluginGlobalDefaultConfiguration;
import io.kestra.core.services.TaskGlobalDefaultConfiguration;
import io.kestra.core.utils.MapUtils;
import io.kestra.plugin.core.flow.Template;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public class PluginDefaultService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDefaultService.class);
    private static final ObjectMapper NON_DEFAULT_OBJECT_MAPPER = JacksonMapper.ofYaml().copy().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT);
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapper.ofYaml().copy().setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
    private static final String PLUGIN_DEFAULTS_FIELD = "pluginDefaults";
    private static final TypeReference<List<PluginDefault>> PLUGIN_DEFAULTS_TYPE_REF = new TypeReference<List<PluginDefault>>(){};
    @Nullable
    @Inject
    protected TaskGlobalDefaultConfiguration taskGlobalDefault;
    @Nullable
    @Inject
    protected PluginGlobalDefaultConfiguration pluginGlobalDefault;
    @Inject
    @Named(value="workerTaskLogQueue")
    @Nullable
    protected QueueInterface<LogEntry> logQueue;
    @Inject
    protected PluginRegistry pluginRegistry;
    @Inject
    protected Provider<LogService> logService;
    @Value(value="{kestra.templates.enabled:false}")
    private boolean templatesEnabled;
    private final AtomicBoolean warnOnce = new AtomicBoolean(false);

    @PostConstruct
    void validateGlobalPluginDefault() {
        ArrayList<PluginDefault> mergedDefaults = new ArrayList<PluginDefault>();
        if (this.taskGlobalDefault != null && this.taskGlobalDefault.getDefaults() != null) {
            mergedDefaults.addAll(this.taskGlobalDefault.getDefaults());
        }
        if (this.pluginGlobalDefault != null && this.pluginGlobalDefault.getDefaults() != null) {
            mergedDefaults.addAll(this.pluginGlobalDefault.getDefaults());
        }
        mergedDefaults.stream().flatMap(pluginDefault -> this.validateDefault((PluginDefault)pluginDefault).stream()).forEach(violation -> log.error("Invalid plugin default configuration: {}", violation));
    }

    protected List<PluginDefault> getAllDefaults(String tenantId, String namespace, Map<String, Object> flow) {
        ArrayList<PluginDefault> defaults = new ArrayList<PluginDefault>();
        defaults.addAll(this.getFlowDefaults(flow));
        defaults.addAll(this.getGlobalDefaults());
        return defaults;
    }

    protected List<PluginDefault> getFlowDefaults(Map<String, Object> flow) {
        Object defaults = flow.get(PLUGIN_DEFAULTS_FIELD);
        if (defaults != null) {
            return (List)OBJECT_MAPPER.convertValue(defaults, PLUGIN_DEFAULTS_TYPE_REF);
        }
        return List.of();
    }

    protected List<PluginDefault> getGlobalDefaults() {
        ArrayList<PluginDefault> defaults = new ArrayList<PluginDefault>();
        if (this.taskGlobalDefault != null && this.taskGlobalDefault.getDefaults() != null) {
            if (this.warnOnce.compareAndSet(false, true)) {
                log.warn("Global Task Defaults are deprecated, please use Global Plugin Defaults instead via the 'kestra.plugins.defaults' configuration property.");
            }
            defaults.addAll(this.taskGlobalDefault.getDefaults());
        }
        if (this.pluginGlobalDefault != null && this.pluginGlobalDefault.getDefaults() != null) {
            defaults.addAll(this.pluginGlobalDefault.getDefaults());
        }
        return defaults;
    }

    public FlowWithSource injectDefaults(FlowInterface flow, Execution execution) {
        try {
            return this.injectAllDefaults(flow, false);
        }
        catch (Exception e) {
            try {
                this.logQueue.emitAsync(RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(execution)));
            }
            catch (QueueException queueException) {
                // empty catch block
            }
            return PluginDefaultService.readWithoutDefaultsOrThrow(flow);
        }
    }

    public FlowWithSource injectAllDefaults(FlowInterface flow, Logger logger) {
        try {
            return this.injectAllDefaults(flow, false);
        }
        catch (Exception e) {
            logger.warn("Can't inject plugin defaults on tenant {}, namespace '{}', flow '{}' with errors '{}'", new Object[]{flow.getTenantId(), flow.getNamespace(), flow.getId(), e.getMessage(), e});
            return PluginDefaultService.readWithoutDefaultsOrThrow(flow);
        }
    }

    private static FlowWithSource readWithoutDefaultsOrThrow(FlowInterface flow) {
        if (flow instanceof FlowWithSource) {
            FlowWithSource item = (FlowWithSource)flow;
            return item;
        }
        if (flow instanceof Flow) {
            Flow item = (Flow)flow;
            return FlowWithSource.of(item, item.sourceOrGenerateIfNull());
        }
        try {
            Flow parsed = (Flow)NON_DEFAULT_OBJECT_MAPPER.readValue(flow.getSource(), Flow.class);
            return FlowWithSource.of(parsed, flow.getSource());
        }
        catch (JsonProcessingException e) {
            throw new KestraRuntimeException("Failed to read flow from source", e);
        }
    }

    public FlowWithSource injectAllDefaults(FlowInterface flow, boolean strictParsing) throws FlowProcessingException {
        String source = flow.sourceOrGenerateIfNull();
        if (source == null) {
            String error = "Cannot apply plugin defaults. Cause: flow has no defined source.";
            ((LogService)this.logService.get()).logExecution(flow, log, Level.ERROR, error, new Object[0]);
            throw new IllegalArgumentException(error);
        }
        try {
            return this.parseFlowWithAllDefaults(flow.getTenantId(), flow.getNamespace(), flow.getRevision(), flow.isDeleted(), source, false, strictParsing);
        }
        catch (ConstraintViolationException e) {
            throw new FlowProcessingException(e);
        }
        catch (JsonProcessingException e) {
            throw new FlowProcessingException(YamlParser.toConstraintViolationException(source, "Flow", e));
        }
    }

    public FlowWithSource injectVersionDefaults(FlowInterface flow, boolean safe) throws FlowProcessingException {
        Flow result;
        if (flow instanceof FlowWithSource) {
            FlowWithSource flowWithSource = (FlowWithSource)flow;
            return flowWithSource;
        }
        try {
            String source = flow.getSource();
            if (source == null) {
                source = OBJECT_MAPPER.writeValueAsString((Object)flow);
            }
            result = this.parseFlowWithAllDefaults(flow.getTenantId(), flow.getNamespace(), flow.getRevision(), flow.isDeleted(), source, true, false);
        }
        catch (Exception e) {
            if (safe) {
                ((LogService)this.logService.get()).logExecution(flow, log, Level.ERROR, "Failed to read flow.", e);
                result = FlowWithException.from(flow, e);
                result = ((FlowWithSource.FlowWithSourceBuilder)result.toBuilder().deleted(flow.isDeleted())).build();
            }
            throw new FlowProcessingException(e);
        }
        return result;
    }

    public Map<String, Object> injectVersionDefaults(@Nullable String tenantId, String namespace, Map<String, Object> mapFlow) throws FlowProcessingException {
        return this.innerInjectDefault(tenantId, namespace, mapFlow, true);
    }

    public FlowWithSource parseFlowWithAllDefaults(@Nullable String tenantId, String source, boolean strict) throws FlowProcessingException {
        try {
            return this.parseFlowWithAllDefaults(tenantId, null, null, false, source, false, strict);
        }
        catch (ConstraintViolationException e) {
            throw new FlowProcessingException(e);
        }
        catch (JsonProcessingException e) {
            throw new FlowProcessingException(YamlParser.toConstraintViolationException(source, "Flow", e));
        }
    }

    public FlowWithSource parseFlowWithVersionDefaults(@Nullable String tenantId, String source, boolean strictParsing) throws FlowProcessingException {
        try {
            return this.parseFlowWithAllDefaults(tenantId, null, null, false, source, true, strictParsing);
        }
        catch (ConstraintViolationException e) {
            throw new FlowProcessingException(e);
        }
        catch (JsonProcessingException e) {
            throw new FlowProcessingException(YamlParser.toConstraintViolationException(source, "Flow", e));
        }
    }

    private FlowWithSource parseFlowWithAllDefaults(@Nullable String tenant, @Nullable String namespace, @Nullable Integer revision, boolean isDeleted, String source, boolean onlyVersions, boolean strictParsing) throws ConstraintViolationException, JsonProcessingException {
        Map<String, Object> mapFlow = (Map<String, Object>)OBJECT_MAPPER.readValue(source, JacksonMapper.MAP_TYPE_REFERENCE);
        namespace = namespace == null ? (String)mapFlow.get("namespace") : namespace;
        revision = revision == null ? (Integer)mapFlow.get("revision") : revision;
        mapFlow = this.innerInjectDefault(tenant, namespace, mapFlow, onlyVersions);
        FlowWithSource withDefault = YamlParser.parse(mapFlow, FlowWithSource.class, strictParsing);
        Flow full = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)withDefault.toBuilder().tenantId(tenant)).revision(revision)).deleted(isDeleted)).source(source)).build();
        if (this.templatesEnabled && tenant != null) {
            full.allTasksWithChilds().stream().filter(task -> task instanceof Template).forEach(task -> ((Template)task).setTenantId(tenant));
        }
        return full;
    }

    private Map<String, Object> innerInjectDefault(String tenantId, String namespace, Map<String, Object> flowAsMap, boolean onlyVersions) {
        List allDefaults = this.getAllDefaults(tenantId, namespace, flowAsMap);
        if (onlyVersions) {
            allDefaults = allDefaults.stream().map(defaults -> {
                Map<String, Object> filtered = defaults.getValues().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("version")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return filtered.isEmpty() ? null : defaults.toBuilder().values(filtered).build();
            }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        }
        if (allDefaults.isEmpty()) {
            return flowAsMap;
        }
        this.addAliases(allDefaults);
        Map allDefaultsGroup = allDefaults.stream().collect(Collectors.groupingBy(PluginDefault::isForced, Collectors.toList()));
        Map<String, List<PluginDefault>> defaults2 = this.pluginDefaultsToMap(allDefaultsGroup.getOrDefault(false, Collections.emptyList()));
        Map<String, List<PluginDefault>> forced = this.pluginDefaultsToMap(Lists.reverse(allDefaultsGroup.getOrDefault(true, Collections.emptyList())));
        Object pluginDefaults = flowAsMap.get(PLUGIN_DEFAULTS_FIELD);
        if (pluginDefaults != null) {
            flowAsMap.remove(PLUGIN_DEFAULTS_FIELD);
        }
        if (!defaults2.isEmpty()) {
            flowAsMap = (Map)this.recursiveDefaults(flowAsMap, defaults2);
        }
        if (!forced.isEmpty()) {
            flowAsMap = (Map)this.recursiveDefaults(flowAsMap, forced);
        }
        if (pluginDefaults != null) {
            flowAsMap.put(PLUGIN_DEFAULTS_FIELD, pluginDefaults);
        }
        return flowAsMap;
    }

    public List<String> validateDefault(PluginDefault pluginDefault) {
        Class<? extends Plugin> classByIdentifier = this.getClassByIdentifier(pluginDefault);
        if (classByIdentifier == null) {
            return Collections.emptyList();
        }
        Set<String> pluginDefaultProperties = pluginDefault.getValues().keySet();
        List<String> pluginProperties = Stream.of(classByIdentifier.getMethods()).filter(method -> method.getName().startsWith("get") || method.getName().startsWith("is")).map(method -> {
            if (method.getName().startsWith("get")) {
                return method.getName().substring(3).toLowerCase();
            }
            return method.getName().substring(2).toLowerCase();
        }).toList();
        return pluginDefaultProperties.stream().filter(property -> !pluginProperties.contains(property.toLowerCase())).map(property -> "No property '" + property + "' exists in plugin '" + pluginDefault.getType() + "'").toList();
    }

    protected Class<? extends Plugin> getClassByIdentifier(PluginDefault pluginDefault) {
        return this.pluginRegistry.findClassByIdentifier(pluginDefault.getType());
    }

    private Map<String, List<PluginDefault>> pluginDefaultsToMap(List<PluginDefault> pluginDefaults) {
        return pluginDefaults.stream().collect(Collectors.groupingBy(PluginDefault::getType));
    }

    private void addAliases(List<PluginDefault> allDefaults) {
        List<PluginDefault> aliasedPluginDefault = allDefaults.stream().map(pluginDefault -> {
            Class<? extends Plugin> classByIdentifier = this.getClassByIdentifier((PluginDefault)pluginDefault);
            return classByIdentifier != null && !pluginDefault.getType().equals(classByIdentifier.getTypeName()) ? pluginDefault.toBuilder().type(classByIdentifier.getTypeName()).build() : null;
        }).filter(Objects::nonNull).toList();
        allDefaults.addAll(aliasedPluginDefault);
    }

    @VisibleForTesting
    Object recursiveDefaults(Object object, Map<String, List<PluginDefault>> defaults) {
        if (object instanceof Map) {
            Map<?, ?> value = (Map<?, ?>)object;
            if ((value = (Map)value.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), this.recursiveDefaults(e.getValue(), defaults))).collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll)).containsKey("type")) {
                value = this.defaults(value, defaults);
            }
            return value;
        }
        if (object instanceof Collection) {
            Collection value = (Collection)object;
            return value.stream().map(r -> this.recursiveDefaults(r, defaults)).toList();
        }
        return object;
    }

    private Map<?, ?> defaults(Map<?, ?> plugin, Map<String, List<PluginDefault>> defaults) {
        Object type = plugin.get("type");
        if (!(type instanceof String)) {
            return plugin;
        }
        String pluginType = (String)type;
        List matching = defaults.entrySet().stream().filter(e -> ((String)e.getKey()).equals(pluginType) || pluginType.startsWith((String)e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).toList();
        if (matching.isEmpty()) {
            return plugin;
        }
        Map<String, Object> result = plugin;
        for (PluginDefault pluginDefault : matching) {
            if (pluginDefault.isForced()) {
                result = MapUtils.deepMerge(result, pluginDefault.getValues());
                continue;
            }
            result = MapUtils.deepMerge(pluginDefault.getValues(), result);
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="0.20")
    public Flow injectDefaults(Flow flow, Logger logger) {
        try {
            return this.injectDefaults(flow);
        }
        catch (Exception e) {
            logger.warn("Can't inject plugin defaults on tenant {}, namespace '{}', flow '{}' with errors '{}'", new Object[]{flow.getTenantId(), flow.getNamespace(), flow.getId(), e.getMessage(), e});
            return flow;
        }
    }

    @Deprecated(forRemoval=true, since="0.20")
    public Flow injectDefaults(Flow flow) throws ConstraintViolationException {
        if (flow instanceof FlowWithSource) {
            FlowWithSource flowWithSource = (FlowWithSource)flow;
            try {
                return this.injectAllDefaults((FlowInterface)flowWithSource, false);
            }
            catch (FlowProcessingException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof ConstraintViolationException) {
                    ConstraintViolationException cve = (ConstraintViolationException)throwable;
                    throw cve;
                }
                throw new KestraRuntimeException(e);
            }
        }
        Map<String, Object> mapFlow = (Map<String, Object>)NON_DEFAULT_OBJECT_MAPPER.convertValue((Object)flow, JacksonMapper.MAP_TYPE_REFERENCE);
        mapFlow = this.innerInjectDefault(flow.getTenantId(), flow.getNamespace(), mapFlow, false);
        return YamlParser.parse(mapFlow, Flow.class, false);
    }
}

