/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.services.FlowService;
import io.kestra.core.storages.InternalNamespace;
import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.Storage;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalStorage
implements Storage {
    private static final Logger LOG = LoggerFactory.getLogger(InternalStorage.class);
    private static final String PATH_SEPARATOR = "/";
    private final Logger logger;
    private final StorageContext context;
    private final StorageInterface storage;
    private final FlowService flowService;

    public InternalStorage(StorageContext context, StorageInterface storage) {
        this(LOG, context, storage, null);
    }

    public InternalStorage(Logger logger, StorageContext context, StorageInterface storage, FlowService flowService) {
        this.logger = logger;
        this.context = context;
        this.storage = storage;
        this.flowService = flowService;
    }

    @Override
    public Namespace namespace() {
        return new InternalNamespace(this.logger, this.context.getTenantId(), this.context.getNamespace(), this.storage);
    }

    @Override
    public Namespace namespace(String namespace) {
        boolean isExternalNamespace;
        boolean bl = isExternalNamespace = !namespace.equals(this.context.getNamespace());
        if (isExternalNamespace && this.flowService != null) {
            this.flowService.checkAllowedNamespace(this.context.getTenantId(), namespace, this.context.getTenantId(), this.context.getNamespace());
        }
        return new InternalNamespace(this.logger, this.context.getTenantId(), namespace, this.storage);
    }

    @Override
    public boolean isFileExist(URI uri) {
        return this.storage.exists(this.context.getTenantId(), this.context.getNamespace(), uri);
    }

    @Override
    public InputStream getFile(URI uri) throws IOException {
        InternalStorage.uriGuard(uri);
        return this.storage.get(this.context.getTenantId(), this.context.getNamespace(), uri);
    }

    @Override
    public boolean deleteFile(URI uri) throws IOException {
        InternalStorage.uriGuard(uri);
        return this.storage.delete(this.context.getTenantId(), this.context.getNamespace(), uri);
    }

    private static void uriGuard(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Invalid internal storage uri, got null");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Invalid internal storage uri, got uri '" + String.valueOf(uri) + "'");
        }
        if (!scheme.equals("kestra")) {
            throw new IllegalArgumentException("Invalid internal storage scheme, got uri '" + String.valueOf(uri) + "'");
        }
    }

    @Override
    public List<URI> deleteExecutionFiles() throws IOException {
        return this.storage.deleteByPrefix(this.context.getTenantId(), this.context.getNamespace(), this.context.getExecutionStorageURI());
    }

    @Override
    public URI getContextBaseURI() {
        return this.context.getContextStorageURI();
    }

    @Override
    public URI putFile(InputStream inputStream, String name) throws IOException {
        URI uri = this.context.getContextStorageURI();
        URI resolved = uri.resolve(uri.getPath() + PATH_SEPARATOR + name);
        return this.storage.put(this.context.getTenantId(), this.context.getNamespace(), resolved, new BufferedInputStream(inputStream));
    }

    @Override
    public URI putFile(InputStream inputStream, URI uri) throws IOException {
        return this.storage.put(this.context.getTenantId(), this.context.getNamespace(), uri, new BufferedInputStream(inputStream));
    }

    @Override
    public URI putFile(File file) throws IOException {
        return this.putFile(file, null);
    }

    @Override
    public URI putFile(File file, String name) throws IOException {
        URI uri = this.context.getContextStorageURI();
        URI resolved = uri.resolve(uri.getPath() + PATH_SEPARATOR + (name != null ? name : file.getName()));
        try {
            URI uRI;
            try (FileInputStream is = new FileInputStream(file);){
                uRI = this.putFile((InputStream)is, resolved);
            }
            return uRI;
        }
        finally {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete temporary file '{}'", (Object)file.toPath(), (Object)e);
            }
        }
    }

    @Override
    public Optional<InputStream> getCacheFile(String cacheId, @Nullable String objectId, @Nullable Duration ttl) throws IOException {
        Optional<Long> maybeLastModifiedTime;
        if (ttl != null && (maybeLastModifiedTime = this.getCacheFileLastModifiedTime(cacheId, objectId)).isPresent() && Instant.now().isAfter(Instant.ofEpochMilli(maybeLastModifiedTime.get()).plus(ttl))) {
            this.logger.debug("Cache is expired for cache-id={}, object-id={}, and ttl={}, deleting it", new Object[]{cacheId, objectId, ttl.toMillis()});
            this.deleteCacheFile(cacheId, objectId);
            return Optional.empty();
        }
        URI uri = this.context.getCacheURI(cacheId, objectId);
        return this.isFileExist(uri) ? Optional.of(this.storage.get(this.context.getTenantId(), this.context.getNamespace(), uri)) : Optional.empty();
    }

    private Optional<Long> getCacheFileLastModifiedTime(String cacheId, @Nullable String objectId) throws IOException {
        URI uri = this.context.getCacheURI(cacheId, objectId);
        return this.isFileExist(uri) ? Optional.of(this.storage.getAttributes(this.context.getTenantId(), this.context.getNamespace(), uri).getLastModifiedTime()) : Optional.empty();
    }

    @Override
    public URI putCacheFile(File file, String cacheId, @Nullable String objectId) throws IOException {
        URI uri = this.context.getCacheURI(cacheId, objectId);
        return this.putFileAndDelete(file, uri);
    }

    @Override
    public Optional<Boolean> deleteCacheFile(String cacheId, @Nullable String objectId) throws IOException {
        URI uri = this.context.getCacheURI(cacheId, objectId);
        return this.isFileExist(uri) ? Optional.of(this.storage.delete(this.context.getTenantId(), this.context.getNamespace(), uri)) : Optional.empty();
    }

    private URI putFileAndDelete(File file, URI uri) throws IOException {
        try {
            URI uRI;
            try (FileInputStream is = new FileInputStream(file);){
                uRI = this.putFile((InputStream)is, uri);
            }
            return uRI;
        }
        finally {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete temporary file '{}'", (Object)file.toPath(), (Object)e);
            }
        }
    }

    private URI putFileAndDelete(File file, String prefix, String name) throws IOException {
        URI uri = URI.create(prefix);
        URI resolve = uri.resolve(uri.getPath() + PATH_SEPARATOR + (name != null ? name : file.getName()));
        return this.putFileAndDelete(file, resolve);
    }

    private URI putFile(InputStream inputStream, String prefix, String name) throws IOException {
        URI uri = URI.create(prefix);
        URI resolve = uri.resolve(uri.getPath() + PATH_SEPARATOR + name);
        return this.storage.put(this.context.getTenantId(), this.context.getNamespace(), resolve, new BufferedInputStream(inputStream));
    }

    @Override
    public Optional<StorageContext.Task> getTaskStorageContext() {
        StorageContext.Task task;
        StorageContext storageContext = this.context;
        return Optional.ofNullable(storageContext instanceof StorageContext.Task ? (task = (StorageContext.Task)storageContext) : null);
    }
}

