/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.storages.NamespaceFile;
import io.kestra.core.utils.PathMatcherPredicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;

public interface Namespace {
    public static final String NAMESPACE_FILE_SCHEME = "nsfile";

    public String namespace();

    public String tenantId();

    public List<NamespaceFile> all() throws IOException;

    public List<NamespaceFile> all(boolean var1) throws IOException;

    public List<NamespaceFile> all(String var1, boolean var2) throws IOException;

    public NamespaceFile get(Path var1);

    public List<NamespaceFile> findAllFilesMatching(Predicate<Path> var1) throws IOException;

    default public List<NamespaceFile> findAllFilesMatching(List<String> includes, List<String> excludes) throws IOException {
        Predicate<Path> predicate = PathMatcherPredicate.builder().includes(includes).excludes(excludes).build();
        return this.findAllFilesMatching(predicate);
    }

    public InputStream getFileContent(Path var1) throws IOException;

    default public NamespaceFile putFile(Path path, InputStream content) throws IOException, URISyntaxException {
        return this.putFile(path, content, Conflicts.OVERWRITE);
    }

    public NamespaceFile putFile(Path var1, InputStream var2, Conflicts var3) throws IOException, URISyntaxException;

    default public NamespaceFile putFile(NamespaceFile file, InputStream content) throws IOException, URISyntaxException {
        return this.putFile(file, content, Conflicts.OVERWRITE);
    }

    default public NamespaceFile putFile(NamespaceFile file, InputStream content, Conflicts onAlreadyExist) throws IOException, URISyntaxException {
        return this.putFile(Path.of(file.path(), new String[0]), content, onAlreadyExist);
    }

    public URI createDirectory(Path var1) throws IOException;

    default public boolean delete(NamespaceFile file) throws IOException {
        return this.delete(Path.of(file.path(), new String[0]));
    }

    default public boolean deleteDirectory(NamespaceFile file) throws IOException {
        return this.delete(Path.of(file.path(), new String[0]));
    }

    public boolean delete(Path var1) throws IOException;

    default public boolean isDirectoryEmpty(String path) throws IOException {
        List<NamespaceFile> files = this.findAllFilesMatching(List.of(path + "/**"), List.of());
        return files.isEmpty();
    }

    public static enum Conflicts {
        OVERWRITE,
        ERROR,
        SKIP;

    }
}

