/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.storages.StorageContext;
import io.kestra.core.utils.WindowsUtils;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;

public record NamespaceFile(String path, URI uri, String namespace) {
    public NamespaceFile(Path path, URI uri, String namespace) {
        this(path.toString(), uri, namespace);
    }

    public static NamespaceFile of(String namespace) {
        return NamespaceFile.of(namespace, (Path)null);
    }

    public static NamespaceFile of(String namespace, @Nullable URI uri) {
        NamespaceFile namespaceFile;
        if (uri == null || uri.equals(URI.create("/"))) {
            return NamespaceFile.of(namespace, (Path)null);
        }
        Path path = Path.of(WindowsUtils.windowsToUnixPath(uri.getPath()), new String[0]);
        if (uri.getScheme() != null) {
            if (!uri.getScheme().equalsIgnoreCase("kestra")) {
                throw new IllegalArgumentException(String.format("Invalid Kestra URI scheme. Expected 'kestra', but was '%s'.", uri));
            }
            if (!uri.getPath().startsWith(StorageContext.namespaceFilePrefix(namespace))) {
                throw new IllegalArgumentException(String.format("Invalid Kestra URI. Expected prefix for namespace '%s', but was %s.", namespace, uri));
            }
            namespaceFile = NamespaceFile.of(namespace, Path.of(StorageContext.namespaceFilePrefix(namespace), new String[0]).relativize(path));
        } else {
            namespaceFile = NamespaceFile.of(namespace, path);
        }
        boolean trailingSlash = uri.toString().endsWith("/");
        if (!trailingSlash) {
            return namespaceFile;
        }
        return new NamespaceFile(namespaceFile.path, URI.create(namespaceFile.uri.toString() + "/"), namespaceFile.namespace);
    }

    public static NamespaceFile of(String namespace, @Nullable Path path) {
        Objects.requireNonNull(namespace, "namespace cannot be null");
        if (path == null || path.equals(Path.of("/", new String[0]))) {
            return new NamespaceFile("", URI.create("kestra://" + StorageContext.namespaceFilePrefix(namespace) + "/"), namespace);
        }
        Path namespacePrefixPath = Path.of(StorageContext.namespaceFilePrefix(namespace), new String[0]);
        Path filePath = path.normalize();
        if (filePath.isAbsolute()) {
            filePath = filePath.getRoot().relativize(filePath);
        }
        String pathWithoutTrailingSlash = path.toString().replaceFirst("^[.]*[\\\\|/]+", "");
        return new NamespaceFile(pathWithoutTrailingSlash, URI.create("kestra://" + namespacePrefixPath.resolve(pathWithoutTrailingSlash).toString().replace("\\", "/")), namespace);
    }

    public Path path(boolean withLeadingSlash) {
        String strPath = this.path.toString();
        if (!withLeadingSlash) {
            if (strPath.startsWith("/")) {
                return Path.of(strPath.substring(1), new String[0]);
            }
        } else if (!strPath.startsWith("/")) {
            return Path.of("/", new String[0]).resolve(this.path);
        }
        return Path.of(this.path, new String[0]);
    }

    public Path storagePath() {
        return Path.of(this.uri().getPath(), new String[0]);
    }

    public boolean isDirectory() {
        return this.uri.toString().endsWith("/");
    }

    public boolean isRootDirectory() {
        return this.equals(NamespaceFile.of(this.namespace));
    }
}

