/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages.kv;

import io.kestra.core.storages.StorageObject;
import io.kestra.core.storages.kv.KVMetadata;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

public record KVValueAndMetadata(@Nullable KVMetadata metadata, @Nullable Object value) {
    public Map<String, String> metadataAsMap() {
        return Optional.ofNullable(this.metadata).map(KVMetadata::toMap).orElse(null);
    }

    static KVValueAndMetadata from(StorageObject storageObject) throws IOException {
        try (InputStream is = storageObject.inputStream();){
            String ionString = new String(is.readAllBytes());
            KVValueAndMetadata kVValueAndMetadata = new KVValueAndMetadata(new KVMetadata(storageObject.metadata()), ionString);
            return kVValueAndMetadata;
        }
    }
}

