/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.test;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.HasSource;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.test.flow.UnitTest;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.validations.TestSuiteValidation;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

@Introspected
@TestSuiteValidation
public class TestSuite
implements HasUID,
TenantInterface,
DeletedInterface,
HasSource {
    @NotNull
    @NotBlank
    @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9_-]*")
    private @NotNull @NotBlank @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9_-]*") String id;
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    private String description;
    @NotNull
    @Pattern(regexp="^[a-z0-9][a-z0-9._-]*")
    @Size(min=1, max=150)
    private @NotNull @Pattern(regexp="^[a-z0-9][a-z0-9._-]*") @Size(min=1, max=150) String namespace;
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9._-]*")
    @Size(min=1, max=100)
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9._-]*") @Size(min=1, max=100) String flowId;
    private String source;
    @NotNull
    @NotEmpty
    @Valid
    private List<UnitTest> testCases;
    private boolean deleted;
    private boolean disabled;

    @Override
    @JsonIgnore
    public String uid() {
        return IdUtils.fromParts(this.tenantId, this.namespace, this.id);
    }

    public TestSuite update(String newSource, TestSuite newTestSuite) {
        return new TestSuite(newTestSuite.getId(), this.tenantId, newTestSuite.getDescription(), newTestSuite.getNamespace(), newTestSuite.getFlowId(), newSource, newTestSuite.getTestCases(), newTestSuite.isDeleted(), newTestSuite.isDisabled());
    }

    public TestSuite delete() {
        return ((TestSuiteBuilder)this.toBuilder().deleted(true)).build();
    }

    public TestSuite disable() {
        boolean disabled = true;
        return ((TestSuiteBuilder)((TestSuiteBuilder)this.toBuilder().disabled(disabled)).source(TestSuite.toggleDisabledInYamlSource(this.source, disabled))).build();
    }

    public TestSuite enable() {
        boolean disabled = false;
        return ((TestSuiteBuilder)((TestSuiteBuilder)this.toBuilder().disabled(disabled)).source(TestSuite.toggleDisabledInYamlSource(this.source, disabled))).build();
    }

    @Override
    public String source() {
        return this.getSource();
    }

    protected static String toggleDisabledInYamlSource(String yamlSource, boolean disabled) {
        String regex = disabled ? "^disabled\\s*:\\s*false\\s*" : "^disabled\\s*:\\s*true\\s*";
        java.util.regex.Pattern p = java.util.regex.Pattern.compile(regex, 8);
        if (p.matcher(yamlSource).find()) {
            return p.matcher(yamlSource).replaceAll(String.format("disabled: %s\n", disabled));
        }
        return yamlSource + String.format("\ndisabled: %s", disabled);
    }

    @Generated
    private static boolean $default$deleted() {
        return Boolean.FALSE;
    }

    @Generated
    private static boolean $default$disabled() {
        return Boolean.FALSE;
    }

    @Generated
    protected TestSuite(TestSuiteBuilder<?, ?> b) {
        this.id = b.id;
        this.tenantId = b.tenantId;
        this.description = b.description;
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.source = b.source;
        this.testCases = b.testCases;
        this.deleted = b.deleted$set ? b.deleted$value : TestSuite.$default$deleted();
        this.disabled = b.disabled$set ? b.disabled$value : TestSuite.$default$disabled();
    }

    @Generated
    public static TestSuiteBuilder<?, ?> builder() {
        return new TestSuiteBuilderImpl();
    }

    @Generated
    public TestSuiteBuilder<?, ?> toBuilder() {
        return new TestSuiteBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<UnitTest> getTestCases() {
        return this.testCases;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public TestSuite() {
        this.deleted = TestSuite.$default$deleted();
        this.disabled = TestSuite.$default$disabled();
    }

    @ConstructorProperties(value={"id", "tenantId", "description", "namespace", "flowId", "source", "testCases", "deleted", "disabled"})
    @Generated
    public TestSuite(String id, String tenantId, String description, String namespace, String flowId, String source, List<UnitTest> testCases, boolean deleted, boolean disabled) {
        this.id = id;
        this.tenantId = tenantId;
        this.description = description;
        this.namespace = namespace;
        this.flowId = flowId;
        this.source = source;
        this.testCases = testCases;
        this.deleted = deleted;
        this.disabled = disabled;
    }

    @Generated
    public String toString() {
        return "TestSuite(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", description=" + this.getDescription() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", source=" + this.getSource() + ", testCases=" + String.valueOf(this.getTestCases()) + ", deleted=" + this.isDeleted() + ", disabled=" + this.isDisabled() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestSuite)) {
            return false;
        }
        TestSuite other = (TestSuite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<UnitTest> this$testCases = this.getTestCases();
        List<UnitTest> other$testCases = other.getTestCases();
        return !(this$testCases == null ? other$testCases != null : !((Object)this$testCases).equals(other$testCases));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestSuite;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<UnitTest> $testCases = this.getTestCases();
        result = result * 59 + ($testCases == null ? 43 : ((Object)$testCases).hashCode());
        return result;
    }

    @Generated
    public static abstract class TestSuiteBuilder<C extends TestSuite, B extends TestSuiteBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String tenantId;
        @Generated
        private String description;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String source;
        @Generated
        private List<UnitTest> testCases;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;
        @Generated
        private boolean disabled$set;
        @Generated
        private boolean disabled$value;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TestSuiteBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TestSuite instance, TestSuiteBuilder<?, ?> b) {
            b.id(instance.id);
            b.tenantId(instance.tenantId);
            b.description(instance.description);
            b.namespace(instance.namespace);
            b.flowId(instance.flowId);
            b.source(instance.source);
            b.testCases(instance.testCases);
            b.deleted(instance.deleted);
            b.disabled(instance.disabled);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return this.self();
        }

        @Generated
        public B source(String source) {
            this.source = source;
            return this.self();
        }

        @Generated
        public B testCases(List<UnitTest> testCases) {
            this.testCases = testCases;
            return this.self();
        }

        @Generated
        public B deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this.self();
        }

        @Generated
        public B disabled(boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TestSuite.TestSuiteBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", description=" + this.description + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", source=" + this.source + ", testCases=" + String.valueOf(this.testCases) + ", deleted$value=" + this.deleted$value + ", disabled$value=" + this.disabled$value + ")";
        }
    }

    @Generated
    private static final class TestSuiteBuilderImpl
    extends TestSuiteBuilder<TestSuite, TestSuiteBuilderImpl> {
        @Generated
        private TestSuiteBuilderImpl() {
        }

        @Override
        @Generated
        protected TestSuiteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TestSuite build() {
            return new TestSuite(this);
        }
    }
}

