/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.trace;

import io.kestra.core.trace.DefaultTracer;
import io.kestra.core.trace.NoopTracer;
import io.kestra.core.trace.TraceLevel;
import io.kestra.core.trace.TraceUtils;
import io.kestra.core.trace.Tracer;
import io.kestra.core.trace.TracesConfiguration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class TracerFactory {
    @Inject
    private Optional<OpenTelemetry> openTelemetry;
    @Inject
    private Optional<io.opentelemetry.api.trace.Tracer> tracer;
    @Inject
    private TracesConfiguration tracesConfiguration;

    public Tracer getTracer(Class<?> clazz, String spanNamePrefix) {
        TraceLevel level = this.levelFromConfiguration(clazz.getName());
        Attributes attributes = TraceUtils.attributesFrom(clazz);
        return level == TraceLevel.DISABLED || this.openTelemetry.isEmpty() || this.tracer.isEmpty() ? new NoopTracer() : new DefaultTracer(this.openTelemetry.get(), this.tracer.get(), spanNamePrefix, level, attributes);
    }

    private TraceLevel levelFromConfiguration(String name) {
        if (name == null) {
            return this.tracesConfiguration.root();
        }
        if (this.tracesConfiguration.categories().containsKey(name)) {
            return this.tracesConfiguration.categories().get(name);
        }
        if (name.contains(".")) {
            return this.levelFromConfiguration(name.substring(0, name.lastIndexOf(46)));
        }
        return this.tracesConfiguration.root();
    }
}

