/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract sealed class Either<L, R> {
    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract L getLeft();

    public abstract R getRight();

    public LeftProjection<L, R> left() {
        return new LeftProjection(this);
    }

    public RightProjection<L, R> right() {
        return new RightProjection(this);
    }

    public <T> T fold(Function<L, T> fl, Function<R, T> fr) {
        return this.isLeft() ? fl.apply(this.getLeft()) : fr.apply(this.getRight());
    }

    public static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("This is Left");
        }
    }

    public static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("This is Right");
        }

        @Override
        public R getRight() {
            return this.value;
        }
    }

    public static class LeftProjection<L, R> {
        private final Either<L, R> either;

        LeftProjection(Either<L, R> either) {
            Objects.requireNonNull(either, "either can't be null");
            this.either = either;
        }

        public boolean exists() {
            return this.either.isLeft();
        }

        public L get() {
            return this.either.getLeft();
        }

        public <LL> Either<LL, R> map(Function<? super L, ? extends LL> fn) {
            if (this.either.isLeft()) {
                return Either.left(fn.apply(this.either.getLeft()));
            }
            return Either.right(this.either.getRight());
        }

        public <LL> Either<LL, R> flatMap(Function<? super L, Either<LL, R>> fn) {
            if (this.either.isLeft()) {
                return fn.apply(this.either.getLeft());
            }
            return Either.right(this.either.getRight());
        }

        public Optional<L> toOptional() {
            return this.exists() ? Optional.of(this.either.getLeft()) : Optional.empty();
        }
    }

    public static class RightProjection<L, R> {
        private final Either<L, R> either;

        RightProjection(Either<L, R> either) {
            Objects.requireNonNull(either, "either can't be null");
            this.either = either;
        }

        public boolean exists() {
            return this.either.isRight();
        }

        public R get() {
            return this.either.getRight();
        }

        public <RR> Either<L, RR> map(Function<? super R, ? extends RR> fn) {
            if (this.either.isRight()) {
                return Either.right(fn.apply(this.either.getRight()));
            }
            return Either.left(this.either.getLeft());
        }

        public <RR> Either<L, RR> flatMap(Function<? super R, Either<L, RR>> fn) {
            if (this.either.isRight()) {
                return fn.apply(this.either.getRight());
            }
            return Either.left(this.either.getLeft());
        }

        public Optional<R> toOptional() {
            return this.exists() ? Optional.of(this.either.getRight()) : Optional.empty();
        }
    }
}

