/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

public interface Exceptions {
    public static String getStacktraceAsString(Throwable throwable) {
        return Exceptions.getStacktraceAsString(throwable, Integer.MAX_VALUE);
    }

    public static String getStacktraceAsString(Throwable throwable, int maxLines) {
        StringBuilder limitedStackTrace = new StringBuilder();
        limitedStackTrace.append(throwable).append(System.lineSeparator());
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        for (int i = 0; i < Math.min(maxLines, stackTraceElements.length); ++i) {
            limitedStackTrace.append("\tat ").append(stackTraceElements[i]).append(System.lineSeparator());
        }
        return limitedStackTrace.toString();
    }

    public static void throwIfFatal(Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof VirtualMachineError) {
            VirtualMachineError error = (VirtualMachineError)t;
            throw error;
        }
    }
}

