/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.models.Setting;
import io.kestra.core.repositories.SettingRepositoryInterface;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.util.StringUtils;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

@Singleton
public class VersionProvider {
    private String version = "Snapshot";
    private String revision;
    private ZonedDateTime date;
    @Inject
    private Environment environment;
    @Inject
    private Optional<SettingRepositoryInterface> settingRepository;

    @PostConstruct
    public void start() {
        Optional gitProperties = new PropertiesPropertySourceLoader().load("classpath:git", (ResourceLoader)this.environment);
        Optional buildProperties = new PropertiesPropertySourceLoader().load("classpath:gradle", (ResourceLoader)this.environment);
        this.revision = this.loadRevision(gitProperties);
        this.date = this.loadTime(gitProperties);
        this.version = this.loadVersion(buildProperties, gitProperties);
        this.settingRepository.ifPresent(settingRepositoryInterface -> VersionProvider.persistVersion(settingRepositoryInterface, this.version));
    }

    private static synchronized void persistVersion(SettingRepositoryInterface settingRepositoryInterface, String version) {
        Optional<Setting> versionSetting = settingRepositoryInterface.findByKey("instance.version");
        if (versionSetting.isEmpty() || !versionSetting.get().getValue().equals(version)) {
            settingRepositoryInterface.save((Setting)((Setting.SettingBuilder)((Setting.SettingBuilder)Setting.builder().key("instance.version")).value(version)).build());
        }
    }

    private String loadVersion(Optional<PropertySource> buildProperties, Optional<PropertySource> gitProperties) {
        return Stream.concat(buildProperties.stream().flatMap(properties -> Stream.of(properties.get("version"))), gitProperties.stream().flatMap(properties -> Stream.of(properties.get("git.tags"), properties.get("git.branch")))).map(this::getVersion).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(this.version);
    }

    private String loadRevision(Optional<PropertySource> gitProperties) {
        return gitProperties.stream().flatMap(properties -> Stream.of(properties.get("git.commit.id.abbrev"), properties.get("git.commit.id"))).findFirst().map(Object::toString).orElse(null);
    }

    private ZonedDateTime loadTime(Optional<PropertySource> gitProperties) {
        return gitProperties.stream().flatMap(properties -> Stream.of(properties.get("git.commit.time"))).findFirst().map(Object::toString).map(s -> {
            try {
                return ZonedDateTime.parse(s, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXXX"));
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(null);
    }

    private Optional<String> getVersion(Object object) {
        String candidate = Objects.toString(object, null);
        return StringUtils.isNotEmpty((CharSequence)candidate) ? Optional.of(candidate) : Optional.empty();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getRevision() {
        return this.revision;
    }

    @Generated
    public ZonedDateTime getDate() {
        return this.date;
    }
}

