/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.env.Environment;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
public class AppConfigValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppConfigValidator.class);
    private static final String KESTRA_URL_KEY = "kestra.url";
    private final Environment environment;

    @Inject
    public AppConfigValidator(Environment environment) {
        this.environment = environment;
    }

    @PostConstruct
    void validate() {
        List<Boolean> validationResults = List.of(Boolean.valueOf(this.isKestraUrlValid()));
        if (validationResults.contains(false)) {
            throw new AppConfigException("Invalid configuration");
        }
    }

    private boolean isKestraUrlValid() {
        URL url;
        if (!this.environment.containsProperty(KESTRA_URL_KEY)) {
            return true;
        }
        String rawUrl = (String)this.environment.getProperty(KESTRA_URL_KEY, String.class).orElseThrow();
        try {
            url = URI.create(rawUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            log.error("Value of the '{}' configuration property must be a valid URL - e.g. https://your.company.com", (Object)KESTRA_URL_KEY);
            return false;
        }
        if (!List.of("http", "https").contains(url.getProtocol())) {
            log.error("Value of the '{}' configuration property must contain either HTTP or HTTPS scheme - e.g. https://your.company.com", (Object)KESTRA_URL_KEY);
            return false;
        }
        return true;
    }

    public static class AppConfigException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AppConfigException(String errorMessage) {
            super(errorMessage);
        }
    }
}

