/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.validations.ExecutionsDataFilterValidation;
import io.kestra.plugin.core.dashboard.data.ExecutionsKPI;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;

@Singleton
@Introspected
public class ExecutionsDataFilterKPIValidator
implements ConstraintValidator<ExecutionsDataFilterValidation, ExecutionsKPI<?>> {
    public boolean isValid(@Nullable ExecutionsKPI<?> executionsDataFilter, @NonNull AnnotationValue<ExecutionsDataFilterValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (executionsDataFilter == null) {
            return true;
        }
        ArrayList<String> violations = new ArrayList<String>();
        if (((ColumnDescriptor)executionsDataFilter.getColumns()).getField() == IExecutions.Fields.LABELS && ((ColumnDescriptor)executionsDataFilter.getColumns()).getLabelKey() == null) {
            violations.add("Column must have a `labelKey`.");
        }
        executionsDataFilter.getNumerator().forEach(filter -> {
            if (filter.getField() == IExecutions.Fields.LABELS && filter.getLabelKey() == null) {
                violations.add("Label filters must have a `labelKey`.");
            }
        });
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid Chart: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

