/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Map;
import lombok.Generated;

@Schema(title="Condition to allow events between two specific datetime values.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow only after the specific date.", full=true, code={"id: schedule_condition_datetimebetween\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute once every 5 minutes after the date 2025-12-31T23:59:59Z\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"*/5 * * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.DateTimeBetween\n        date: \"{{ trigger.date }}\"\n        after: \"2025-12-31T23:59:59Z\"\n"}), @Example(title="Trigger condition to execute the flow between two specific dates.", full=true, code={"id: schedule_condition_datetimebetween\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will be executed once every 5 minutes between the before and after dates\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"*/5 * * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.DateTimeBetween\n        date: \"{{ trigger.date }}\"\n        after: \"2025-01-01T00:00:00Z\"\n        before: \"2025-12-31T23:59:59Z\"\n"})}, aliases={"io.kestra.core.models.conditions.types.DateTimeBetweenCondition", "io.kestra.plugin.core.condition.DateTimeBetweenCondition"})
public class DateTimeBetween
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test.", description="Can be any variable or any valid ISO 8601 datetime. By default, it will use the trigger date.")
    @PluginProperty(dynamic=true)
    private final String date;
    @Schema(title="The date to test must be after this one.", description="Must be a valid ISO 8601 datetime with the zone identifier (use 'Z' for the default zone identifier).")
    private Property<ZonedDateTime> after;
    @Schema(title="The date to test must be before this one.", description="Must be a valid ISO 8601 datetime with the zone identifier (use 'Z' for the default zone identifier).")
    private Property<ZonedDateTime> before;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        Map<String, Object> vars = conditionContext.getVariables();
        String render = conditionContext.getRunContext().render(this.date, vars);
        ZonedDateTime currentDate = DateUtils.parseZonedDateTime(render);
        ZonedDateTime afterRendered = conditionContext.getRunContext().render(this.after).as(ZonedDateTime.class, vars).orElse(null);
        ZonedDateTime beforeRendered = conditionContext.getRunContext().render(this.before).as(ZonedDateTime.class, vars).orElse(null);
        if (beforeRendered != null && afterRendered != null) {
            return currentDate.isAfter(afterRendered) && currentDate.isBefore(beforeRendered);
        }
        if (beforeRendered != null) {
            return currentDate.isBefore(beforeRendered);
        }
        if (afterRendered != null) {
            return currentDate.isAfter(afterRendered);
        }
        throw new IllegalConditionEvaluation("Invalid condition with no before nor after");
    }

    @Generated
    private static String $default$date() {
        return "{{ trigger.date }}";
    }

    @Generated
    protected DateTimeBetween(DateTimeBetweenBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : DateTimeBetween.$default$date();
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static DateTimeBetweenBuilder<?, ?> builder() {
        return new DateTimeBetweenBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DateTimeBetween(super=" + super.toString() + ", date=" + this.getDate() + ", after=" + String.valueOf(this.getAfter()) + ", before=" + String.valueOf(this.getBefore()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTimeBetween)) {
            return false;
        }
        DateTimeBetween other = (DateTimeBetween)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        Property<ZonedDateTime> this$after = this.getAfter();
        Property<ZonedDateTime> other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        Property<ZonedDateTime> this$before = this.getBefore();
        Property<ZonedDateTime> other$before = other.getBefore();
        return !(this$before == null ? other$before != null : !((Object)this$before).equals(other$before));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DateTimeBetween;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        Property<ZonedDateTime> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        Property<ZonedDateTime> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        return result;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public Property<ZonedDateTime> getAfter() {
        return this.after;
    }

    @Generated
    public Property<ZonedDateTime> getBefore() {
        return this.before;
    }

    @Generated
    public DateTimeBetween() {
        this.date = DateTimeBetween.$default$date();
    }

    @Generated
    public static abstract class DateTimeBetweenBuilder<C extends DateTimeBetween, B extends DateTimeBetweenBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;
        @Generated
        private Property<ZonedDateTime> after;
        @Generated
        private Property<ZonedDateTime> before;

        @Generated
        public B date(String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B after(Property<ZonedDateTime> after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(Property<ZonedDateTime> before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DateTimeBetween.DateTimeBetweenBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ", after=" + String.valueOf(this.after) + ", before=" + String.valueOf(this.before) + ")";
        }
    }

    @Generated
    private static final class DateTimeBetweenBuilderImpl
    extends DateTimeBetweenBuilder<DateTimeBetween, DateTimeBetweenBuilderImpl> {
        @Generated
        private DateTimeBetweenBuilderImpl() {
        }

        @Override
        @Generated
        protected DateTimeBetweenBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DateTimeBetween build() {
            return new DateTimeBetween(this);
        }
    }
}

