/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for a specific flow of an execution.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow based on execution of another flow.", full=true, code={"id: flow_condition_executionflow\nnamespace: company.team\n\ntasks:\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute when flow `flow_a` of namespace `company.team` enters RUNNING state.\"\n\ntriggers:\n  - id: flow_trigger\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionFlow\n        flowId: flow_a\n        namespace: company.team\n    states:\n      - RUNNING\n"})}, aliases={"io.kestra.core.models.conditions.types.ExecutionFlowCondition", "io.kestra.plugin.core.condition.ExecutionFlowCondition"})
public class ExecutionFlow
extends Condition {
    @NotNull
    @Schema(title="The namespace of the flow.")
    private Property<String> namespace;
    @NotNull
    @Schema(title="The flow id.")
    private Property<String> flowId;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with null execution");
        }
        RunContext runContext = conditionContext.getRunContext();
        return conditionContext.getExecution().getNamespace().equals(runContext.render(this.namespace).as(String.class, conditionContext.getVariables()).orElseThrow()) && conditionContext.getExecution().getFlowId().equals(runContext.render(this.flowId).as(String.class, conditionContext.getVariables()).orElseThrow());
    }

    @Generated
    protected ExecutionFlow(ExecutionFlowBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
    }

    @Generated
    public static ExecutionFlowBuilder<?, ?> builder() {
        return new ExecutionFlowBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionFlow(super=" + super.toString() + ", namespace=" + String.valueOf(this.getNamespace()) + ", flowId=" + String.valueOf(this.getFlowId()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionFlow)) {
            return false;
        }
        ExecutionFlow other = (ExecutionFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$namespace = this.getNamespace();
        Property<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Property<String> this$flowId = this.getFlowId();
        Property<String> other$flowId = other.getFlowId();
        return !(this$flowId == null ? other$flowId != null : !((Object)this$flowId).equals(other$flowId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionFlow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Property<String> $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : ((Object)$flowId).hashCode());
        return result;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<String> getFlowId() {
        return this.flowId;
    }

    @Generated
    public ExecutionFlow() {
    }

    @Generated
    public static abstract class ExecutionFlowBuilder<C extends ExecutionFlow, B extends ExecutionFlowBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<String> flowId;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(Property<String> flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionFlow.ExecutionFlowBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", flowId=" + String.valueOf(this.flowId) + ")";
        }
    }

    @Generated
    private static final class ExecutionFlowBuilderImpl
    extends ExecutionFlowBuilder<ExecutionFlow, ExecutionFlowBuilderImpl> {
        @Generated
        private ExecutionFlowBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionFlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionFlow build() {
            return new ExecutionFlow(this);
        }
    }
}

