/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.function.BiPredicate;
import lombok.Generated;

@Schema(title="Condition for an execution namespace.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow based on execution of another flow(s) belonging to certain namespace.", full=true, code={"id: flow_condition_executionnamespace\nnamespace: company.team\n\ntasks:\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute when any flow within `company.engineering` namespace enters RUNNING state.\"\n\ntriggers:\n  - id: flow_trigger\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionNamespace\n        namespace: company.engineering\n        comparison: PREFIX\n    states:\n      - RUNNING\n"})}, aliases={"io.kestra.core.models.conditions.types.ExecutionNamespaceCondition", "io.kestra.plugin.core.condition.ExecutionNamespaceCondition"})
public class ExecutionNamespace
extends Condition {
    @NotNull
    @Schema(title="String against which to match the execution namespace depending on the provided comparison.")
    private Property<String> namespace;
    @Schema(title="Comparison to use when checking if namespace matches. If not provided, it will use `EQUALS` by default.")
    private Property<Comparison> comparison;
    @Schema(title="Whether to look at the flow namespace by prefix. Shortcut for `comparison: PREFIX`.", description="Only used when `comparison` is not set")
    private Property<Boolean> prefix;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with null execution");
        }
        RunContext runContext = conditionContext.getRunContext();
        Boolean renderedPrefix = runContext.render(this.prefix).as(Boolean.class).orElseThrow();
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElseThrow();
        return runContext.render(this.comparison).as(Comparison.class).orElse(Boolean.TRUE.equals(renderedPrefix) ? Comparison.PREFIX : Comparison.EQUALS).test(conditionContext.getExecution().getNamespace(), renderedNamespace);
    }

    @Generated
    private static Property<Boolean> $default$prefix() {
        return Property.ofValue(false);
    }

    @Generated
    protected ExecutionNamespace(ExecutionNamespaceBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.comparison = b.comparison;
        this.prefix = b.prefix$set ? b.prefix$value : ExecutionNamespace.$default$prefix();
    }

    @Generated
    public static ExecutionNamespaceBuilder<?, ?> builder() {
        return new ExecutionNamespaceBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionNamespace(super=" + super.toString() + ", namespace=" + String.valueOf(this.getNamespace()) + ", comparison=" + String.valueOf(this.getComparison()) + ", prefix=" + String.valueOf(this.getPrefix()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionNamespace)) {
            return false;
        }
        ExecutionNamespace other = (ExecutionNamespace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$namespace = this.getNamespace();
        Property<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Property<Comparison> this$comparison = this.getComparison();
        Property<Comparison> other$comparison = other.getComparison();
        if (this$comparison == null ? other$comparison != null : !((Object)this$comparison).equals(other$comparison)) {
            return false;
        }
        Property<Boolean> this$prefix = this.getPrefix();
        Property<Boolean> other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionNamespace;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Property<Comparison> $comparison = this.getComparison();
        result = result * 59 + ($comparison == null ? 43 : ((Object)$comparison).hashCode());
        Property<Boolean> $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
        return result;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<Comparison> getComparison() {
        return this.comparison;
    }

    @Generated
    public Property<Boolean> getPrefix() {
        return this.prefix;
    }

    @Generated
    public ExecutionNamespace() {
        this.prefix = ExecutionNamespace.$default$prefix();
    }

    public static enum Comparison {
        EQUALS(String::equals),
        PREFIX(String::startsWith),
        SUFFIX(String::endsWith);

        private final BiPredicate<String, String> checker;

        private Comparison(BiPredicate<String, String> checker) {
            this.checker = checker;
        }

        public boolean test(String actualNamespace, String matcher) {
            return this.checker.test(actualNamespace, matcher);
        }
    }

    @Generated
    public static abstract class ExecutionNamespaceBuilder<C extends ExecutionNamespace, B extends ExecutionNamespaceBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<Comparison> comparison;
        @Generated
        private boolean prefix$set;
        @Generated
        private Property<Boolean> prefix$value;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B comparison(Property<Comparison> comparison) {
            this.comparison = comparison;
            return (B)this.self();
        }

        @Generated
        public B prefix(Property<Boolean> prefix) {
            this.prefix$value = prefix;
            this.prefix$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionNamespace.ExecutionNamespaceBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", comparison=" + String.valueOf(this.comparison) + ", prefix$value=" + String.valueOf(this.prefix$value) + ")";
        }
    }

    @Generated
    private static final class ExecutionNamespaceBuilderImpl
    extends ExecutionNamespaceBuilder<ExecutionNamespace, ExecutionNamespaceBuilderImpl> {
        @Generated
        private ExecutionNamespaceBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionNamespaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionNamespace build() {
            return new ExecutionNamespace(this);
        }
    }
}

