/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import de.focus_shift.jollyday.core.HolidayManager;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.ManagerParameters;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Map;
import lombok.Generated;

@Schema(title="Condition to allow events on public holidays.")
@Plugin(examples={@Example(full=true, title="Trigger condition to execute the flow only on public holidays.", code={"id: schedule_condition_public-holiday\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute only on the public holidays of France at 11:00 am.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 11 * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.PublicHoliday\n        country: FR\n"}), @Example(full=true, title="Trigger condition to execute the flow only on work days in France.", code={"id: schedule-condition-work-days\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute only on the work days of France at 11:00 am.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 11 * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.Not\n        conditions:\n          - type: io.kestra.plugin.core.condition.PublicHoliday\n            country: FR\n          - type: io.kestra.plugin.core.condition.Weekend\n"})}, aliases={"io.kestra.core.models.conditions.types.PublicHolidayCondition", "io.kestra.plugin.core.condition.PublicHolidayCondition"})
public class PublicHoliday
extends Condition
implements ScheduleCondition {
    @Schema(title="The date to test.", description="Can be any variable or any valid ISO 8601 datetime. By default, it will use the trigger date.")
    @NotNull
    private Property<String> date;
    @Schema(title="[ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code. If not set, it uses the country code from the default locale.", description="It uses the [Jollyday](https://github.com/focus-shift/jollyday) library for public holiday calendar that supports more than 70 countries.")
    private Property<String> country;
    @Schema(title="[ISO 3166-2](https://en.wikipedia.org/wiki/ISO_3166-2) country subdivision (e.g., provinces and states) code.", description="It uses the [Jollyday](https://github.com/focus-shift/jollyday) library for public holiday calendar that supports more than 70 countries.")
    private Property<String> subDivision;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        Map<String, Object> variables = conditionContext.getVariables();
        String renderedCountry = conditionContext.getRunContext().render(this.country).as(String.class).orElse(null);
        String renderedSubDivision = conditionContext.getRunContext().render(this.subDivision).as(String.class).orElse(null);
        HolidayManager holidayManager = renderedCountry != null ? HolidayManager.getInstance((ManagerParameter)ManagerParameters.create((String)renderedCountry)) : HolidayManager.getInstance();
        LocalDate currentDate = DateUtils.parseLocalDate(conditionContext.getRunContext().render(this.date).as(String.class, variables).orElseThrow());
        return renderedSubDivision == null ? holidayManager.isHoliday(currentDate, new String[0]) : holidayManager.isHoliday(currentDate, new String[]{renderedSubDivision});
    }

    @Generated
    private static Property<String> $default$date() {
        return Property.ofExpression("{{ trigger.date}}");
    }

    @Generated
    protected PublicHoliday(PublicHolidayBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : PublicHoliday.$default$date();
        this.country = b.country;
        this.subDivision = b.subDivision;
    }

    @Generated
    public static PublicHolidayBuilder<?, ?> builder() {
        return new PublicHolidayBuilderImpl();
    }

    @Generated
    public String toString() {
        return "PublicHoliday(super=" + super.toString() + ", date=" + String.valueOf(this.getDate()) + ", country=" + String.valueOf(this.getCountry()) + ", subDivision=" + String.valueOf(this.getSubDivision()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicHoliday)) {
            return false;
        }
        PublicHoliday other = (PublicHoliday)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$date = this.getDate();
        Property<String> other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Property<String> this$country = this.getCountry();
        Property<String> other$country = other.getCountry();
        if (this$country == null ? other$country != null : !((Object)this$country).equals(other$country)) {
            return false;
        }
        Property<String> this$subDivision = this.getSubDivision();
        Property<String> other$subDivision = other.getSubDivision();
        return !(this$subDivision == null ? other$subDivision != null : !((Object)this$subDivision).equals(other$subDivision));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PublicHoliday;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Property<String> $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : ((Object)$country).hashCode());
        Property<String> $subDivision = this.getSubDivision();
        result = result * 59 + ($subDivision == null ? 43 : ((Object)$subDivision).hashCode());
        return result;
    }

    @Generated
    public Property<String> getDate() {
        return this.date;
    }

    @Generated
    public Property<String> getCountry() {
        return this.country;
    }

    @Generated
    public Property<String> getSubDivision() {
        return this.subDivision;
    }

    @Generated
    public PublicHoliday() {
        this.date = PublicHoliday.$default$date();
    }

    @Generated
    public static abstract class PublicHolidayBuilder<C extends PublicHoliday, B extends PublicHolidayBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private Property<String> date$value;
        @Generated
        private Property<String> country;
        @Generated
        private Property<String> subDivision;

        @Generated
        public B date(Property<String> date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B country(Property<String> country) {
            this.country = country;
            return (B)this.self();
        }

        @Generated
        public B subDivision(Property<String> subDivision) {
            this.subDivision = subDivision;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PublicHoliday.PublicHolidayBuilder(super=" + super.toString() + ", date$value=" + String.valueOf(this.date$value) + ", country=" + String.valueOf(this.country) + ", subDivision=" + String.valueOf(this.subDivision) + ")";
        }
    }

    @Generated
    private static final class PublicHolidayBuilderImpl
    extends PublicHolidayBuilder<PublicHoliday, PublicHolidayBuilderImpl> {
        @Generated
        private PublicHolidayBuilderImpl() {
        }

        @Override
        @Generated
        protected PublicHolidayBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PublicHoliday build() {
            return new PublicHoliday(this);
        }
    }
}

