/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.dashboard.chart;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.dashboards.ChartOption;
import io.kestra.core.models.dashboards.charts.Chart;
import io.kestra.plugin.core.dashboard.chart.mardown.sources.MarkdownSource;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Schema(title="Add context and insights with customizable Markdown text.")
@Plugin(examples={@Example(title="Display custom content in place with Markdown.", full=true, code={"charts:\n  - id: markdown_insight\n    type: io.kestra.plugin.core.dashboard.chart.Markdown\n    chartOptions:\n      displayName: Chart Insights\n      description: How to interpret this chart\n    content: |\n      ## Execution Success Rate\n      This chart displays the percentage of successful executions over time.\n\n      - A **higher success rate** indicates stable and reliable workflows.\n\n      - Sudden **drops** may signal issues in task execution or external dependencies.\n\n      - Use this insight to identify trends and optimize performance.\n"})})
public class Markdown
extends Chart<ChartOption> {
    @Deprecated(forRemoval=true)
    @Schema(title="[DEPRECATED]Markdown content to display", description="Use the String source instead")
    private String content;
    private MarkdownSource source;

    @Generated
    protected Markdown(MarkdownBuilder<?, ?> b) {
        super(b);
        this.content = b.content;
        this.source = b.source;
    }

    @Generated
    public static MarkdownBuilder<?, ?> builder() {
        return new MarkdownBuilderImpl();
    }

    @Generated
    public MarkdownBuilder<?, ?> toBuilder() {
        return new MarkdownBuilderImpl().$fillValuesFrom(this);
    }

    @Deprecated
    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public MarkdownSource getSource() {
        return this.source;
    }

    @Generated
    public Markdown() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Markdown)) {
            return false;
        }
        Markdown other = (Markdown)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        MarkdownSource this$source = this.getSource();
        MarkdownSource other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Markdown;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        MarkdownSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    @Generated
    public static abstract class MarkdownBuilder<C extends Markdown, B extends MarkdownBuilder<C, B>>
    extends Chart.ChartBuilder<ChartOption, C, B> {
        @Generated
        private String content;
        @Generated
        private MarkdownSource source;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MarkdownBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Markdown instance, MarkdownBuilder<?, ?> b) {
            b.content(instance.content);
            b.source(instance.source);
        }

        @Deprecated
        @Generated
        public B content(String content) {
            this.content = content;
            return (B)this.self();
        }

        @Generated
        public B source(MarkdownSource source) {
            this.source = source;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Markdown.MarkdownBuilder(super=" + super.toString() + ", content=" + this.content + ", source=" + String.valueOf(this.source) + ")";
        }
    }

    @Generated
    private static final class MarkdownBuilderImpl
    extends MarkdownBuilder<Markdown, MarkdownBuilderImpl> {
        @Generated
        private MarkdownBuilderImpl() {
        }

        @Override
        @Generated
        protected MarkdownBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Markdown build() {
            return new Markdown(this);
        }
    }
}

