/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Metric;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.TruthUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

@Schema(title="Assert some conditions to control task output data.", description="Used to control outputs data emitted from previous task on this execution.")
@Plugin(examples={@Example(title="Assert based on inputs data", full=true, code={"id: assert\nnamespace: company.team\n\ninputs:\n  - id: param\n    type: STRING\n    required: true\n\ntasks:\n  - id: fail\n    type: io.kestra.plugin.core.execution.Assert\n    conditions:\n     - \"{{ inputs.param == 'ok' }}\"\n     - \"{{ 1 + 1 == 3 }}\"\n"})}, metrics={@Metric(name="failed", type="counter"), @Metric(name="success", type="counter")})
public class Assert
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="List of assertion condition, must coerce to a boolean.", description="Boolean coercion allows 0, -0, and '' to coerce to false, all other values to coerce to true.")
    @NotNull
    @PluginProperty(dynamic=true)
    private List<String> conditions;
    @Schema(title="Optional error message")
    private Property<String> errorMessage;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        AtomicInteger failed = new AtomicInteger(0);
        AtomicInteger success = new AtomicInteger(0);
        this.conditions.forEach(s -> {
            try {
                String renderer = runContext.render((String)s);
                if (TruthUtils.isFalsy(renderer)) {
                    runContext.logger().error("Assertion `{}` failed!", s, (Object)renderer);
                    failed.incrementAndGet();
                } else {
                    success.incrementAndGet();
                }
            }
            catch (IllegalVariableEvaluationException e) {
                runContext.logger().error("Assertion `{}` failed, failed to render `{}`", s, (Object)e.getMessage());
                failed.incrementAndGet();
            }
        });
        runContext.metric(Counter.of("success", success.get(), new String[0]));
        runContext.metric(Counter.of("failed", failed.get(), new String[0]));
        if (failed.get() > 0) {
            throw new Exception(String.valueOf(failed) + " assertion" + (failed.get() > 1 ? "s" : "") + " failed!" + runContext.render(this.errorMessage).as(String.class).map(r -> "\n" + r).orElse(""));
        }
        return null;
    }

    @Generated
    protected Assert(AssertBuilder<?, ?> b) {
        super(b);
        this.conditions = b.conditions;
        this.errorMessage = b.errorMessage;
    }

    @Generated
    public static AssertBuilder<?, ?> builder() {
        return new AssertBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Assert(super=" + super.toString() + ", conditions=" + String.valueOf(this.getConditions()) + ", errorMessage=" + String.valueOf(this.getErrorMessage()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Assert)) {
            return false;
        }
        Assert other = (Assert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$conditions = this.getConditions();
        List<String> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Property<String> this$errorMessage = this.getErrorMessage();
        Property<String> other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !((Object)this$errorMessage).equals(other$errorMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Assert;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Property<String> $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : ((Object)$errorMessage).hashCode());
        return result;
    }

    @Generated
    public List<String> getConditions() {
        return this.conditions;
    }

    @Generated
    public Property<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Assert() {
    }

    @Generated
    public static abstract class AssertBuilder<C extends Assert, B extends AssertBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<String> conditions;
        @Generated
        private Property<String> errorMessage;

        @Generated
        public B conditions(List<String> conditions) {
            this.conditions = conditions;
            return (B)this.self();
        }

        @Generated
        public B errorMessage(Property<String> errorMessage) {
            this.errorMessage = errorMessage;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Assert.AssertBuilder(super=" + super.toString() + ", conditions=" + String.valueOf(this.conditions) + ", errorMessage=" + String.valueOf(this.errorMessage) + ")";
        }
    }

    @Generated
    private static final class AssertBuilderImpl
    extends AssertBuilder<Assert, AssertBuilderImpl> {
        @Generated
        private AssertBuilderImpl() {
        }

        @Override
        @Generated
        protected AssertBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Assert build() {
            return new Assert(this);
        }
    }
}

