/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="List execution counts for a list of flows.", description="This can be used to send an alert if a condition is met about execution counts.")
@Plugin(examples={@Example(title="Send a slack notification if there is no execution for a flow in the last 24 hours.", full=true, code={"id: executions_count\nnamespace: company.team\n\ntasks:\n  - id: counts\n    type: io.kestra.plugin.core.execution.Count\n    expression: \"{{ count == 0 }}\"\n    flows:\n      - namespace: company.team\n        flowId: logs\n    startDate: \"{{ now() | dateAdd(-1, 'DAYS') }}\"\n\n  - id: for_each\n    type: io.kestra.plugin.core.flow.ForEach\n    concurrencyLimit: 0\n    values: \"{{ jq outputs.counts.results '. | select(. != null) | .[]' }}\"\n    tasks:\n      - id: slack_incoming_webhook\n        type: io.kestra.plugin.notifications.slack.SlackIncomingWebhook\n        payload: |\n          {\n            \"channel\": \"#run-channel\",\n            \"text\": \":warning: Flow `{{ jq taskrun.value '.namespace' true }}`.`{{ jq taskrun.value '.flowId' true }}` has no execution for last 24h!\"\n          }\n        url: \"https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    backfill: {}\n    cron: \"0 4 * * * \"\n"})}, aliases={"io.kestra.core.tasks.executions.Counts"})
public class Count
extends Task
implements RunnableTask<Output> {
    @Schema(title="A list of flows to be filtered", description="If not provided, namespaces must be set.")
    @PluginProperty
    protected List<Flow> flows;
    @Schema(title="A list of states to be filtered")
    protected Property<List<State.Type>> states;
    @NotNull
    @Schema(title="The start date")
    protected Property<String> startDate;
    @Schema(title="The end date")
    protected Property<String> endDate;
    @NotNull
    @Schema(title="The expression to check against each flow", description="The expression is such that the expression must return `true` in order to keep the current line.\nSome examples: \n- ```yaml {{ eq count 0 }} ```: no execution found\n- ```yaml {{ gte count 5 }} ```: more than 5 executions\n")
    @PluginProperty(dynamic=true)
    protected String expression;
    protected Property<List<String>> namespaces;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        ExecutionRepositoryInterface executionRepository = (ExecutionRepositoryInterface)((DefaultRunContext)runContext).getApplicationContext().getBean(ExecutionRepositoryInterface.class);
        if (this.flows == null && this.namespaces == null) {
            throw new IllegalArgumentException("You must provide a list of flows or namespaces.");
        }
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
        if (this.flows != null) {
            this.flows.forEach(flow -> flowService.checkAllowedNamespace(flowInfo.tenantId(), flow.getNamespace(), flowInfo.tenantId(), flowInfo.namespace()));
        }
        if (this.namespaces != null) {
            List<String> renderedNamespaces = runContext.render(this.namespaces).asList(String.class);
            renderedNamespaces.forEach(namespace -> flowService.checkAllowedNamespace(flowInfo.tenantId(), (String)namespace, flowInfo.tenantId(), flowInfo.namespace()));
        }
        List<ExecutionCount> executionCounts = executionRepository.executionCounts(flowInfo.tenantId(), this.flows, runContext.render(this.states).asList(State.Type.class), runContext.render(this.startDate).as(String.class).map(ZonedDateTime::parse).orElse(null), runContext.render(this.endDate).as(String.class).map(ZonedDateTime::parse).orElse(null), runContext.render(this.namespaces).asList(String.class));
        logger.trace("{} flows matching filters", (Object)executionCounts.size());
        List<Result> count = executionCounts.stream().filter(Rethrow.throwPredicate(item -> runContext.render(this.expression, (Map<String, Object>)ImmutableMap.of((Object)"count", (Object)item.getCount().intValue())).equals("true"))).map(item -> Result.builder().namespace(item.getNamespace()).flowId(item.getFlowId()).count(item.getCount()).build()).toList();
        logger.debug("{} flows matching the expression", (Object)count.size());
        return Output.builder().results(count).total(count.stream().mapToLong(value -> value.count).sum()).build();
    }

    @Generated
    protected Count(CountBuilder<?, ?> b) {
        super(b);
        this.flows = b.flows;
        this.states = b.states;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.expression = b.expression;
        this.namespaces = b.namespaces;
    }

    @Generated
    public static CountBuilder<?, ?> builder() {
        return new CountBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Count(super=" + super.toString() + ", flows=" + String.valueOf(this.getFlows()) + ", states=" + String.valueOf(this.getStates()) + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", expression=" + this.getExpression() + ", namespaces=" + String.valueOf(this.getNamespaces()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Count)) {
            return false;
        }
        Count other = (Count)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        Property<List<State.Type>> this$states = this.getStates();
        Property<List<State.Type>> other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Property<String> this$startDate = this.getStartDate();
        Property<String> other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Property<String> this$endDate = this.getEndDate();
        Property<String> other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Property<List<String>> this$namespaces = this.getNamespaces();
        Property<List<String>> other$namespaces = other.getNamespaces();
        return !(this$namespaces == null ? other$namespaces != null : !((Object)this$namespaces).equals(other$namespaces));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Count;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        Property<List<State.Type>> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Property<String> $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Property<String> $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Property<List<String>> $namespaces = this.getNamespaces();
        result = result * 59 + ($namespaces == null ? 43 : ((Object)$namespaces).hashCode());
        return result;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Property<List<State.Type>> getStates() {
        return this.states;
    }

    @Generated
    public Property<String> getStartDate() {
        return this.startDate;
    }

    @Generated
    public Property<String> getEndDate() {
        return this.endDate;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public Property<List<String>> getNamespaces() {
        return this.namespaces;
    }

    @Generated
    public Count() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private final List<Result> results;
        private final Long total;

        @ConstructorProperties(value={"results", "total"})
        @Generated
        Output(List<Result> results, Long total) {
            this.results = results;
            this.total = total;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<Result> getResults() {
            return this.results;
        }

        @Generated
        public Long getTotal() {
            return this.total;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<Result> results;
            @Generated
            private Long total;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder results(List<Result> results) {
                this.results = results;
                return this;
            }

            @Generated
            public OutputBuilder total(Long total) {
                this.total = total;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.results, this.total);
            }

            @Generated
            public String toString() {
                return "Count.Output.OutputBuilder(results=" + String.valueOf(this.results) + ", total=" + this.total + ")";
            }
        }
    }

    @Generated
    public static abstract class CountBuilder<C extends Count, B extends CountBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<Flow> flows;
        @Generated
        private Property<List<State.Type>> states;
        @Generated
        private Property<String> startDate;
        @Generated
        private Property<String> endDate;
        @Generated
        private String expression;
        @Generated
        private Property<List<String>> namespaces;

        @Generated
        public B flows(List<Flow> flows) {
            this.flows = flows;
            return (B)this.self();
        }

        @Generated
        public B states(Property<List<State.Type>> states) {
            this.states = states;
            return (B)this.self();
        }

        @Generated
        public B startDate(Property<String> startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @Generated
        public B endDate(Property<String> endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @Generated
        public B expression(String expression) {
            this.expression = expression;
            return (B)this.self();
        }

        @Generated
        public B namespaces(Property<List<String>> namespaces) {
            this.namespaces = namespaces;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Count.CountBuilder(super=" + super.toString() + ", flows=" + String.valueOf(this.flows) + ", states=" + String.valueOf(this.states) + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", expression=" + this.expression + ", namespaces=" + String.valueOf(this.namespaces) + ")";
        }
    }

    @Generated
    private static final class CountBuilderImpl
    extends CountBuilder<Count, CountBuilderImpl> {
        @Generated
        private CountBuilderImpl() {
        }

        @Override
        @Generated
        protected CountBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Count build() {
            return new Count(this);
        }
    }

    public static class Result {
        private String namespace;
        private String flowId;
        private Long count;

        @ConstructorProperties(value={"namespace", "flowId", "count"})
        @Generated
        Result(String namespace, String flowId, Long count) {
            this.namespace = namespace;
            this.flowId = flowId;
            this.count = count;
        }

        @Generated
        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public Long getCount() {
            return this.count;
        }

        @Generated
        public static class ResultBuilder {
            @Generated
            private String namespace;
            @Generated
            private String flowId;
            @Generated
            private Long count;

            @Generated
            ResultBuilder() {
            }

            @Generated
            public ResultBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public ResultBuilder flowId(String flowId) {
                this.flowId = flowId;
                return this;
            }

            @Generated
            public ResultBuilder count(Long count) {
                this.count = count;
                return this;
            }

            @Generated
            public Result build() {
                return new Result(this.namespace, this.flowId, this.count);
            }

            @Generated
            public String toString() {
                return "Count.Result.ResultBuilder(namespace=" + this.namespace + ", flowId=" + this.flowId + ", count=" + this.count + ")";
            }
        }
    }
}

