/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.models.tasks.runners.PluginUtilsService;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.ExecutionService;
import io.kestra.plugin.core.flow.Pause;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import lombok.Generated;

@Schema(title="Resume a paused execution.", description="By default, the task assumes that you want to resume the current `executionId`. If you want to programmatically resume an execution of another flow, make sure to define the `executionId`, `flowId`, and `namespace` properties explicitly. Using the `inputs` property, you can additionally pass custom `onResume` input values to the execution.")
@Plugin(examples={@Example(code={"executionId: \"{{ trigger.executionId }}\""})})
public class Resume
extends Task
implements RunnableTask<VoidOutput> {
    @Schema(title="Filter for a specific namespace in case `executionId` is set. In case you wonder why `executionId` is not enough \u2014 we require specifying the namespace to make permissions explicit. The Enterprise Edition of Kestra allows you to resume executions from another namespaces only if the permissions allow it. Check the [Allowed Namespaces](https://kestra.io/docs/enterprise/allowed-namespaces) documentation for more details.")
    private Property<String> namespace;
    @Schema(title="Filter for a specific flow identifier in case `executionId` is set.")
    private Property<String> flowId;
    @Schema(title="Filter for a specific execution.", description="If you explicitly define an `executionId`, Kestra will use that specific ID.\n\nIf `executionId` is not set and `namespace` and `flowId` properties are set, Kestra will look for a paused execution for that corresponding flow.\n\nIf `executionId` is not set, the task will use the ID of the current execution.")
    private Property<String> executionId;
    @Schema(title="Inputs to be passed to the execution when it's resumed")
    private Property<Map<String, Object>> inputs;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        PluginUtilsService.ExecutionInfo executionInfo = PluginUtilsService.executionFromTaskParameters(runContext, runContext.render(this.namespace).as(String.class).orElse(null), runContext.render(this.flowId).as(String.class).orElse(null), runContext.render(this.executionId).as(String.class).orElse(null));
        ApplicationContext applicationContext = ((DefaultRunContext)runContext).getApplicationContext();
        ExecutionService executionService = (ExecutionService)applicationContext.getBean(ExecutionService.class);
        ExecutionRepositoryInterface executionRepository = (ExecutionRepositoryInterface)applicationContext.getBean(ExecutionRepositoryInterface.class);
        FlowMetaStoreInterface flowExecutor = (FlowMetaStoreInterface)applicationContext.getBean(FlowMetaStoreInterface.class);
        QueueInterface executionQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        Execution execution = executionRepository.findById(executionInfo.tenantId(), executionInfo.id()).orElseThrow(() -> new IllegalArgumentException("No execution found for execution id " + executionInfo.id()));
        FlowInterface flow = flowExecutor.findByExecution(execution).orElseThrow(() -> new IllegalArgumentException("Flow not found for execution ID " + executionInfo.id()));
        Map<String, Object> renderedInputs = runContext.render(this.inputs).asMap(String.class, Object.class);
        renderedInputs = !renderedInputs.isEmpty() ? renderedInputs : null;
        Execution resumed = executionService.resume(execution, flow, State.Type.RUNNING, renderedInputs, Pause.Resumed.now());
        executionQueue.emit(resumed);
        return null;
    }

    @Generated
    protected Resume(ResumeBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.executionId = b.executionId;
        this.inputs = b.inputs;
    }

    @Generated
    public static ResumeBuilder<?, ?> builder() {
        return new ResumeBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Resume(super=" + super.toString() + ", namespace=" + String.valueOf(this.getNamespace()) + ", flowId=" + String.valueOf(this.getFlowId()) + ", executionId=" + String.valueOf(this.getExecutionId()) + ", inputs=" + String.valueOf(this.getInputs()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resume)) {
            return false;
        }
        Resume other = (Resume)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$namespace = this.getNamespace();
        Property<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Property<String> this$flowId = this.getFlowId();
        Property<String> other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !((Object)this$flowId).equals(other$flowId)) {
            return false;
        }
        Property<String> this$executionId = this.getExecutionId();
        Property<String> other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        Property<Map<String, Object>> this$inputs = this.getInputs();
        Property<Map<String, Object>> other$inputs = other.getInputs();
        return !(this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resume;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Property<String> $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : ((Object)$flowId).hashCode());
        Property<String> $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        Property<Map<String, Object>> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        return result;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<String> getFlowId() {
        return this.flowId;
    }

    @Generated
    public Property<String> getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Property<Map<String, Object>> getInputs() {
        return this.inputs;
    }

    @Generated
    public Resume() {
    }

    @Generated
    public static abstract class ResumeBuilder<C extends Resume, B extends ResumeBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<String> flowId;
        @Generated
        private Property<String> executionId;
        @Generated
        private Property<Map<String, Object>> inputs;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(Property<String> flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B executionId(Property<String> executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B inputs(Property<Map<String, Object>> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Resume.ResumeBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", flowId=" + String.valueOf(this.flowId) + ", executionId=" + String.valueOf(this.executionId) + ", inputs=" + String.valueOf(this.inputs) + ")";
        }
    }

    @Generated
    private static final class ResumeBuilderImpl
    extends ResumeBuilder<Resume, ResumeBuilderImpl> {
        @Generated
        private ResumeBuilderImpl() {
        }

        @Override
        @Generated
        protected ResumeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Resume build() {
            return new Resume(this);
        }
    }
}

