/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.flow.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Allow a list of tasks to fail without stopping the execution of downstream tasks in the flow.", description="If any child task of the `AllowFailure` task fails, the flow will stop executing this block of tasks (i.e. the next tasks in the `AllowFailure` block will no longer be executed), but the flow execution of the tasks, following the `AllowFailure` task, will continue.")
@Plugin(examples={@Example(full=true, code={"id: allow_failure\nnamespace: company.team\n\ntasks:\n  - id: sequential\n    type: io.kestra.plugin.core.flow.AllowFailure\n    tasks:\n     - id: ko\n       type: io.kestra.plugin.scripts.shell.Commands\n       commands:\n        - 'exit 1'\n\n  - id: last\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n"}), @Example(full=true, title="Allow failure of a group of tasks", code={"    id: allow-failure-demo\n    namespace: company.team\n\n    tasks:\n    - id: allow_failure\n        type: io.kestra.plugin.core.flow.AllowFailure\n        tasks:\n        - id: fail_silently\n            type: io.kestra.plugin.scripts.shell.Commands\n            taskRunner:\n            type: io.kestra.plugin.core.runner.Process\n            commands:\n            - exit 1\n\n    - id: print_to_console\n        type: io.kestra.plugin.scripts.shell.Commands\n        taskRunner:\n        type: io.kestra.plugin.core.runner.Process\n        commands:\n        - echo \"this will run since previous failure was allowed \u2705\"\n\n"})}, aliases={"io.kestra.core.tasks.flows.AllowFailure"})
public class AllowFailure
extends Sequential
implements FlowableTask<VoidOutput> {
    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> resolvedFinally;
        List<ResolvedTask> resolvedErrors;
        List<ResolvedTask> resolvedTasks = this.childTasks(runContext, parentTaskRun);
        Optional<State.Type> type = FlowableUtils.resolveState(execution, resolvedTasks, resolvedErrors = FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), resolvedFinally = FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
        if (type.isEmpty()) {
            return type;
        }
        Optional<State.Type> normalState = FlowableUtils.resolveState(execution, resolvedTasks, null, resolvedFinally, parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
        if (normalState.isPresent() && normalState.get().isFailed()) {
            return Optional.of(State.Type.WARNING);
        }
        return type;
    }

    @Generated
    protected AllowFailure(AllowFailureBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
    }

    @Generated
    public static AllowFailureBuilder<?, ?> builder() {
        return new AllowFailureBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "AllowFailure(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllowFailure)) {
            return false;
        }
        AllowFailure other = (AllowFailure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AllowFailure;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public AllowFailure() {
    }

    @Generated
    private static final class AllowFailureBuilderImpl
    extends AllowFailureBuilder<AllowFailure, AllowFailureBuilderImpl> {
        @Generated
        private AllowFailureBuilderImpl() {
        }

        @Override
        @Generated
        protected AllowFailureBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AllowFailure build() {
            return new AllowFailure(this);
        }
    }

    @Generated
    public static abstract class AllowFailureBuilder<C extends AllowFailure, B extends AllowFailureBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AllowFailure.AllowFailureBuilder(super=" + super.toString() + ")";
        }
    }
}

