/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.flow.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(title="For each value in the list, execute one or more tasks sequentially (Deprecated).", description="This task is deprecated, please use the `io.kestra.plugin.core.flow.ForEach` task instead.\n\nThe list of `tasks` will be executed for each item sequentially. The value must be a valid JSON string representing an array, e.g. a list of strings `[\"value1\", \"value2\"]` or a list of dictionaries `[{\"key\": \"value1\"}, {\"key\": \"value2\"}]`. \n\nYou can access the current iteration value using the variable `{{ taskrun.value }}`. The task list will be executed sequentially for each item.\n\nWe highly recommend triggering a subflow for each value. This allows much better scalability and modularity. Check the [flow best practices documentation](https://kestra.io/docs/best-practices/flows) for more details.")
@Plugin(examples={@Example(full=true, title="The taskrun.value from the `each_sequential` task is available only to immediate child tasks such as the `before_if` and the `if` tasks. To access the taskrun value in child tasks of the `if` task (such as in the `after_if` task), you need to use the syntax `{{ parent.taskrun.value }}` as this allows you to access the taskrun value of the parent task `each_sequential`.", code={"id: loop_example\nnamespace: company.team\n\ntasks:\n  - id: each_sequential\n    type: io.kestra.plugin.core.flow.EachSequential\n    value: [\"value 1\", \"value 2\", \"value 3\"]\n    tasks:\n      - id: before_if\n        type: io.kestra.plugin.core.debug.Return\n        format: 'Before if {{ taskrun.value }}'\n      - id: if\n        type: io.kestra.plugin.core.flow.If\n        condition: '{{ taskrun.value == \"value 2\" }}'\n        then:\n          - id: after_if\n            type: io.kestra.plugin.core.debug.Return\n            format: \"After if {{ parent.taskrun.value }}\"\n"}), @Example(full=true, title="This task shows that the value can be a bullet-style list. The task iterates over the list of values and executes the `each_value` child task for each value.", code={"id: each_sequential_flow\nnamespace: company.team\n\ntasks:\n  - id: each_sequential\n    type: io.kestra.plugin.core.flow.EachSequential\n    value:\n      - value 1\n      - value 2\n      - value 3\n    tasks:\n      - id: each_value\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} with value '{{ taskrun.value }}'\"\n"})}, aliases={"io.kestra.core.tasks.flows.EachSequential"})
@Deprecated(since="0.19", forRemoval=true)
public class EachSequential
extends Sequential
implements FlowableTask<VoidOutput> {
    @NotNull
    @PluginProperty(dynamic=true)
    @Schema(title="The list of values for this task", description="The value can be passed as a string, a list of strings, or a list of objects.", oneOf={String.class, Object[].class})
    private Object value;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.DYNAMIC);
        GraphUtils.sequential(subGraph, this.getTasks(), this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = ListUtils.emptyOnNull(this.childTasks(runContext, parentTaskRun)).stream().filter(resolvedTask -> resolvedTask.getTask().getDisabled() == false).toList();
        if (childTasks.isEmpty()) {
            return Optional.of(State.Type.SUCCESS);
        }
        return FlowableUtils.resolveState(execution, childTasks, FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun);
    }

    @Generated
    protected EachSequential(EachSequentialBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
        this.value = b.value;
    }

    @Generated
    public static EachSequentialBuilder<?, ?> builder() {
        return new EachSequentialBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "EachSequential(super=" + super.toString() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EachSequential)) {
            return false;
        }
        EachSequential other = (EachSequential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EachSequential;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public EachSequential() {
    }

    @Generated
    public static abstract class EachSequentialBuilder<C extends EachSequential, B extends EachSequentialBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Generated
        private Object value;

        @Generated
        public B value(Object value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EachSequential.EachSequentialBuilder(super=" + super.toString() + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    @Generated
    private static final class EachSequentialBuilderImpl
    extends EachSequentialBuilder<EachSequential, EachSequentialBuilderImpl> {
        @Generated
        private EachSequentialBuilderImpl() {
        }

        @Override
        @Generated
        protected EachSequentialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EachSequential build() {
            return new EachSequential(this);
        }
    }
}

