/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.flow.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Execute a group of tasks for each value in the list.", description="You can control how many task groups are executed concurrently by setting the `concurrencyLimit` property. \n- If you set the `concurrencyLimit` property to `0`, Kestra will execute all task groups concurrently for all values. \n- If you set the `concurrencyLimit` property to `1`, Kestra will execute each task group one after the other starting with the task group for the first value in the list. \n\nRegardless of the `concurrencyLimit` property, the `tasks` will run one after the other \u2014 to run those in parallel, wrap them in a [Parallel](https://kestra.io/plugins/core/tasks/flow/io.kestra.plugin.core.flow.parallel) task as shown in the last example below (_see the flow `parallel_tasks_example`_). \n\nThe `values` should be defined as a JSON string or an array, e.g. a list of string values `[\"value1\", \"value2\"]` or a list of key-value pairs `[{\"key\": \"value1\"}, {\"key\": \"value2\"}]`. \n\n\nYou can access the current iteration value using the variable `{{ taskrun.value }}` or `{{ parent.taskrun.value }}` if you are in a nested child task. You can access the batch or iteration number with `{{ taskrun.iteration }}`. \n\nIf you need to execute more than 2-5 tasks for each value, we recommend triggering a subflow for each value for better performance and modularity. Check the [flow best practices documentation](https://kestra.io/docs/best-practices/flows) for more details.")
@Plugin(examples={@Example(full=true, title="The `{{ taskrun.value }}` from the `for_each` task is available only to direct child tasks such as the `before_if` and the `if` tasks. To access the taskrun value of the parent task in a nested child task such as the `after_if` task, use `{{ parent.taskrun.value }}`.", code={"id: for_loop_example\nnamespace: company.team\n\ntasks:\n  - id: for_each\n    type: io.kestra.plugin.core.flow.ForEach\n    values: [\"value 1\", \"value 2\", \"value 3\"]\n    tasks:\n      - id: before_if\n        type: io.kestra.plugin.core.debug.Return\n        format: \"Before if {{ taskrun.value }}\"\n      - id: if\n        type: io.kestra.plugin.core.flow.If\n        condition: '{{ taskrun.value == \"value 2\" }}'\n        then:\n          - id: after_if\n            type: io.kestra.plugin.core.debug.Return\n            format: \"After if {{ parent.taskrun.value }}\"\n"}), @Example(full=true, title="This flow uses YAML-style array for `values`. The task `for_each` iterates over a list of values and executes the `return` child task for each value. The `concurrencyLimit` property is set to 2, so the `return` task will run concurrently for the first two values in the list at first. The `return` task will run for the next two values only after the task runs for the first two values have completed.", code={"id: for_each_value\nnamespace: company.team\n\ntasks:\n  - id: for_each\n    type: io.kestra.plugin.core.flow.ForEach\n    values:\n      - value 1\n      - value 2\n      - value 3\n      - value 4\n    concurrencyLimit: 2\n    tasks:\n      - id: return\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} with value {{ taskrun.value }}\"\n"}), @Example(full=true, title="This example shows how to run tasks in parallel for each value in the list. All child tasks of the `parallel` task will run in parallel. However, due to the `concurrencyLimit` property set to 2, only two `parallel` task groups will run at any given time.", code={"id: parallel_tasks_example\nnamespace: company.team\n\ntasks:\n  - id: for_each\n    type: io.kestra.plugin.core.flow.ForEach\n    values: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]\n    concurrencyLimit: 2\n    tasks:\n      - id: parallel\n        type: io.kestra.plugin.core.flow.Parallel\n        tasks:\n        - id: log\n          type: io.kestra.plugin.core.log.Log\n          message: Processing {{ parent.taskrun.value }}\n        - id: shell\n          type: io.kestra.plugin.scripts.shell.Commands\n          commands:\n            - sleep {{ parent.taskrun.value }}\n"}), @Example(full=true, title="This example demonstrates processing data across nested loops of S3 buckets, years, and months. It generates structured identifiers (e.g., `bucket1_2025_March`) by combining values from each loop level, while accessing parent loop values like years and buckets, which can be useful for partitioned storage paths or time-based datasets. The flow uses dynamic expressions referencing parent context.", code={"id: loop_multiple_times\nnamespace: company.team\n\ninputs:\n  - id: s3_buckets\n    type: ARRAY\n    itemType: STRING\n    defaults:\n      - bucket1\n      - bucket2\n\n  - id: years\n    type: ARRAY\n    itemType: INT\n    defaults:\n      - 2025\n      - 2026\n\n  - id: months\n    type: ARRAY\n    itemType: STRING\n    defaults:\n      - March\n      - April\n\ntasks:\n  - id: buckets\n    type: io.kestra.plugin.core.flow.ForEach\n    values: \"{{inputs.s3_buckets}}\"\n    tasks:\n      - id: year\n        type: io.kestra.plugin.core.flow.ForEach\n        values: \"{{inputs.years}}\"\n        tasks:\n          - id: month\n            type: io.kestra.plugin.core.flow.ForEach\n            values: \"{{inputs.months}}\"\n            tasks:\n              - id: full_table_name\n                type: io.kestra.plugin.core.log.Log\n                message: |\n                  Full table name: {{parents[1].taskrun.value }}_{{parent.taskrun.value}}_{{taskrun.value}}\n                  Direct/current loop (months): {{taskrun.value}}\n                  Value of loop one higher up (years): {{parents[0].taskrun.value}}\n                  Further up (table types): {{parents[1].taskrun.value}}\n"})})
public class ForEach
extends Sequential
implements FlowableTask<VoidOutput> {
    @NotNull
    @PluginProperty(dynamic=true)
    @Schema(title="The list of values for which Kestra will execute a group of tasks", description="The values can be passed as a string, a list of strings, or a list of objects.", oneOf={String.class, Object[].class})
    private Object values;
    @PositiveOrZero
    @NotNull
    @Schema(title="The number of concurrent task groups for each value in the `values` array", description="If you set the `concurrencyLimit` property to 0, Kestra will execute all task groups concurrently for all values (zero limits!). \n\nIf you set the `concurrencyLimit` property to 1, Kestra will execute each task group one after the other starting with the first value in the list (limit concurrency to one task group that can be actively running at any time).")
    @PluginProperty
    private final Integer concurrencyLimit;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.DYNAMIC);
        GraphUtils.sequential(subGraph, this.getTasks(), this.getErrors(), this.getFinally(), taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.values);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = ListUtils.emptyOnNull(this.childTasks(runContext, parentTaskRun)).stream().filter(resolvedTask -> resolvedTask.getTask().getDisabled() == false).toList();
        if (childTasks.isEmpty()) {
            return Optional.of(State.Type.SUCCESS);
        }
        return FlowableUtils.resolveState(execution, childTasks, FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        if (this.concurrencyLimit == 1) {
            return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun);
        }
        return FlowableUtils.resolveConcurrentNexts(execution, FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.values), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun, this.concurrencyLimit);
    }

    @Generated
    private static Integer $default$concurrencyLimit() {
        return 1;
    }

    @Generated
    protected ForEach(ForEachBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
        this.values = b.values;
        this.concurrencyLimit = b.concurrencyLimit$set ? b.concurrencyLimit$value : ForEach.$default$concurrencyLimit();
    }

    @Generated
    public static ForEachBuilder<?, ?> builder() {
        return new ForEachBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "ForEach(super=" + super.toString() + ", values=" + String.valueOf(this.getValues()) + ", concurrencyLimit=" + this.getConcurrencyLimit() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForEach)) {
            return false;
        }
        ForEach other = (ForEach)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$concurrencyLimit = this.getConcurrencyLimit();
        Integer other$concurrencyLimit = other.getConcurrencyLimit();
        if (this$concurrencyLimit == null ? other$concurrencyLimit != null : !((Object)this$concurrencyLimit).equals(other$concurrencyLimit)) {
            return false;
        }
        Object this$values = this.getValues();
        Object other$values = other.getValues();
        return !(this$values == null ? other$values != null : !this$values.equals(other$values));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ForEach;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $concurrencyLimit = this.getConcurrencyLimit();
        result = result * 59 + ($concurrencyLimit == null ? 43 : ((Object)$concurrencyLimit).hashCode());
        Object $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : $values.hashCode());
        return result;
    }

    @Generated
    public Object getValues() {
        return this.values;
    }

    @Generated
    public Integer getConcurrencyLimit() {
        return this.concurrencyLimit;
    }

    @Generated
    public ForEach() {
        this.concurrencyLimit = ForEach.$default$concurrencyLimit();
    }

    @Generated
    public static abstract class ForEachBuilder<C extends ForEach, B extends ForEachBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Generated
        private Object values;
        @Generated
        private boolean concurrencyLimit$set;
        @Generated
        private Integer concurrencyLimit$value;

        @Generated
        public B values(Object values) {
            this.values = values;
            return (B)this.self();
        }

        @Generated
        public B concurrencyLimit(Integer concurrencyLimit) {
            this.concurrencyLimit$value = concurrencyLimit;
            this.concurrencyLimit$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ForEach.ForEachBuilder(super=" + super.toString() + ", values=" + String.valueOf(this.values) + ", concurrencyLimit$value=" + this.concurrencyLimit$value + ")";
        }
    }

    @Generated
    private static final class ForEachBuilderImpl
    extends ForEachBuilder<ForEach, ForEachBuilderImpl> {
        @Generated
        private ForEachBuilderImpl() {
        }

        @Override
        @Generated
        protected ForEachBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ForEach build() {
            return new ForEach(this);
        }
    }
}

