/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.TruthUtils;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Run a list of tasks repeatedly until the expected condition is met.", description="Use this task if your workflow requires blocking calls polling for a job to finish or for some external API to return a specific HTTP response.\n\nYou can access the outputs of the nested tasks in the `condition` property. The `condition` is evaluated after all nested task runs finish.\n")
@Plugin(examples={@Example(full=true, title="Run a task until it returns a specific value. Note how you don't need to take care of incrementing the iteration count. The task will loop and keep track of the iteration outputs behind the scenes \u2014 you only need to specify the exit condition for the loop.", code={"id: loop_until\nnamespace: company.team\n\ntasks:\n  - id: loop\n    type: io.kestra.plugin.core.flow.LoopUntil\n    condition: \"{{ outputs.return.value == '4' }}\"\n    tasks:\n      - id: return\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ outputs.loop.iterationCount }}\"\n"})}, aliases={"io.kestra.plugin.core.flow.WaitFor"})
public class LoopUntil
extends Task
implements FlowableTask<Output> {
    private static final int INITIAL_LOOP_VALUE = 1;
    @Valid
    protected List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;
    @Valid
    @PluginProperty
    @NotNull
    private List<Task> tasks;
    @NotNull
    @Schema(title="The condition expression that should evaluate to `true` or `false`", description="Boolean coercion allows 0, -0, null and '' to evaluate to false; all other values will evaluate to true.")
    private Property<String> condition;
    @Schema(title="If set to `true`, the task run will end in a failed state once the `maxIterations` or `maxDuration` are reached.")
    private Property<Boolean> failOnMaxReached;
    @Schema(title="Check the frequency configuration")
    @PluginProperty
    private CheckFrequency checkFrequency;

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    public AbstractGraph tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.SEQUENTIAL);
        GraphUtils.sequential(subGraph, this.tasks, this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.tasks.stream(), Stream.concat(this.getErrors() != null ? this.getErrors().stream() : Stream.empty(), this.getFinally() != null ? this.getFinally().stream() : Stream.empty())).toList();
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveTasks(this.tasks, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveWaitForNext(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun);
    }

    public Instant nextExecutionDate(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        String continueLoop;
        if (!this.reachedMaximums(runContext, execution, parentTaskRun, false) && !TruthUtils.isTruthy(continueLoop = (String)runContext.render(this.condition).as(String.class).orElse(null))) {
            return Instant.now().plus(runContext.render(this.getCheckFrequency().getInterval()).as(Duration.class).orElseThrow());
        }
        return null;
    }

    private boolean reachedMaximums(RunContext runContext, Execution execution, TaskRun parentTaskRun, Boolean printLog) throws IllegalVariableEvaluationException {
        Logger logger = runContext.logger();
        if (!this.childTaskRunExecuted(execution, parentTaskRun)) {
            return false;
        }
        Integer iterationCount = Optional.ofNullable(parentTaskRun.getOutputs()).map(outputs -> (Integer)outputs.get("iterationCount")).orElse(0);
        Optional<Integer> maxIterations = runContext.render(this.getCheckFrequency().getMaxIterations()).as(Integer.class);
        if (maxIterations.isPresent() && iterationCount > maxIterations.get()) {
            if (printLog.booleanValue()) {
                logger.warn("Max iterations reached");
            }
            return true;
        }
        Instant creationDate = parentTaskRun.getState().getHistories().getFirst().getDate();
        Optional<Duration> maxDuration = runContext.render(this.getCheckFrequency().getMaxDuration()).as(Duration.class);
        if (maxDuration.isPresent() && creationDate != null && creationDate.plus(maxDuration.get()).isBefore(Instant.now())) {
            if (printLog.booleanValue()) {
                logger.warn("Max duration reached");
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        boolean childTaskExecuted = this.childTaskRunExecuted(execution, parentTaskRun);
        if (childTaskExecuted && this.nextExecutionDate(runContext, execution, parentTaskRun) != null) {
            return Optional.empty();
        }
        if (childTaskExecuted && this.reachedMaximums(runContext, execution, parentTaskRun, true) && Boolean.TRUE.equals(runContext.render(this.failOnMaxReached).as(Boolean.class).orElseThrow())) {
            return Optional.of(State.Type.FAILED);
        }
        return FlowableUtils.resolveState(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning());
    }

    public boolean childTaskRunExecuted(Execution execution, TaskRun parentTaskRun) {
        if (execution.getTaskRunList() == null) {
            return false;
        }
        return execution.getTaskRunList().stream().filter(t -> t.getParentTaskRunId() != null && t.getParentTaskRunId().equals(parentTaskRun.getId()) && t.getState().isTerminatedNoFail()).count() == (long)this.tasks.size();
    }

    @Override
    public Output outputs(RunContext runContext) throws IllegalVariableEvaluationException {
        Map outputs = (Map)runContext.getVariables().get("outputs");
        if (outputs != null && outputs.get(this.id) != null) {
            return Output.builder().iterationCount((Integer)((Map)outputs.get(this.id)).get("iterationCount")).build();
        }
        return Output.builder().iterationCount(1).build();
    }

    public Output outputs(TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        String value = parentTaskRun != null ? String.valueOf(Optional.ofNullable(parentTaskRun.getOutputs()).map(outputs -> outputs.get("iterationCount")).orElse("0")) : "0";
        return Output.builder().iterationCount(Integer.parseInt(value) + 1).build();
    }

    @Generated
    private static Property<Boolean> $default$failOnMaxReached() {
        return Property.ofValue(false);
    }

    @Generated
    private static CheckFrequency $default$checkFrequency() {
        return CheckFrequency.builder().build();
    }

    @Generated
    protected LoopUntil(LoopUntilBuilder<?, ?> b) {
        super(b);
        this.errors = b.errors;
        this._finally = b._finally;
        this.tasks = b.tasks;
        this.condition = b.condition;
        this.failOnMaxReached = b.failOnMaxReached$set ? b.failOnMaxReached$value : LoopUntil.$default$failOnMaxReached();
        this.checkFrequency = b.checkFrequency$set ? b.checkFrequency$value : LoopUntil.$default$checkFrequency();
    }

    @Generated
    public static LoopUntilBuilder<?, ?> builder() {
        return new LoopUntilBuilderImpl();
    }

    @Generated
    public String toString() {
        return "LoopUntil(super=" + super.toString() + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.getTasks()) + ", condition=" + String.valueOf(this.getCondition()) + ", failOnMaxReached=" + String.valueOf(this.getFailOnMaxReached()) + ", checkFrequency=" + String.valueOf(this.getCheckFrequency()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoopUntil)) {
            return false;
        }
        LoopUntil other = (LoopUntil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        if (this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        Property<String> this$condition = this.getCondition();
        Property<String> other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        Property<Boolean> this$failOnMaxReached = this.getFailOnMaxReached();
        Property<Boolean> other$failOnMaxReached = other.getFailOnMaxReached();
        if (this$failOnMaxReached == null ? other$failOnMaxReached != null : !((Object)this$failOnMaxReached).equals(other$failOnMaxReached)) {
            return false;
        }
        CheckFrequency this$checkFrequency = this.getCheckFrequency();
        CheckFrequency other$checkFrequency = other.getCheckFrequency();
        return !(this$checkFrequency == null ? other$checkFrequency != null : !this$checkFrequency.equals(other$checkFrequency));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoopUntil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        Property<String> $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        Property<Boolean> $failOnMaxReached = this.getFailOnMaxReached();
        result = result * 59 + ($failOnMaxReached == null ? 43 : ((Object)$failOnMaxReached).hashCode());
        CheckFrequency $checkFrequency = this.getCheckFrequency();
        result = result * 59 + ($checkFrequency == null ? 43 : $checkFrequency.hashCode());
        return result;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public Property<String> getCondition() {
        return this.condition;
    }

    @Generated
    public Property<Boolean> getFailOnMaxReached() {
        return this.failOnMaxReached;
    }

    @Generated
    public CheckFrequency getCheckFrequency() {
        return this.checkFrequency;
    }

    @Generated
    public LoopUntil() {
        this.failOnMaxReached = LoopUntil.$default$failOnMaxReached();
        this.checkFrequency = LoopUntil.$default$checkFrequency();
    }

    @Introspected
    public static class CheckFrequency {
        @Schema(title="Maximum count of iterations", description="If not set, defines an unlimited number of iterations.")
        private Property<Integer> maxIterations;
        @Schema(title="Maximum duration of the task", description="If not set, defines an unlimited maximum duration of iterations.")
        private Property<Duration> maxDuration;
        @Schema(title="Interval between each iteration")
        @NotNull
        private Property<Duration> interval;

        @Generated
        private static Property<Duration> $default$interval() {
            return Property.ofValue(Duration.ofMinutes(1L));
        }

        @Generated
        protected CheckFrequency(CheckFrequencyBuilder<?, ?> b) {
            this.maxIterations = b.maxIterations;
            this.maxDuration = b.maxDuration;
            this.interval = b.interval$set ? b.interval$value : CheckFrequency.$default$interval();
        }

        @Generated
        public static CheckFrequencyBuilder<?, ?> builder() {
            return new CheckFrequencyBuilderImpl();
        }

        @Generated
        public CheckFrequencyBuilder<?, ?> toBuilder() {
            return new CheckFrequencyBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Property<Integer> getMaxIterations() {
            return this.maxIterations;
        }

        @Generated
        public Property<Duration> getMaxDuration() {
            return this.maxDuration;
        }

        @Generated
        public Property<Duration> getInterval() {
            return this.interval;
        }

        @Generated
        public CheckFrequency() {
            this.interval = CheckFrequency.$default$interval();
        }

        @Generated
        public static abstract class CheckFrequencyBuilder<C extends CheckFrequency, B extends CheckFrequencyBuilder<C, B>> {
            @Generated
            private Property<Integer> maxIterations;
            @Generated
            private Property<Duration> maxDuration;
            @Generated
            private boolean interval$set;
            @Generated
            private Property<Duration> interval$value;

            @Generated
            protected B $fillValuesFrom(C instance) {
                CheckFrequencyBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(CheckFrequency instance, CheckFrequencyBuilder<?, ?> b) {
                b.maxIterations(instance.maxIterations);
                b.maxDuration(instance.maxDuration);
                b.interval(instance.interval);
            }

            @Generated
            public B maxIterations(Property<Integer> maxIterations) {
                this.maxIterations = maxIterations;
                return this.self();
            }

            @Generated
            public B maxDuration(Property<Duration> maxDuration) {
                this.maxDuration = maxDuration;
                return this.self();
            }

            @Generated
            public B interval(Property<Duration> interval) {
                this.interval$value = interval;
                this.interval$set = true;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LoopUntil.CheckFrequency.CheckFrequencyBuilder(maxIterations=" + String.valueOf(this.maxIterations) + ", maxDuration=" + String.valueOf(this.maxDuration) + ", interval$value=" + String.valueOf(this.interval$value) + ")";
            }
        }

        @Generated
        private static final class CheckFrequencyBuilderImpl
        extends CheckFrequencyBuilder<CheckFrequency, CheckFrequencyBuilderImpl> {
            @Generated
            private CheckFrequencyBuilderImpl() {
            }

            @Override
            @Generated
            protected CheckFrequencyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CheckFrequency build() {
                return new CheckFrequency(this);
            }
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private Integer iterationCount;

        @ConstructorProperties(value={"iterationCount"})
        @Generated
        Output(Integer iterationCount) {
            this.iterationCount = iterationCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Integer getIterationCount() {
            return this.iterationCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Integer iterationCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder iterationCount(Integer iterationCount) {
                this.iterationCount = iterationCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.iterationCount);
            }

            @Generated
            public String toString() {
                return "LoopUntil.Output.OutputBuilder(iterationCount=" + this.iterationCount + ")";
            }
        }
    }

    @Generated
    public static abstract class LoopUntilBuilder<C extends LoopUntil, B extends LoopUntilBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;
        @Generated
        private List<Task> tasks;
        @Generated
        private Property<String> condition;
        @Generated
        private boolean failOnMaxReached$set;
        @Generated
        private Property<Boolean> failOnMaxReached$value;
        @Generated
        private boolean checkFrequency$set;
        @Generated
        private CheckFrequency checkFrequency$value;

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Generated
        public B condition(Property<String> condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B failOnMaxReached(Property<Boolean> failOnMaxReached) {
            this.failOnMaxReached$value = failOnMaxReached;
            this.failOnMaxReached$set = true;
            return (B)this.self();
        }

        @Generated
        public B checkFrequency(CheckFrequency checkFrequency) {
            this.checkFrequency$value = checkFrequency;
            this.checkFrequency$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LoopUntil.LoopUntilBuilder(super=" + super.toString() + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.tasks) + ", condition=" + String.valueOf(this.condition) + ", failOnMaxReached$value=" + String.valueOf(this.failOnMaxReached$value) + ", checkFrequency$value=" + String.valueOf(this.checkFrequency$value) + ")";
        }
    }

    @Generated
    private static final class LoopUntilBuilderImpl
    extends LoopUntilBuilder<LoopUntil, LoopUntilBuilderImpl> {
        @Generated
        private LoopUntilBuilderImpl() {
        }

        @Override
        @Generated
        protected LoopUntilBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LoopUntil build() {
            return new LoopUntil(this);
        }
    }
}

