/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.GraphUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

@Schema(title="Run tasks in parallel.", description="This task runs all child tasks in parallel.")
@Plugin(examples={@Example(full=true, title="Run tasks in parallel\n", code={"id: parallel\nnamespace: company.team\n\ntasks:\n  - id: parallel\n    type: io.kestra.plugin.core.flow.Parallel\n    tasks:\n      - id: 1st\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n\n      - id: 2nd\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ task.id }} > {{ taskrun.id }}\"\n\n  - id: last\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ task.id }} > {{ taskrun.startDate }}\"\n"}), @Example(full=true, title="Run two sequences in parallel\n", code={"    id: parallel_sequences\n    namespace: company.team\n\n    tasks:\n    - id: parallel\n        type: io.kestra.plugin.core.flow.Parallel\n        tasks:\n        - id: sequence1\n            type: io.kestra.plugin.core.flow.Sequential\n            tasks:\n            - id: task1\n                type: io.kestra.plugin.core.debug.Return\n                format: \"{{ task.id }}\"\n\n            - id: task2\n                type: io.kestra.plugin.core.debug.Return\n                format: \"{{ task.id }}\"\n\n        - id: sequence2\n            type: io.kestra.plugin.core.flow.Sequential\n            tasks:\n            - id: task3\n                type: io.kestra.plugin.core.debug.Return\n                format: \"{{ task.id }}\"\n\n            - id: task4\n                type: io.kestra.plugin.core.debug.Return\n                format: \"{{ task.id }}\"\n"})}, aliases={"io.kestra.core.tasks.flows.Parallel"})
public class Parallel
extends Task
implements FlowableTask<VoidOutput> {
    @NotNull
    @Schema(title="Number of concurrent parallel tasks that can be running at any point in time", description="If the value is `0`, no limit exist and all tasks will start at the same time.")
    private final Property<Integer> concurrent;
    @Valid
    @PluginProperty
    @NotEmpty
    @NotNull
    private @Valid @NotEmpty @NotNull List<@NotNull Task> tasks;
    @Valid
    protected List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.PARALLEL);
        GraphUtils.parallel(subGraph, this.tasks, this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.tasks != null ? this.tasks.stream() : Stream.empty(), Stream.concat(this.errors != null ? this.errors.stream() : Stream.empty(), this._finally != null ? this._finally.stream() : Stream.empty())).toList();
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveTasks(this.tasks, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveParallelNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun, runContext.render(this.concurrent).as(Integer.class).orElseThrow());
    }

    @Generated
    private static Property<Integer> $default$concurrent() {
        return Property.ofValue(0);
    }

    @Generated
    protected Parallel(ParallelBuilder<?, ?> b) {
        super(b);
        this.concurrent = b.concurrent$set ? b.concurrent$value : Parallel.$default$concurrent();
        this.tasks = b.tasks;
        this.errors = b.errors;
        this._finally = b._finally;
    }

    @Generated
    public static ParallelBuilder<?, ?> builder() {
        return new ParallelBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Parallel(super=" + super.toString() + ", concurrent=" + String.valueOf(this.getConcurrent()) + ", tasks=" + String.valueOf(this.getTasks()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parallel)) {
            return false;
        }
        Parallel other = (Parallel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Integer> this$concurrent = this.getConcurrent();
        Property<Integer> other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        return !(this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Parallel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Integer> $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        return result;
    }

    @Generated
    public Property<Integer> getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public List<@NotNull Task> getTasks() {
        return this.tasks;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public Parallel() {
        this.concurrent = Parallel.$default$concurrent();
    }

    @Generated
    public static abstract class ParallelBuilder<C extends Parallel, B extends ParallelBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean concurrent$set;
        @Generated
        private Property<Integer> concurrent$value;
        @Generated
        private List<@NotNull Task> tasks;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;

        @Generated
        public B concurrent(Property<Integer> concurrent) {
            this.concurrent$value = concurrent;
            this.concurrent$set = true;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<@NotNull Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Parallel.ParallelBuilder(super=" + super.toString() + ", concurrent$value=" + String.valueOf(this.concurrent$value) + ", tasks=" + String.valueOf(this.tasks) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ")";
        }
    }

    @Generated
    private static final class ParallelBuilderImpl
    extends ParallelBuilder<Parallel, ParallelBuilderImpl> {
        @Generated
        private ParallelBuilderImpl() {
        }

        @Override
        @Generated
        protected ParallelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Parallel build() {
            return new Parallel(this);
        }
    }
}

