/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.HttpResponse;
import io.kestra.core.http.client.HttpClient;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.common.EncryptedString;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.http.AbstractHttp;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

@Schema(title="Make an HTTP API request to a specified URL and store the response as an output.", description="This task makes an API call to a specified URL of an HTTP server and stores the response as an output.\nKestra offers hundreds of plugins. Before using the generic HTTP task, check if a dedicated plugin fits your use case \u2014 it's recommended to use plugins first and only fall back to HTTP when needed.\nBy default, the maximum length of the response is limited to 10MB, but it can be increased to at most 2GB by using the `options.maxContentLength` property.\nNote that the response is added as an output of the task. If you need to process large API payloads, we recommend using the `Download` task instead.")
@Plugin(examples={@Example(title="Execute a Kestra flow via an HTTP POST request authenticated with basic auth. To pass a `user` input to the API call, we use the `formData` property. When using form data, make sure to set the `contentType` property to `multipart/form-data`.", full=true, code={"id: api_call\nnamespace: company.team\n\ntasks:\n  - id: basic_auth_api\n    type: io.kestra.plugin.core.http.Request\n    uri: http://host.docker.internal:8080/api/v1/executions/dev/inputs_demo\n    options:\n      auth:\n        type: BASIC\n        username: \"{{ secret('API_USERNAME') }}\"\n        password: \"{{ secret('API_PASSWORD') }}\"\n    method: POST\n    contentType: multipart/form-data\n    formData:\n      user: John Doe\n"}), @Example(title="Execute a Kestra flow via an HTTP request authenticated with a Bearer auth token / JWT token.", full=true, code={"id: jwt_auth_call\nnamespace: company.team\n\ntasks:\n  - id: auth_token_api\n    type: io.kestra.plugin.core.http.Request\n    uri: https://dummyjson.com/user/me\n    method: GET\n    headers:\n      Authorization: 'Bearer <TOKEN>'\n"}), @Example(title="Execute a Kestra flow via an HTTP request authenticated with an API key passed in the header.", full=true, code={"id: api_key_auth_call\nnamespace: company.team\n\ntasks:\n  - id: api_key_auth\n    type: io.kestra.plugin.core.http.Request\n    uri: https://dummyjson.com/user/me\n    method: GET\n    headers:\n      X-API-KEY: abcde12345\n"}), @Example(title="Execute a Kestra flow via an HTTP request authenticated with an API key passed in the query parameters.", full=true, code={"id: api_key_auth_call\nnamespace: company.team\n\ntasks:\n  - id: api_key_in_query_params\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://dummyjson.com/user/me?api_key={{ secret('API_KEY') }}\"\n    method: GET\n"}), @Example(title="Make an HTTP GET request with a timeout. The `timeout` property specifies the maximum time allowed for the entire task to run, while the `options.connectTimeout`, `options.readTimeout`, `options.connectionPoolIdleTimeout`, and `options.readIdleTimeout` properties specify the time allowed for establishing a connection, reading data from the server, keeping an idle connection in the client's connection pool, and keeping a read connection idle before closing it, respectively.", full=true, code={"id: timeout\nnamespace: company.team\n\ntasks:\n  - id: http\n    type: io.kestra.plugin.core.http.Request\n    uri: https://reqres.in/api/long-request\n    timeout: PT10M # no default\n    method: GET\n    options:\n      connectTimeout: PT1M # no default\n      readTimeout: PT30S # 10 seconds by default\n      connectionPoolIdleTimeout: PT10S # 0 seconds by default\n      readIdleTimeout: PT10M # 300 seconds by default\n"}), @Example(title="Make a HTTP request and process its output. Given that we send a JSON payload in the request body, we need to use `application/json` as content type.", full=true, code={"id: http_post_request_example\nnamespace: company.team\n\ninputs:\n  - id: payload\n    type: JSON\n    defaults: |\n      {\"title\": \"Kestra Pen\"}\n\ntasks:\n  - id: send_data\n    type: io.kestra.plugin.core.http.Request\n    uri: https://dummyjson.com/products/add\n    method: POST\n    contentType: application/json\n    body: \"{{ inputs.payload }}\"\n\n  - id: print_status\n    type: io.kestra.plugin.core.log.Log\n    message: '{{ outputs.send_data.body }}'\n"}), @Example(title="Send an HTTP POST request to a webserver.", full=true, code={"id: http_post_request_example\nnamespace: company.team\n\ntasks:\n  - id: send_data\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://server.com/login\"\n    headers:\n      user-agent: \"kestra-io\"\n    method: \"POST\"\n    formData:\n      user: \"user\"\n      password: \"pass\"\n"}), @Example(title="Send a multipart HTTP POST request to a webserver.", full=true, code={"id: http_post_multipart_example\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: send_data\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://server.com/upload\"\n    headers:\n      user-agent: \"kestra-io\"\n    method: \"POST\"\n    contentType: \"multipart/form-data\"\n    formData:\n      user: \"{{ inputs.file }}\"\n"}), @Example(title="Send a multipart HTTP POST request to a webserver and set a custom file name.", full=true, code={"id: http_post_multipart_example\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: send_data\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://server.com/upload\"\n    headers:\n      user-agent: \"kestra-io\"\n    method: \"POST\"\n    contentType: \"multipart/form-data\"\n    formData:\n      user:\n        name: \"my-file.txt\"\n        content: \"{{ inputs.file }}\"\n"}), @Example(title="Upload an image using HTTP POST request to a webserver.", full=true, code={"id: http_upload_image\nnamespace: company.team\n\ntasks:\n  - id: s3_download\n    type: io.kestra.plugin.aws.s3.Download\n    accessKeyId: \"{{ secret('AWS_ACCESS_KEY_ID')}}\"\n    secretKeyId: \"{{ secret('AWS_SECRET_KEY_ID')}}\"\n    region: \"eu-central-1\"\n    bucket: \"my-bucket\"\n    key: \"path/to/file/my_image.jpeg\"\n\n  - id: send_data\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://server.com/upload\"\n    headers:\n      user-agent: \"kestra-io\"\n    method: \"POST\"\n    contentType: \"image/jpeg\"\n    formData:\n      user:\n        file: \"my-image.jpeg\"\n        url: \"{{ outputs.s3_download.uri }}\"\n        metadata:\n          description: \"my favorite image\"\n"}), @Example(title="Upload a CSV file using HTTP POST request to a webserver.", full=true, code={"id: http_csv_file_upload\nnamespace: company.team\n\ntasks:\n  - id: http_download\n    type: io.kestra.plugin.core.http.Download\n    uri: https://huggingface.co/datasets/kestra/datasets/raw/main/csv/orders.csv\n\n  - id: upload\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://server.com/upload\"\n    headers:\n      user-agent: \"kestra-io\"\n    method: \"POST\"\n    contentType: \"multipart/form-data\"\n    formData:\n      url: \"{{ outputs.http_download.uri }}\"\n"}), @Example(title="Send a multiline JSON message using HTTP POST request and inputs with a pebble expression. We recommend this method to avoid JSON string interpolation", full=true, code={"id: http_multiline_json\nnamespace: company.team\n\ninputs:\n  - id: title\n    type: STRING\n    defaults: This is the title of the request\n  - id: message\n    type: STRING\n    defaults: |-\n      This is my long\n      multiline message.\n  - id: priority\n    type: INT\n    defaults: 5\n\ntasks:\n  - id: send\n    type: io.kestra.plugin.core.http.Request\n    uri: \"https://reqres.in/api/test-request\"\n    method: \"POST\"\n    body: |\n      {{ {\n        \"title\": inputs.title,\n        \"message\": inputs.message,\n        \"priority\": inputs.priority\n      } }}\n"})}, aliases={"io.kestra.plugin.fs.http.Request"})
public class Request
extends AbstractHttp
implements RunnableTask<Output> {
    @Schema(title="If true, the HTTP response body will be automatically encrypted and decrypted in the outputs, provided that encryption is configured in your Kestra configuration.", description="If this property is set to `true`, this task will output the request body using the `encryptedBody` output property; otherwise, the request body will be stored in the `body` output property.")
    private Property<Boolean> encryptBody;

    @Override
    public Output run(RunContext runContext) throws Exception {
        try (HttpClient client = this.client(runContext);){
            OptionalInt illegalChar;
            HttpRequest request = this.request(runContext);
            HttpResponse<Byte[]> response = client.request(request, Byte[].class);
            String body = null;
            if (response.getBody() != null) {
                body = IOUtils.toString((byte[])ArrayUtils.toPrimitive((Byte[])response.getBody()), (String)StandardCharsets.UTF_8.name());
            }
            if (body != null && (illegalChar = body.chars().filter(c -> !Character.isDefined(c)).findFirst()).isPresent()) {
                throw new IllegalArgumentException("Illegal unicode code point in request body: " + illegalChar.getAsInt() + ", the Request task only support valid Unicode strings as body.\nYou can try using the Download task instead.");
            }
            Output output = this.output(runContext, request, response, body);
            return output;
        }
    }

    public Output output(RunContext runContext, HttpRequest request, HttpResponse<Byte[]> response, String body) throws GeneralSecurityException, URISyntaxException, IOException, IllegalVariableEvaluationException {
        boolean encrypt = runContext.render(this.encryptBody).as(Boolean.class).orElseThrow();
        return Output.builder().code(response.getStatus().getCode()).headers(response.getHeaders().map()).uri(request.getUri()).body(encrypt ? null : body).encryptedBody(encrypt ? EncryptedString.from(body, runContext) : null).build();
    }

    @Generated
    private static Property<Boolean> $default$encryptBody() {
        return Property.ofValue(false);
    }

    @Generated
    protected Request(RequestBuilder<?, ?> b) {
        super((AbstractHttp.AbstractHttpBuilder<?, ?>)b);
        this.encryptBody = b.encryptBody$set ? b.encryptBody$value : Request.$default$encryptBody();
    }

    @Generated
    public static RequestBuilder<?, ?> builder() {
        return new RequestBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Request(super=" + super.toString() + ", encryptBody=" + String.valueOf(this.getEncryptBody()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$encryptBody = this.getEncryptBody();
        Property<Boolean> other$encryptBody = other.getEncryptBody();
        return !(this$encryptBody == null ? other$encryptBody != null : !((Object)this$encryptBody).equals(other$encryptBody));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $encryptBody = this.getEncryptBody();
        result = result * 59 + ($encryptBody == null ? 43 : ((Object)$encryptBody).hashCode());
        return result;
    }

    @Generated
    public Property<Boolean> getEncryptBody() {
        return this.encryptBody;
    }

    @Generated
    public Request() {
        this.encryptBody = Request.$default$encryptBody();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The URL of the current request")
        private final URI uri;
        @Schema(title="The status code of the response")
        private final Integer code;
        @Schema(title="The headers of the response")
        @PluginProperty(additionalProperties=List.class)
        private final Map<String, List<String>> headers;
        @Schema(title="The body of the response", description="Kestra, by default, stores the task output using this property. However, if the `encryptBody` property is set to `true`, Kestra will instead encrypt the output and store it using the `encryptedBody` output property.")
        private Object body;
        @Schema(title="The encrypted body of the response", description="If the `encryptBody` property is set to `true`, Kestra will automatically encrypt the output before storing it, and decrypt it when the output is retrieved in a downstream task.")
        private EncryptedString encryptedBody;
        @Schema(title="The form data to be sent in the request body", description="When sending a file, you can pass a list of maps (i.e., a list of key-value pairs) with a key 'name' and value of the filename, as well as 'content' key with the file's content as value (e.g., passed from flow inputs or outputs from another task).")
        @PluginProperty(dynamic=true)
        protected Map<String, Object> formData;

        @ConstructorProperties(value={"uri", "code", "headers", "body", "encryptedBody", "formData"})
        @Generated
        Output(URI uri, Integer code, Map<String, List<String>> headers, Object body, EncryptedString encryptedBody, Map<String, Object> formData) {
            this.uri = uri;
            this.code = code;
            this.headers = headers;
            this.body = body;
            this.encryptedBody = encryptedBody;
            this.formData = formData;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public OutputBuilder toBuilder() {
            return new OutputBuilder().uri(this.uri).code(this.code).headers(this.headers).body(this.body).encryptedBody(this.encryptedBody).formData(this.formData);
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public Object getBody() {
            return this.body;
        }

        @Generated
        public EncryptedString getEncryptedBody() {
            return this.encryptedBody;
        }

        @Generated
        public Map<String, Object> getFormData() {
            return this.formData;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Integer code;
            @Generated
            private Map<String, List<String>> headers;
            @Generated
            private Object body;
            @Generated
            private EncryptedString encryptedBody;
            @Generated
            private Map<String, Object> formData;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder code(Integer code) {
                this.code = code;
                return this;
            }

            @Generated
            public OutputBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public OutputBuilder body(Object body) {
                this.body = body;
                return this;
            }

            @Generated
            public OutputBuilder encryptedBody(EncryptedString encryptedBody) {
                this.encryptedBody = encryptedBody;
                return this;
            }

            @Generated
            public OutputBuilder formData(Map<String, Object> formData) {
                this.formData = formData;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.code, this.headers, this.body, this.encryptedBody, this.formData);
            }

            @Generated
            public String toString() {
                return "Request.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ", code=" + this.code + ", headers=" + String.valueOf(this.headers) + ", body=" + String.valueOf(this.body) + ", encryptedBody=" + String.valueOf(this.encryptedBody) + ", formData=" + String.valueOf(this.formData) + ")";
            }
        }
    }

    @Generated
    public static abstract class RequestBuilder<C extends Request, B extends RequestBuilder<C, B>>
    extends AbstractHttp.AbstractHttpBuilder<C, B> {
        @Generated
        private boolean encryptBody$set;
        @Generated
        private Property<Boolean> encryptBody$value;

        @Generated
        public B encryptBody(Property<Boolean> encryptBody) {
            this.encryptBody$value = encryptBody;
            this.encryptBody$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Request.RequestBuilder(super=" + super.toString() + ", encryptBody$value=" + String.valueOf(this.encryptBody$value) + ")";
        }
    }

    @Generated
    private static final class RequestBuilderImpl
    extends RequestBuilder<Request, RequestBuilderImpl> {
        @Generated
        private RequestBuilderImpl() {
        }

        @Override
        @Generated
        protected RequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Request build() {
            return new Request(this);
        }
    }
}

