/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.plugin.core.kv.PurgeBehavior;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import lombok.Generated;

public class Key
extends PurgeBehavior {
    @NotNull
    @JsonInclude
    protected String type;
    @Schema(title="Delete only expired keys")
    private boolean expiredOnly;

    @Override
    protected List<KVEntry> entriesToPurge(KVStore kvStore) throws IOException {
        return kvStore.listAll().stream().filter(kv -> !this.expiredOnly || kv.expirationDate() != null && kv.expirationDate().isBefore(Instant.now())).toList();
    }

    @Generated
    private static String $default$type() {
        return "key";
    }

    @Generated
    private static boolean $default$expiredOnly() {
        return true;
    }

    @Generated
    protected Key(KeyBuilder<?, ?> b) {
        super(b);
        this.type = b.type$set ? b.type$value : Key.$default$type();
        this.expiredOnly = b.expiredOnly$set ? b.expiredOnly$value : Key.$default$expiredOnly();
    }

    @Generated
    public static KeyBuilder<?, ?> builder() {
        return new KeyBuilderImpl();
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean isExpiredOnly() {
        return this.expiredOnly;
    }

    @Generated
    public Key() {
        this.type = Key.$default$type();
        this.expiredOnly = Key.$default$expiredOnly();
    }

    @Generated
    public static abstract class KeyBuilder<C extends Key, B extends KeyBuilder<C, B>>
    extends PurgeBehavior.PurgeBehaviorBuilder<C, B> {
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private boolean expiredOnly$set;
        @Generated
        private boolean expiredOnly$value;

        @Generated
        public B type(String type) {
            this.type$value = type;
            this.type$set = true;
            return (B)this.self();
        }

        @Generated
        public B expiredOnly(boolean expiredOnly) {
            this.expiredOnly$value = expiredOnly;
            this.expiredOnly$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Key.KeyBuilder(super=" + super.toString() + ", type$value=" + this.type$value + ", expiredOnly$value=" + this.expiredOnly$value + ")";
        }
    }

    @Generated
    private static final class KeyBuilderImpl
    extends KeyBuilder<Key, KeyBuilderImpl> {
        @Generated
        private KeyBuilderImpl() {
        }

        @Override
        @Generated
        protected KeyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Key build() {
            return new Key(this);
        }
    }
}

