/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.namespace;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.Namespace;
import io.kestra.core.utils.PathMatcherPredicate;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.net.URI;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Download one or multiple files from your namespace files.", description="Use a regex glob pattern or a file path to download files from your namespace files. This can be useful to share code between projects and teams, which is located in different namespaces.")
@Plugin(examples={@Example(title="Download a namespace file.", full=true, code={"id: download_file\nnamespace: company.team\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.namespace.DownloadFiles\n    namespace: tutorial\n    files:\n      - \"**input.txt\"\n"}), @Example(title="Download all namespace files from a specific namespace.", full=true, code={"id: download_all_files\nnamespace: company.team\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.namespace.DownloadFiles\n    namespace: tutorial\n    files:\n      - \"**\"\n"})})
public class DownloadFiles
extends Task
implements RunnableTask<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadFiles.class);
    @NotNull
    @Schema(title="The namespace from which you want to download files")
    private Property<String> namespace;
    @NotNull
    @Schema(title="A file or a list of files from the given namespace", description="String or a list of strings; each string can either be a regex glob pattern or a file path URI.", anyOf={List.class, String.class})
    @PluginProperty(dynamic=true)
    private Object files;
    @Schema(title="The folder where the downloaded files will be stored")
    private Property<String> destination;

    @Override
    public Output run(RunContext runContext) throws Exception {
        List<String> renderedFiles;
        Logger logger = runContext.logger();
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElseThrow();
        String renderedDestination = runContext.render(this.destination).as(String.class).orElseThrow();
        Namespace namespace = runContext.storage().namespace(renderedNamespace);
        Object object = this.files;
        if (object instanceof String) {
            String filesString = (String)object;
            renderedFiles = List.of(runContext.render(filesString));
        } else {
            object = this.files;
            if (object instanceof List) {
                List filesList = (List)object;
                renderedFiles = runContext.render(filesList);
            } else {
                throw new IllegalArgumentException("The files property must be a string or a list of strings.");
            }
        }
        Map<String, URI> downloaded = namespace.findAllFilesMatching(PathMatcherPredicate.matches(renderedFiles)).stream().map(Rethrow.throwFunction(file -> {
            try (InputStream is = runContext.storage().getFile(file.uri());){
                URI uri = runContext.storage().putFile(is, renderedDestination + file.path());
                logger.debug(String.format("Downloaded %s", uri));
                AbstractMap.SimpleEntry<String, URI> simpleEntry = new AbstractMap.SimpleEntry<String, URI>(file.path(true).toString(), uri);
                return simpleEntry;
            }
        })).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        runContext.metric(Counter.of("downloaded", downloaded.size(), new String[0]));
        return Output.builder().files(downloaded).build();
    }

    @Generated
    private static Property<String> $default$destination() {
        return Property.ofValue("");
    }

    @Generated
    protected DownloadFiles(DownloadFilesBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.files = b.files;
        this.destination = b.destination$set ? b.destination$value : DownloadFiles.$default$destination();
    }

    @Generated
    public static DownloadFilesBuilder<?, ?> builder() {
        return new DownloadFilesBuilderImpl();
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Object getFiles() {
        return this.files;
    }

    @Generated
    public Property<String> getDestination() {
        return this.destination;
    }

    @Generated
    public DownloadFiles() {
        this.destination = DownloadFiles.$default$destination();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Downloaded files", description="The task returns a map containing the file path as a key and the file URI as a value.")
        private final Map<String, URI> files;

        @ConstructorProperties(value={"files"})
        @Generated
        Output(Map<String, URI> files) {
            this.files = files;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, URI> getFiles() {
            return this.files;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, URI> files;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder files(Map<String, URI> files) {
                this.files = files;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.files);
            }

            @Generated
            public String toString() {
                return "DownloadFiles.Output.OutputBuilder(files=" + String.valueOf(this.files) + ")";
            }
        }
    }

    @Generated
    public static abstract class DownloadFilesBuilder<C extends DownloadFiles, B extends DownloadFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Object files;
        @Generated
        private boolean destination$set;
        @Generated
        private Property<String> destination$value;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B files(Object files) {
            this.files = files;
            return (B)this.self();
        }

        @Generated
        public B destination(Property<String> destination) {
            this.destination$value = destination;
            this.destination$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DownloadFiles.DownloadFilesBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", files=" + String.valueOf(this.files) + ", destination$value=" + String.valueOf(this.destination$value) + ")";
        }
    }

    @Generated
    private static final class DownloadFilesBuilderImpl
    extends DownloadFilesBuilder<DownloadFiles, DownloadFilesBuilderImpl> {
        @Generated
        private DownloadFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected DownloadFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DownloadFiles build() {
            return new DownloadFiles(this);
        }
    }
}

