/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.output;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;

@Schema(title="Output one or more values.", description="You can use this task to return some outputs and pass them to downstream tasks.\nIt's helpful for parsing and returning values from a task. You can then access these outputs in your downstream tasks\nusing the expression `{{ outputs.mytask_id.values.my_output_name }}` and you can see them in the Outputs tab.\nThe values can be strings, numbers, arrays, or any valid JSON object.\n")
@Plugin(examples={@Example(full=true, code={"id: outputs_flow\nnamespace: company.team\n\ntasks:\n  - id: output_values\n    type: io.kestra.plugin.core.output.OutputValues\n    values:\n      taskrun_data: \"{{ task.id }} > {{ taskrun.startDate }}\"\n      execution_data: \"{{ flow.id }} > {{ execution.startDate }}\"\n      number_value: 42\n      array_value: [\"{{ task.id }}\", \"{{ flow.id }}\", \"static value\"]\n      nested_object:\n        key1: \"value1\"\n        key2: \"{{ execution.id }}\"\n\n  - id: log_values\n    type: io.kestra.plugin.core.log.Log\n    message: |\n      Got the following outputs from the previous task:\n      {{ outputs.output_values.values.taskrun_data }}\n      {{ outputs.output_values.values.execution_data }}\n      {{ outputs.output_values.values.number_value }}\n      {{ outputs.output_values.values.array_value[1] }}\n      {{ outputs.output_values.values.nested_object.key2 }}"})})
public class OutputValues
extends Task
implements RunnableTask<Output> {
    @Schema(title="The templated strings to render", description="These values can be strings, numbers, arrays, or objects. Templated strings (enclosed in {{ }}) will be rendered using the current context.")
    private Property<Map<String, Object>> values;

    @Override
    public Output run(RunContext runContext) throws Exception {
        return Output.builder().values(runContext.render(this.values).asMap(String.class, Object.class)).build();
    }

    @Generated
    protected OutputValues(OutputValuesBuilder<?, ?> b) {
        super(b);
        this.values = b.values;
    }

    @Generated
    public static OutputValuesBuilder<?, ?> builder() {
        return new OutputValuesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "OutputValues(super=" + super.toString() + ", values=" + String.valueOf(this.getValues()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputValues)) {
            return false;
        }
        OutputValues other = (OutputValues)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Map<String, Object>> this$values = this.getValues();
        Property<Map<String, Object>> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputValues;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Map<String, Object>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public Property<Map<String, Object>> getValues() {
        return this.values;
    }

    @Generated
    public OutputValues() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The generated values")
        private Map<String, Object> values;

        @ConstructorProperties(value={"values"})
        @Generated
        Output(Map<String, Object> values) {
            this.values = values;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, Object> getValues() {
            return this.values;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, Object> values;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder values(Map<String, Object> values) {
                this.values = values;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.values);
            }

            @Generated
            public String toString() {
                return "OutputValues.Output.OutputBuilder(values=" + String.valueOf(this.values) + ")";
            }
        }
    }

    @Generated
    public static abstract class OutputValuesBuilder<C extends OutputValues, B extends OutputValuesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<Map<String, Object>> values;

        @Generated
        public B values(Property<Map<String, Object>> values) {
            this.values = values;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OutputValues.OutputValuesBuilder(super=" + super.toString() + ", values=" + String.valueOf(this.values) + ")";
        }
    }

    @Generated
    private static final class OutputValuesBuilderImpl
    extends OutputValuesBuilder<OutputValues, OutputValuesBuilderImpl> {
        @Generated
        private OutputValuesBuilderImpl() {
        }

        @Override
        @Generated
        protected OutputValuesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OutputValues build() {
            return new OutputValues(this);
        }
    }
}

