/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Schema(title="Create temporary files (Deprecated).", description="This task is deprecated and replaced by the `inputFiles` property available in all script tasks and in the [WorkingDirectory](https://kestra.io/plugins/core/tasks/io.kestra.plugin.core.flow.workingdirectory) task. Check the [migration guide](https://kestra.io/docs/migration-guide/0.17.0/local-files) for more details. This task suffers from multiple limitations, such as that it cannot be skipped, so setting `disabled: true` will have no effect. Overall, the WorkingDirectory task is more flexible and should be used instead of this task. This task will be removed in a future version of Kestra.")
@Deprecated
@Plugin(examples={@Example(full=true, title="Output local files created in a Python task and load them to S3.", code={"    id: outputs_from_python_task\n    namespace: company.team\n\n    tasks:\n      - id: wdir\n        type: io.kestra.plugin.core.flow.WorkingDirectory\n        tasks:\n          - id: clone_repository\n            type: io.kestra.plugin.git.Clone\n            url: https://github.com/kestra-io/examples\n            branch: main\n\n          - id: git_python_scripts\n            type: io.kestra.plugin.scripts.python.Commands\n            runner: DOCKER\n            docker:\n              image: ghcr.io/kestra-io/pydata:latest\n            beforeCommands:\n              - pip install faker > /dev/null\n            commands:\n              - python examples/scripts/etl_script.py\n              - python examples/scripts/generate_orders.py\n\n          - id: export_files\n            type: io.kestra.plugin.core.storage.LocalFiles\n            outputs:\n              - orders.csv\n              - \"*.parquet\"\n\n      - id: load_csv_to_s3\n        type: io.kestra.plugin.aws.s3.Upload\n        accessKeyId: \"{{ secret('AWS_ACCESS_KEY_ID') }}\"\n        secretKeyId: \"{{ secret('AWS_SECRET_ACCESS_KEY') }}\"\n        region: eu-central-1\n        bucket: kestraio\n        key: stage/orders.csv\n        from: \"{{ outputs.export_files.outputFiles['orders.csv'] }}\"\n        disabled: true\n"}), @Example(full=true, title="Create a local file that will be accessible to a bash task.", code={"id: \"local_files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: working_dir\n    type: io.kestra.plugin.core.flow.WorkingDirectory\n    tasks:\n    - id: input_files\n      type: io.kestra.plugin.core.storage.LocalFiles\n      inputs:\n        hello.txt: \"Hello World\\n\"\n        address.json: \"{{ outputs.my_task_id.uri }}\"\n    - id: bash\n      type: io.kestra.plugin.scripts.shell.Commands\n      commands:\n        - cat hello.txt\n"}), @Example(full=true, title="Send local files to Kestra's internal storage.", code={"id: \"local_files\"\nnamespace: \"io.kestra.tests\"\n\ntasks:\n  - id: working_dir\n    type: io.kestra.plugin.core.flow.WorkingDirectory\n    tasks:\n    - id: bash\n      type: io.kestra.plugin.scripts.shell.Commands\n      commands:\n        - mkdir -p sub/dir\n        - echo \"Hello from Bash\" >> sub/dir/bash1.txt\n        - echo \"Hello from Bash\" >> sub/dir/bash2.txt\n    - id: output_files\n      type: io.kestra.plugin.core.storage.LocalFiles\n      outputs:\n        - sub/**\n"})}, aliases={"io.kestra.core.tasks.storages.LocalFiles"})
public class LocalFiles
extends Task
implements RunnableTask<LocalFilesOutput> {
    @Schema(title="The files to be created on the local filesystem; it can be a map or a JSON object.", oneOf={Map.class, String.class})
    @PluginProperty(dynamic=true)
    private Object inputs;
    @Schema(title="The files from the local filesystem to be sent to the Kestra's internal storage", description="Must be a list of [glob](https://en.wikipedia.org/wiki/Glob_(programming)) expressions relative to the current working directory, some examples: `my-dir/**`, `my-dir/*/**` or `my-dir/my-file.txt`.")
    private Property<List<String>> outputs;

    @Override
    public LocalFilesOutput run(RunContext runContext) throws Exception {
        FilesService.inputFiles(runContext, this.inputs);
        Map<String, URI> outputFiles = FilesService.outputFiles(runContext, runContext.render(this.outputs).asList(String.class));
        return LocalFilesOutput.builder().uris(outputFiles).build();
    }

    @Generated
    protected LocalFiles(LocalFilesBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.outputs = b.outputs;
    }

    @Generated
    public static LocalFilesBuilder<?, ?> builder() {
        return new LocalFilesBuilderImpl();
    }

    @Generated
    public String toString() {
        return "LocalFiles(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", outputs=" + String.valueOf(this.getOutputs()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFiles)) {
            return false;
        }
        LocalFiles other = (LocalFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$inputs = this.getInputs();
        Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        Property<List<String>> this$outputs = this.getOutputs();
        Property<List<String>> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalFiles;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        Property<List<String>> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    @Generated
    public Object getInputs() {
        return this.inputs;
    }

    @Generated
    public Property<List<String>> getOutputs() {
        return this.outputs;
    }

    @Generated
    public LocalFiles() {
    }

    public static class LocalFilesOutput
    implements Output {
        @Schema(title="The URI of the files that have been sent to the Kestra's internal storage")
        private Map<String, URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        LocalFilesOutput(Map<String, URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static LocalFilesOutputBuilder builder() {
            return new LocalFilesOutputBuilder();
        }

        @Generated
        public Map<String, URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class LocalFilesOutputBuilder {
            @Generated
            private Map<String, URI> uris;

            @Generated
            LocalFilesOutputBuilder() {
            }

            @Generated
            public LocalFilesOutputBuilder uris(Map<String, URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public LocalFilesOutput build() {
                return new LocalFilesOutput(this.uris);
            }

            @Generated
            public String toString() {
                return "LocalFiles.LocalFilesOutput.LocalFilesOutputBuilder(uris=" + String.valueOf(this.uris) + ")";
            }
        }
    }

    @Generated
    public static abstract class LocalFilesBuilder<C extends LocalFiles, B extends LocalFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object inputs;
        @Generated
        private Property<List<String>> outputs;

        @Generated
        public B inputs(Object inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B outputs(Property<List<String>> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LocalFiles.LocalFilesBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", outputs=" + String.valueOf(this.outputs) + ")";
        }
    }

    @Generated
    private static final class LocalFilesBuilderImpl
    extends LocalFilesBuilder<LocalFiles, LocalFilesBuilderImpl> {
        @Generated
        private LocalFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected LocalFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LocalFiles build() {
            return new LocalFiles(this);
        }
    }
}

